/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.items.dynamic_part.DynamicPartItem;
import dev.lopyluna.slag.content.items.modular.DataDynamicParts;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import dev.lopyluna.slag.register.AllItems;
import dev.lopyluna.slag.register.AllMaterials;
import dev.lopyluna.slag.register.AllModulars;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AllCreativeTabs {
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BASE_TAB = SlagEmbers.REGISTER.creativeTab().register("base_tab", () -> CreativeModeTab.builder().title((Component)Component.translatableWithFallback((String)"itemGroup.slag.base", (String)"Slag n' Embers")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> AllItems.MODULAR_ITEM.asStack()).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TOOLS_PARTS_TAB = SlagEmbers.REGISTER.creativeTab().register("tools_parts_tab", () -> CreativeModeTab.builder().title((Component)Component.translatableWithFallback((String)"itemGroup.slag.tools_parts", (String)"Tools & Parts")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> {
        MaterialType material = AllMaterials.GOLD;
        ModularType modular = AllModulars.MAUL;
        ItemStack baseTool = AllItems.MODULAR_ITEM.asStack();
        DynamicPartItem dynamicPart = (DynamicPartItem)AllItems.DYNAMIC_PART.get();
        ArrayList<ItemStack> toolParts = new ArrayList<ItemStack>();
        for (PartType part : AllDynamicTypes.getAllPartsFromModular(modular)) {
            ItemStack stack = dynamicPart.getDefaultInstance();
            dynamicPart.setMaterialType(stack, material);
            dynamicPart.setPartType(stack, part);
            stack.set(AllDataComponents.BUILT, (Object)modular.id);
            toolParts.add(stack);
        }
        if (modular.finalSegmentStacks != null && !modular.finalSegmentStacks.isEmpty()) {
            toolParts.addAll(modular.finalSegmentStacks);
        }
        if (material.fireProof) {
            baseTool.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
        }
        baseTool.set(AllDataComponents.DYNAMIC_PARTS, (Object)new DataDynamicParts(toolParts));
        baseTool.set(AllDataComponents.BAKED, (Object)modular.id);
        baseTool.set(AllDataComponents.MODULAR_TYPE, (Object)modular.id);
        return baseTool;
    }).withSearchBar().build());

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(BASE_TAB.getKey())) {
            event.remove(AllItems.DYNAMIC_PART.asStack(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey().equals(TOOLS_PARTS_TAB.getKey())) {
            ArrayList<ItemStack> variants = new ArrayList<ItemStack>();
            List<MaterialType> materials = AllDynamicTypes.getAllMaterials().stream().sorted(Comparator.comparingInt(type -> type.sortOrder)).toList();
            List<PartType> parts = AllDynamicTypes.getAllParts().stream().sorted(Comparator.comparingInt(type -> type.sortOrder)).toList();
            List<ModularType> modulars = AllDynamicTypes.getAllModulars().stream().sorted(Comparator.comparingInt(type -> type.sortOrder)).toList();
            for (MaterialType material : materials) {
                for (PartType part : parts) {
                    DynamicPartItem item = (DynamicPartItem)AllItems.DYNAMIC_PART.get();
                    ItemStack stack = item.getDefaultInstance();
                    item.setMaterialType(stack, material);
                    item.setPartType(stack, part);
                    variants.add(stack);
                }
            }
            for (MaterialType material : materials) {
                for (ModularType modular : modulars) {
                    ItemStack result = modular.getResultStack();
                    if (!result.isEmpty()) continue;
                    ItemStack baseTool = AllItems.MODULAR_ITEM.asStack();
                    ArrayList<ItemStack> toolParts = new ArrayList<ItemStack>();
                    for (PartType part : AllDynamicTypes.getAllPartsFromModular(modular)) {
                        DynamicPartItem dynamicPart = (DynamicPartItem)AllItems.DYNAMIC_PART.get();
                        ItemStack stack = dynamicPart.getDefaultInstance();
                        dynamicPart.setMaterialType(stack, material);
                        dynamicPart.setPartType(stack, part);
                        stack.set(AllDataComponents.BUILT, (Object)modular.id);
                        toolParts.add(stack);
                    }
                    if (modular.finalSegmentStacks != null && !modular.finalSegmentStacks.isEmpty()) {
                        toolParts.addAll(modular.finalSegmentStacks);
                    }
                    if (material.fireProof) {
                        baseTool.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
                    }
                    baseTool.set(AllDataComponents.DYNAMIC_PARTS, (Object)new DataDynamicParts(toolParts));
                    baseTool.set(AllDataComponents.BAKED, (Object)modular.id);
                    baseTool.set(AllDataComponents.MODULAR_TYPE, (Object)modular.id);
                    variants.add(baseTool);
                }
            }
            event.acceptAll(variants, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void register() {
    }
}

