/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.utils.Registration;
import dev.lopyluna.slag.register.AllTags;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AllFluids {
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_OBSIDIAN = AllFluids.newMoltenFluid("Obsidian", () -> 854802).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_AMETHYST = AllFluids.newMoltenFluid("Amethyst", () -> 12226276).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_COPPER = AllFluids.newMoltenFluid("Copper", () -> 13922124).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_DIAMOND = AllFluids.newMoltenFluid("Diamond", () -> 5890253).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_EMERALD = AllFluids.newMoltenFluid("Emerald", () -> 3790444).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_GOLD = AllFluids.newMoltenFluid("Gold", () -> 16509040).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_IRON = AllFluids.newMoltenFluid("Iron", () -> 12107716).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_LAPIS = AllFluids.newMoltenFluid("Lapis", () -> 3300274).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_NETHERITE = AllFluids.newMoltenFluid("Netherite", () -> 5787991).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_PRISMARINE = AllFluids.newMoltenFluid("Prismarine", () -> 8830639).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_QUARTZ = AllFluids.newMoltenFluid("Quartz", () -> 15459541).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_REDSTONE = AllFluids.newMoltenFluid("Redstone", () -> 13310217).register();
    public static final FluidEntry<LavaLikeFluid.Flowing> MOLTEN_ROSE_GOLD = AllFluids.newMoltenFluid("Rose Gold", () -> 16491691).register();

    public static FluidBuilder<LavaLikeFluid.Flowing, Registration> newMoltenFluid(String type, Supplier<Integer> hexColor) {
        String name = "Molten " + type;
        String id = name.toLowerCase().replace(" ", "_");
        return (FluidBuilder)AllFluids.standardFluidLavaLike(id, TintableFluidType.create(hexColor.get(), () -> Float.valueOf(0.025f))).lang(name).renderType(() -> RenderType::solid).properties(b -> b.lightLevel(12).viscosity(6000).density(1600).temperature(1000).canSwim(false).canDrown(false).pathType(PathType.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(10).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{AllTags.fluidC(id), FluidTags.LAVA}).source(LavaLikeFluid.Source::new).bucket().tag(new TagKey[]{AllTags.itemC("buckets/" + id)}).build();
    }

    public static void register() {
    }

    public static FluidBuilder<LavaLikeFluid.Flowing, Registration> standardFluidLavaLike(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return SlagEmbers.REG.fluid(name, SlagEmbers.loc("fluid/" + name + "_still"), SlagEmbers.loc("fluid/" + name + "_flow"), typeFactory, LavaLikeFluid.Flowing::new).tag(new TagKey[]{AllTags.HOT_FLUIDS});
    }

    public static FluidBuilder<BaseFlowingFluid.Flowing, Registration> standardFluid(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return SlagEmbers.REG.fluid(name, SlagEmbers.loc("fluid/" + name + "_still"), SlagEmbers.loc("fluid/" + name + "_flow"), typeFactory);
    }

    @ParametersAreNonnullByDefault
    private static class TintableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                TintableFluidType fluidType = new TintableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private TintableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    @ParametersAreNonnullByDefault
    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }

    @ParametersAreNonnullByDefault
    private static abstract class LavaLikeFluid
    extends BaseFlowingFluid {
        protected LavaLikeFluid(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
            BlockPos above = pos.above();
            if (level.getBlockState(above).isAir() && !level.getBlockState(above).isSolidRender((BlockGetter)level, above)) {
                if (random.nextInt(100) == 0) {
                    double d0 = (double)pos.getX() + random.nextDouble();
                    double d1 = (double)pos.getY() + 1.0;
                    double d2 = (double)pos.getZ() + random.nextDouble();
                    level.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
                if (random.nextInt(200) == 0) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
        }

        public void randomTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
            block7: {
                if (!level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
                int i = random.nextInt(3);
                if (i > 0) {
                    BlockPos relPos = pos;
                    for (int j = 0; j < i; ++j) {
                        if (!level.isLoaded(relPos = relPos.offset(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                            return;
                        }
                        BlockState relState = level.getBlockState(relPos);
                        if (relState.isAir()) {
                            if (!this.hasFlammableNeighbours((LevelReader)level, relPos)) continue;
                            level.setBlockAndUpdate(relPos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)relPos, (BlockPos)pos, (BlockState)BaseFireBlock.getState((BlockGetter)level, (BlockPos)relPos)));
                            return;
                        }
                        if (!relState.blocksMotion()) continue;
                        return;
                    }
                } else {
                    for (int k = 0; k < 3; ++k) {
                        BlockPos offset = pos.offset(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                        if (!level.isLoaded(offset)) {
                            return;
                        }
                        if (!level.isEmptyBlock(offset.above()) || !this.isFlammable((LevelReader)level, offset, Direction.UP)) continue;
                        level.setBlockAndUpdate(offset.above(), EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)offset.above(), (BlockPos)pos, (BlockState)BaseFireBlock.getState((BlockGetter)level, (BlockPos)offset)));
                    }
                }
            }
        }

        private boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
            for (Direction dir : Direction.values()) {
                if (!this.isFlammable(level, pos.relative(dir), dir.getOpposite())) continue;
                return true;
            }
            return false;
        }

        private boolean isFlammable(LevelReader pLevel, BlockPos pPos, Direction pFace) {
            if (pPos.getY() >= pLevel.getMinBuildHeight() && pPos.getY() < pLevel.getMaxBuildHeight() && !pLevel.hasChunkAt(pPos)) {
                return false;
            }
            BlockState state = pLevel.getBlockState(pPos);
            return state.ignitedByLava() && state.isFlammable((BlockGetter)pLevel, pPos, pFace);
        }

        protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
            this.fizz(level, pos);
        }

        private void fizz(LevelAccessor level, BlockPos pos) {
            level.levelEvent(1501, pos, 0);
        }

        protected boolean isRandomlyTicking() {
            return true;
        }

        public static class Source
        extends LavaLikeFluid {
            protected Source(BaseFlowingFluid.Properties properties) {
                super(properties);
            }

            public boolean isSource(FluidState fluidState) {
                return true;
            }

            public int getAmount(FluidState fluidState) {
                return 8;
            }
        }

        public static class Flowing
        extends LavaLikeFluid {
            protected Flowing(BaseFlowingFluid.Properties properties) {
                super(properties);
                this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
            }

            protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
                super.createFluidStateDefinition(builder);
                builder.add(new Property[]{LEVEL});
            }

            public boolean isSource(FluidState fluidState) {
                return false;
            }

            public int getAmount(FluidState fluidState) {
                return (Integer)fluidState.getValue((Property)LEVEL);
            }
        }
    }
}

