/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.slag.register;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.lopyluna.slag.SlagEmbers;
import dev.lopyluna.slag.content.AllUtils;
import dev.lopyluna.slag.content.datagen.DualCookingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.MeltingRecipeBuilder;
import dev.lopyluna.slag.content.datagen.TableCastingRecipeBuilder;
import dev.lopyluna.slag.content.items.dynamic_mold.DynamicMoldItem;
import dev.lopyluna.slag.content.items.dynamic_part.DynamicPartItem;
import dev.lopyluna.slag.content.items.modular.ModularEquipablesItem;
import dev.lopyluna.slag.content.items.old.BakedModularToolItem;
import dev.lopyluna.slag.content.items.old.ModularToolItem;
import dev.lopyluna.slag.content.items.old.ModularToolPartItem;
import dev.lopyluna.slag.content.types.MaterialType;
import dev.lopyluna.slag.content.types.ModularType;
import dev.lopyluna.slag.content.types.PartType;
import dev.lopyluna.slag.register.AllBlocks;
import dev.lopyluna.slag.register.AllCreativeTabs;
import dev.lopyluna.slag.register.AllDataComponents;
import dev.lopyluna.slag.register.AllDynamicTypes;
import dev.lopyluna.slag.register.AllFluids;
import dev.lopyluna.slag.register.AllTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;

public class AllItems {
    public static final List<PartType> PART_TYPES = AllDynamicTypes.getAllPartsList();
    public static final List<ModularType> MODULAR_TYPES = AllDynamicTypes.getAllModularsList();
    public static final List<MaterialType> MATERIAL_TYPES = AllDynamicTypes.getAllMaterialsList();
    public static final ItemEntry<DynamicPartItem> DYNAMIC_PART = SlagEmbers.REG.item("dynamic_part", DynamicPartItem::new).model((c, p) -> p.withExistingParent(c.getName(), "item/generated")).register();
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    public static final ItemEntry<ModularEquipablesItem> MODULAR_ITEM = SlagEmbers.REG.item("modular_item", ModularEquipablesItem::new).model((c, p) -> {
        p.withExistingParent(c.getName(), SlagEmbers.loc("item/no_transform_item"));
        ((ItemModelBuilder)p.withExistingParent(c.getName() + "_blueprint", "item/generated")).texture("layer0", SlagEmbers.loc("item/blueprint"));
        p.withExistingParent(c.getName() + "_baked", "item/generated");
        p.withExistingParent(c.getName() + "_baked_handheld", "item/handheld");
        ItemModelBuilder equipableModel = (ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_equipable", "item/generated");
        equipableModel.transforms().transform(ItemDisplayContext.HEAD).scale(0.0f).end();
        ItemModelBuilder bakedModel = (ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_trim", "item/generated");
        AllUtils.TRIM_MATERIALS.forEach((trim, value) -> {
            bakedModel.override().predicate(SlagEmbers.loc("armor_type"), 1.0f).predicate(SlagEmbers.locMC("trim_type"), value.floatValue()).model((ModelFile)((ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_boots_trim_" + trim.location().getPath(), "item/generated")).texture("layer0", SlagEmbers.locMC("trims/items/boots_trim_" + trim.location().getPath()))).end();
            bakedModel.override().predicate(SlagEmbers.loc("armor_type"), 2.0f).predicate(SlagEmbers.locMC("trim_type"), value.floatValue()).model((ModelFile)((ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_chestplate_trim_" + trim.location().getPath(), "item/generated")).texture("layer0", SlagEmbers.locMC("trims/items/chestplate_trim_" + trim.location().getPath()))).end();
            bakedModel.override().predicate(SlagEmbers.loc("armor_type"), 3.0f).predicate(SlagEmbers.locMC("trim_type"), value.floatValue()).model((ModelFile)((ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_helmet_trim_" + trim.location().getPath(), "item/generated")).texture("layer0", SlagEmbers.locMC("trims/items/helmet_trim_" + trim.location().getPath()))).end();
            bakedModel.override().predicate(SlagEmbers.loc("armor_type"), 4.0f).predicate(SlagEmbers.locMC("trim_type"), value.floatValue()).model((ModelFile)((ItemModelBuilder)p.withExistingParent(c.getName() + "_baked_leggings_trim_" + trim.location().getPath(), "item/generated")).texture("layer0", SlagEmbers.locMC("trims/items/leggings_trim_" + trim.location().getPath()))).end();
        });
    }).recipe((c, p) -> {
        Collection<MaterialType> materials = AllDynamicTypes.getAllMaterials();
        Collection<PartType> parts = AllDynamicTypes.getAllParts();
        if (materials.isEmpty() || parts.isEmpty()) {
            return;
        }
        DynamicPartItem item = (DynamicPartItem)DYNAMIC_PART.get();
        for (MaterialType material : materials) {
            for (PartType part : parts) {
                Fluid fluid;
                String partID = part.id.getPath();
                String matID = material.id.getPath();
                if (!partID.equals("axe_head") && !partID.equals("pickaxe_head") && !partID.equals("shovel_head") && !partID.equals("hoe_head") && !partID.equals("sword_blade") && !partID.equals("guard") && !partID.equals("plate") && !partID.equals("helmet") && !partID.equals("chestplate") && !partID.equals("leggings") && !partID.equals("boots")) continue;
                ItemStack stack = item.getDefaultInstance();
                stack.set(AllDataComponents.MATERIAL_TYPE, (Object)material.id);
                stack.set(AllDataComponents.PART_TYPE, (Object)part.id);
                if (!matID.equals("netherite")) {
                    AllItems.buildPattern(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemStack)stack), part).define(Character.valueOf('M'), material.repairMaterials.get()).define(Character.valueOf('R'), (ItemLike)Items.PAPER).unlockedBy("has_" + partID, RegistrateRecipeProvider.has(AllTags.itemC(partID + "s"))).save((RecipeOutput)p, SlagEmbers.loc("crafting/parts/" + partID + "_" + matID));
                }
                if ((fluid = material.moltenFluid.get()) == null) continue;
                TagKey<Item> cast = AllItems.getCast(part);
                int size = 72;
                if (fluid == AllFluids.MOLTEN_OBSIDIAN.getSource()) {
                    size = 648;
                }
                if ((size *= AllItems.getSize(part)) > 0 && fluid == AllFluids.MOLTEN_NETHERITE.getSource()) {
                    size = 72;
                }
                if (size <= 0) continue;
                if (cast != null) {
                    TableCastingRecipeBuilder.create(stack, fluid, size, cast).unlockedBy("has_" + partID, RegistrateRecipeProvider.has(AllTags.itemC(partID + "s"))).save((RecipeOutput)p, SlagEmbers.loc("casting/table/" + partID + "_" + matID));
                }
                MeltingRecipeBuilder.create(fluid, size, stack).unlockedBy("has_" + partID, RegistrateRecipeProvider.has(AllTags.itemC(partID + "s"))).save((RecipeOutput)p, SlagEmbers.loc("melting/" + partID + "_" + matID));
            }
        }
    }).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get())).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.PAPER).requires((ItemLike)Items.CLAY_BALL).unlockedBy("has_paper", RegistrateRecipeProvider.has((ItemLike)Items.PAPER)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).lang("Modular Blueprint").register();
    public static final ItemEntry<BakedModularToolItem> BAKED_TOOL = SlagEmbers.REG.item("baked_tool", BakedModularToolItem::new).model((n, a) -> {}).lang("OLD ITEM").removeTab(AllCreativeTabs.BASE_TAB.getKey()).register();
    public static final ItemEntry<ModularToolItem> MODULAR_TOOL = SlagEmbers.REG.item("modular_tool", ModularToolItem::new).model((n, a) -> {}).lang("OLD ITEM").removeTab(AllCreativeTabs.BASE_TAB.getKey()).register();
    public static final ItemEntry<DynamicMoldItem> SANDSTONE_MOLD = SlagEmbers.REG.item("sandstone_mold", DynamicMoldItem::new).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get()), (int)4).requires(Tags.Items.SANDSTONE_UNCOLORED_BLOCKS).unlockedBy("has_sandstone", RegistrateRecipeProvider.has((TagKey)Tags.Items.SANDSTONE_UNCOLORED_BLOCKS)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).model((c, p) -> {
        ArrayList<String> castTypes = new ArrayList<String>(List.of("axe_heads", "balls", "dusts", "gems", "guards", "hoe_heads", "ingots", "nuggets", "pickaxe_heads", "rods", "shovel_heads", "sword_blades", "plates", "helmets", "chestplates", "leggings", "boots"));
        for (String cast : castTypes) {
            for (boolean cutout : Iterate.trueAndFalse) {
                ResourceLocation loc = SlagEmbers.loc("item/" + (cutout ? "cutout/" : "") + c.getName() + "/" + cast);
                ((ItemModelBuilder)p.withExistingParent(loc.getPath(), "item/generated")).texture("layer0", loc);
            }
        }
        ((ItemModelBuilder)p.withExistingParent("item/cutout/" + c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/cutout/" + c.getName()));
        ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/" + c.getName()));
    }).tag(new TagKey[]{AllTags.MOLDS_SINGLE}).register();
    public static final ItemEntry<DynamicMoldItem> TERRACOTTA_MOLD = SlagEmbers.REG.item("terracotta_mold", DynamicMoldItem::new).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)c.get()), (int)2).requires(ItemTags.TERRACOTTA).unlockedBy("has_terracotta", RegistrateRecipeProvider.has((TagKey)ItemTags.TERRACOTTA)).save((RecipeOutput)p, SlagEmbers.loc("crafting/" + c.getName()))).model((c, p) -> {
        ArrayList<String> castTypes = new ArrayList<String>(List.of("axe_heads", "balls", "dusts", "gems", "guards", "hoe_heads", "ingots", "nuggets", "pickaxe_heads", "rods", "shovel_heads", "sword_blades", "plates", "helmets", "chestplates", "leggings", "boots"));
        for (String cast : castTypes) {
            for (boolean cutout : Iterate.trueAndFalse) {
                ResourceLocation loc = SlagEmbers.loc("item/" + (cutout ? "cutout/" : "") + c.getName() + "/" + cast);
                ((ItemModelBuilder)p.withExistingParent(loc.getPath(), "item/generated")).texture("layer0", loc);
            }
        }
        ((ItemModelBuilder)p.withExistingParent("item/cutout/" + c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/cutout/" + c.getName()));
        ((ItemModelBuilder)p.withExistingParent(c.getName(), "item/generated")).texture("layer0", SlagEmbers.loc("item/" + c.getName()));
    }).tag(new TagKey[]{AllTags.MOLDS_REUSABLE}).register();
    public static final ItemEntry<Item> ROSE_GOLD_INGOT = SlagEmbers.REG.item("rose_gold_ingot", Item::new).recipe((c, p) -> {
        AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("ingots/rose_gold")), Ingredient.of(AllTags.itemC("storage_blocks/rose_gold")), (ItemLike)c.get(), AllBlocks.ROSE_GOLD_BLOCK);
        DualCookingRecipeBuilder.create(RecipeCategory.MISC, (ItemLike)c.get(), 2, AllTags.itemC("ingots/copper"), AllTags.itemC("ingots/gold"), 1.4f).unlockedBy("has_copper", RegistrateRecipeProvider.has(AllTags.itemC("ingots/copper"))).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/" + c.getName()));
    }).tag(new TagKey[]{AllTags.itemC("ingots/rose_gold"), AllTags.itemC("ingots"), ItemTags.BEACON_PAYMENT_ITEMS}).register();
    public static final ItemEntry<Item> ROSE_GOLD_NUGGET = SlagEmbers.REG.item("rose_gold_nugget", Item::new).recipe((c, p) -> AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("nuggets/rose_gold")), Ingredient.of(AllTags.itemC("ingots/rose_gold")), (ItemLike)c.get(), ROSE_GOLD_INGOT)).tag(new TagKey[]{AllTags.itemC("nuggets/rose_gold"), AllTags.itemC("nuggets")}).register();
    public static final ItemEntry<Item> DEEP_ALLOY = SlagEmbers.REG.item("deep_alloy", Item::new).recipe((c, p) -> {
        AllUtils.compressible9x((DataGenContext<Item, Item>)c, p, Ingredient.of(AllTags.itemC("ingots/deep_alloy")), Ingredient.of(AllTags.itemC("storage_blocks/deep_alloy")), (ItemLike)c.get(), AllBlocks.DEEP_ALLOY_BLOCK);
        DualCookingRecipeBuilder.create(RecipeCategory.MISC, (ItemLike)c.get(), AllTags.itemC("ingots/iron"), (ItemLike)Items.POLISHED_DEEPSLATE, 1.4f).unlockedBy("has_iron", RegistrateRecipeProvider.has(AllTags.itemC("ingots/iron"))).save((RecipeOutput)p, SlagEmbers.loc("double_smelting/" + c.getName()));
    }).tag(new TagKey[]{AllTags.itemC("ingots/deep_alloy"), AllTags.itemC("ingots"), ItemTags.BEACON_PAYMENT_ITEMS}).register();
    public static final List<ItemEntry<ModularToolPartItem>> TOOL_PARTS = new ArrayList<ItemEntry<ModularToolPartItem>>();

    public static void registerPart(MaterialType material, PartType part) {
        String partID = part.id.getPath();
        String matID = material.id.getPath();
        ItemBuilder reg = ((ItemBuilder)SlagEmbers.REG.item(matID + "_" + partID, p -> new ModularToolPartItem(material, part, (Item.Properties)p)).model((n, a) -> {}).lang(p -> "old." + matID + "." + partID, "OLD ITEM")).removeTab(AllCreativeTabs.BASE_TAB.getKey());
        if (material.fireProof) {
            reg = reg.properties(Item.Properties::fireResistant);
        }
        TOOL_PARTS.add((ItemEntry<ModularToolPartItem>)reg.register());
    }

    public static TagKey<Item> getCast(PartType part) {
        return switch (part.id.getPath()) {
            case "axe_head" -> AllTags.CAST_AXE_HEADS;
            case "pickaxe_head" -> AllTags.CAST_PICKAXE_HEADS;
            case "shovel_head" -> AllTags.CAST_SHOVEL_HEADS;
            case "hoe_head" -> AllTags.CAST_HOE_HEADS;
            case "sword_blade" -> AllTags.CAST_SWORD_BLADES;
            case "guard" -> AllTags.CAST_GUARDS;
            case "plate" -> AllTags.CAST_PLATES;
            case "helmet" -> AllTags.CAST_HELMETS;
            case "chestplate" -> AllTags.CAST_CHESTPLATES;
            case "leggings" -> AllTags.CAST_LEGGINGS;
            case "boots" -> AllTags.CAST_BOOTS;
            default -> null;
        };
    }

    public static int getSize(PartType part) {
        return switch (part.id.getPath()) {
            case "chestplate" -> 6;
            case "leggings" -> 5;
            case "axe_head", "pickaxe_head", "helmet" -> 3;
            case "sword_blade", "hoe_head", "plate", "boots" -> 2;
            case "guard", "shovel_head" -> 1;
            default -> 0;
        };
    }

    public static ShapedRecipeBuilder buildPattern(ShapedRecipeBuilder value, PartType part) {
        return switch (part.id.getPath()) {
            case "axe_head" -> value.pattern("MM").pattern("MR").pattern(" R");
            case "pickaxe_head" -> value.pattern("MMM").pattern(" R ").pattern(" R ");
            case "shovel_head" -> value.pattern("M").pattern("R").pattern("R");
            case "hoe_head" -> value.pattern("MM").pattern(" R").pattern(" R");
            case "sword_blade" -> value.pattern("M").pattern("M").pattern("R");
            case "guard" -> value.pattern("RMR");
            case "plate" -> value.pattern("MR").pattern("RM");
            case "helmet" -> value.pattern("MMM").pattern("R R");
            case "chestplate" -> value.pattern("R R").pattern("MMM").pattern("MMM");
            case "leggings" -> value.pattern("MMM").pattern("M M").pattern("R R");
            case "boots" -> value.pattern("R R").pattern("M M");
            default -> value;
        };
    }

    public static List<String> testMixture(String part) {
        ArrayList<String> parts = new ArrayList<String>();
        if (List.of("axe_head", "hoe_head").contains(part)) {
            parts.add("mattock");
        }
        if (List.of("pickaxe_head", "shovel_head").contains(part)) {
            parts.add("prybar");
        }
        if (List.of("shovel_head", "hoe_head").contains(part)) {
            parts.add("graip");
        }
        if (List.of("pickaxe_head", "axe_head").contains(part)) {
            parts.add("mallet");
        }
        if (List.of("pickaxe_head", "axe_head", "shovel_head").contains(part)) {
            parts.add("hammer");
        }
        if (List.of("hoe_head", "sword_blade", "guard").contains(part)) {
            parts.add("scythe");
        }
        if (List.of("pickaxe_head", "axe_head", "sword_blade").contains(part)) {
            parts.add("maul");
        }
        if (List.of("pickaxe_head", "axe_head", "shovel_head", "hoe_head", "sword_blade").contains(part)) {
            parts.add("paxel");
        }
        return parts;
    }

    public static void register() {
    }

    static {
        for (MaterialType material : MATERIAL_TYPES) {
            for (PartType part : PART_TYPES) {
                AllItems.registerPart(material, part);
            }
        }
    }
}

