/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify;

import dev.echoellet.epicfight_controlify.EpicFightControlify;
import dev.echoellet.epicfight_controlify.api.InputMode;
import dev.echoellet.epicfight_controlify.api.PlayerInputState;
import dev.echoellet.epicfight_controlify.api.action.EpicFightInputActions;
import dev.echoellet.epicfight_controlify.api.controller.ControllerBinding;
import dev.echoellet.epicfight_controlify.api.controller.EpicFightControllerModProvider;
import dev.echoellet.epicfight_controlify.api.controller.IEpicFightControllerMod;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.guide.GuideDomainRegistry;
import dev.isxander.controlify.api.guide.InGameCtx;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.bindings.input.InputType;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.screenop.compat.vanilla.AbstractButtonComponentProcessor;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;

@ApiStatus.Internal
public class EpicFightControlifyEntrypoint
implements ControlifyEntrypoint {
    private static InputBindingSupplier attack;
    private static InputBindingSupplier mobility;
    private static InputBindingSupplier guard;
    private static InputBindingSupplier dodge;
    private static InputBindingSupplier lockOn;
    private static InputBindingSupplier switchMode;
    private static InputBindingSupplier weaponInnateSkill;
    private static InputBindingSupplier weaponInnateSkillTooltip;
    private static InputBindingSupplier openSkillEditorScreen;
    private static InputBindingSupplier openConfigScreen;
    private static InputBindingSupplier switchVanillaModeDebugging;
    private static final BindContext COMBAT_MODE_CONTEXT;
    private static final BindContext IN_GAME_CONTEXT;
    private static final BindContext ANY_SCREEN_CONTEXT;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
        EpicFightControlifyEntrypoint.registerModIntegration();
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        EpicFightControlifyEntrypoint.registerCustomRadialIcons();
        registrar.registerBindContext(COMBAT_MODE_CONTEXT);
        EpicFightControlifyEntrypoint.registerInputBindings(registrar);
        EpicFightControlifyEntrypoint.registerTargetLockOnSupport();
        EpicFightControlifyEntrypoint.registerInGameGuides((GuideDomainRegistry<InGameCtx>)context.guideRegistries().inGame());
        EpicFightControlifyEntrypoint.registerScreenProcessors();
    }

    private static void registerCustomRadialIcons() {
        for (EpicFightRadialIcons icon : EpicFightRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                CGuiPose pose = CGuiPose.ofPush((GuiGraphics)graphics);
                pose.translate((float)x, (float)y);
                pose.scale(0.5f, 0.5f);
                Blit.tex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                pose.pop();
            });
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        for (EpicFightInputActions action : EpicFightControlifyEntrypoint.nonVanillaActions()) {
            EpicFightControlifyEntrypoint.registerInputBinding(registrar, action);
        }
    }

    public static Set<EpicFightInputActions> nonVanillaActions() {
        EnumSet<EpicFightInputActions> result = EnumSet.noneOf(EpicFightInputActions.class);
        for (EpicFightInputActions action : EpicFightInputActions.values()) {
            if (action.isVanilla()) continue;
            result.add(action);
        }
        return result;
    }

    @NotNull
    private static InputBindingSupplier registerInputBinding(@NotNull ControlifyBindApi registrar, @NotNull EpicFightInputActions action) {
        Component combatCategory = ComponentConstants.KEY_COMBAT;
        Component guiCategory = ComponentConstants.KEY_GUI;
        Component systemCategory = ComponentConstants.KEY_SYSTEM;
        KeyMapping keyMappingToDisable = action.keyMapping();
        return switch (action) {
            default -> throw new MatchException(null, null);
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY, EpicFightInputActions.USE, EpicFightInputActions.SWAP_OFF_HAND, EpicFightInputActions.TOGGLE_PERSPECTIVE, EpicFightInputActions.DROP, EpicFightInputActions.MOVE_FORWARD, EpicFightInputActions.MOVE_BACKWARD, EpicFightInputActions.MOVE_LEFT, EpicFightInputActions.MOVE_RIGHT, EpicFightInputActions.SPRINT, EpicFightInputActions.SNEAK, EpicFightInputActions.JUMP -> throw new IllegalArgumentException("ControlifyCompat#registerInputBinding() must only be called for non-vanilla actions. This action is vanilla and already registered in Controlify: " + action.name());
            case EpicFightInputActions.ATTACK -> attack = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("attack")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_ATTACK).description(ComponentConstants.KEY_ATTACK_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.ATTACK));
            case EpicFightInputActions.MOBILITY -> mobility = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("mobility")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_MOVER_SKILL).description(ComponentConstants.KEY_MOVER_SKILL_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.GUARD -> guard = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("guard")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_GUARD).description(ComponentConstants.KEY_GUARD_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.GUARD));
            case EpicFightInputActions.DODGE -> dodge = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("dodge")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_DODGE).description(ComponentConstants.KEY_DODGE_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.DODGE));
            case EpicFightInputActions.LOCK_ON -> lockOn = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("lock_on")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_LOCK_ON).description(ComponentConstants.KEY_LOCK_ON_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.LOCK_ON));
            case EpicFightInputActions.SWITCH_MODE -> switchMode = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("switch_mode")).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SWITCH_MODE).description(ComponentConstants.KEY_SWITCH_MODE_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(EpicFightRadialIcons.UCHIGATANA.getId()).keyEmulation(EpicFightKeyMappings.SWITCH_MODE));
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("weapon_innate_skill")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_WEAPON_INNATE_SKILL).description(ComponentConstants.KEY_WEAPON_INNATE_SKILL_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.WEAPON_INNATE_SKILL));
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("weapon_innate_skill_tooltip")).category(guiCategory).allowedContexts(new BindContext[]{ANY_SCREEN_CONTEXT}).name(ComponentConstants.WEAPON_INNATE_SKILL_TOOLTIP).description(ComponentConstants.WEAPON_INNATE_SKILL_TOOLTIP_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP));
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("open_skill_editor_screen")).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SKILL_GUI).description(ComponentConstants.KEY_SKILL_GUI_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(EpicFightRadialIcons.SKILL_BOOK.getId()).keyEmulation(EpicFightKeyMappings.SKILL_EDIT));
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("open_config_screen")).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_CONFIG).description(ComponentConstants.KEY_CONFIG_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(RadialIcons.getItem((Item)Items.REDSTONE)).keyEmulation(EpicFightKeyMappings.OPEN_CONFIG_SCREEN));
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging = registrar.registerBinding(builder -> builder.id(EpicFightControlify.rl("switch_vanilla_mode_debugging")).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SWITCH_VANILLA_MODEL_DEBUG).description(ComponentConstants.KEY_SWITCH_VANILLA_MODEL_DEBUG_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).keyEmulation(EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING));
        };
    }

    private static void registerModIntegration() {
        EpicFightControllerModProvider.set("epicfight", new ControlifyIntegration());
    }

    private static void registerTargetLockOnSupport() {
        ControlifyEvents.LOOK_INPUT_MODIFIER.register(event -> {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch != null && localPlayerPatch.isTargetLockedOn()) {
                event.lookInput().zero();
            }
        });
    }

    private static void registerInGameGuides(GuideDomainRegistry<InGameCtx> registry) {
    }

    @NotNull
    private static InputBinding getControlifyBinding(@NotNull EpicFightInputActions action) {
        InputBindingSupplier bindingSupplier = switch (action) {
            default -> throw new MatchException(null, null);
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY -> ControlifyBindings.ATTACK;
            case EpicFightInputActions.USE -> ControlifyBindings.USE;
            case EpicFightInputActions.SWAP_OFF_HAND -> ControlifyBindings.SWAP_HANDS;
            case EpicFightInputActions.DROP -> ControlifyBindings.DROP_INGAME;
            case EpicFightInputActions.TOGGLE_PERSPECTIVE -> ControlifyBindings.CHANGE_PERSPECTIVE;
            case EpicFightInputActions.ATTACK -> attack;
            case EpicFightInputActions.JUMP -> ControlifyBindings.JUMP;
            case EpicFightInputActions.MOBILITY -> mobility;
            case EpicFightInputActions.GUARD -> guard;
            case EpicFightInputActions.DODGE -> dodge;
            case EpicFightInputActions.LOCK_ON -> lockOn;
            case EpicFightInputActions.SWITCH_MODE -> switchMode;
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill;
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip;
            case EpicFightInputActions.MOVE_FORWARD -> ControlifyBindings.WALK_FORWARD;
            case EpicFightInputActions.MOVE_BACKWARD -> ControlifyBindings.WALK_BACKWARD;
            case EpicFightInputActions.MOVE_LEFT -> ControlifyBindings.WALK_LEFT;
            case EpicFightInputActions.MOVE_RIGHT -> ControlifyBindings.WALK_RIGHT;
            case EpicFightInputActions.SPRINT -> ControlifyBindings.SPRINT;
            case EpicFightInputActions.SNEAK -> ControlifyBindings.SNEAK;
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen;
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen;
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging;
        };
        @Nullable InputBinding binding = bindingSupplier.onOrNull(EpicFightControlifyEntrypoint.requireControllerEntity());
        return Objects.requireNonNull(binding, "The binding for the action " + action.name() + " is not yet registered.");
    }

    @NotNull
    private static ControlifyApi getApi() {
        return ControlifyApi.get();
    }

    @NotNull
    private static ControllerEntity requireControllerEntity() {
        Optional optionalControllerEntity = EpicFightControlifyEntrypoint.getApi().getCurrentController();
        if (optionalControllerEntity.isEmpty()) {
            String message = String.format("The method IEpicFightControllerMod#getInputState must not be called when the input mode is not %s", InputMode.CONTROLLER.name());
            EpicFightMod.LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        return (ControllerEntity)optionalControllerEntity.get();
    }

    private static void registerScreenProcessors() {
        ScreenProcessorProvider.registerProvider(SkillEditScreen.class, SkillEditScreenProcessor::new);
    }

    static {
        COMBAT_MODE_CONTEXT = new BindContext(EpicFightControlify.rl("epicfight_combat"), mc -> {
            boolean isInGame = mc.screen == null && mc.level != null && mc.player != null;
            return isInGame && ClientEngine.getInstance().isEpicFightMode();
        });
        IN_GAME_CONTEXT = BindContext.IN_GAME;
        ANY_SCREEN_CONTEXT = BindContext.ANY_SCREEN;
    }

    private static enum EpicFightRadialIcons {
        UCHIGATANA(EpicFightControlify.epicFightRl("textures/item/uchigatana_gui.png")),
        SKILL_BOOK(EpicFightControlify.epicFightRl("textures/item/skillbook.png"));

        @NotNull
        private final ResourceLocation id;

        private EpicFightRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class ComponentConstants {
        private static final Component KEY_COMBAT = Component.translatable((String)"key.epicfight.combat");
        private static final Component KEY_GUI = Component.translatable((String)"key.epicfight.gui");
        private static final Component KEY_SYSTEM = Component.translatable((String)"key.epicfight.system");
        private static final Component WEAPON_INNATE_SKILL_TOOLTIP = Component.translatable((String)"key.epicfight.show_tooltip");
        private static final Component KEY_SWITCH_MODE = Component.translatable((String)"key.epicfight.switch_mode");
        private static final Component KEY_ATTACK = Component.translatable((String)"key.epicfight.attack");
        private static final Component KEY_WEAPON_INNATE_SKILL = Component.translatable((String)"key.epicfight.weapon_innate_skill");
        private static final Component KEY_SKILL_GUI = Component.translatable((String)"key.epicfight.skill_gui");
        private static final Component KEY_DODGE = Component.translatable((String)"key.epicfight.dodge");
        private static final Component KEY_GUARD = Component.translatable((String)"key.epicfight.guard");
        private static final Component KEY_LOCK_ON = Component.translatable((String)"key.epicfight.lock_on");
        private static final Component KEY_MOVER_SKILL = Component.translatable((String)"key.epicfight.mover_skill");
        private static final Component KEY_CONFIG = Component.translatable((String)"key.epicfight.config");
        private static final Component KEY_SWITCH_VANILLA_MODEL_DEBUG = Component.translatable((String)"key.epicfight.switch_vanilla_model_debug");
        private static final Component WEAPON_INNATE_SKILL_TOOLTIP_DESCRIPTION = Component.translatable((String)"key.epicfight.show_tooltip.description");
        private static final Component KEY_SWITCH_MODE_DESCRIPTION = Component.translatable((String)"key.epicfight.switch_mode.description");
        private static final Component KEY_ATTACK_DESCRIPTION = Component.translatable((String)"key.epicfight.attack.description");
        private static final Component KEY_WEAPON_INNATE_SKILL_DESCRIPTION = Component.translatable((String)"key.epicfight.weapon_innate_skill.description");
        private static final Component KEY_SKILL_GUI_DESCRIPTION = Component.translatable((String)"key.epicfight.skill_gui.description");
        private static final Component KEY_DODGE_DESCRIPTION = Component.translatable((String)"key.epicfight.dodge.description");
        private static final Component KEY_GUARD_DESCRIPTION = Component.translatable((String)"key.epicfight.guard.description");
        private static final Component KEY_LOCK_ON_DESCRIPTION = Component.translatable((String)"key.epicfight.lock_on.description");
        private static final Component KEY_MOVER_SKILL_DESCRIPTION = Component.translatable((String)"key.epicfight.mover_skill.description");
        private static final Component KEY_CONFIG_DESCRIPTION = Component.translatable((String)"key.epicfight.config.description");
        private static final Component KEY_SWITCH_VANILLA_MODEL_DEBUG_DESCRIPTION = Component.translatable((String)"key.epicfight.switch_vanilla_model_debug.description");

        private ComponentConstants() {
        }
    }

    private static class ControlifyIntegration
    implements IEpicFightControllerMod {
        private ControlifyIntegration() {
        }

        @Override
        public String getModName() {
            return "Controlify";
        }

        @Override
        @NotNull
        public InputMode getInputMode() {
            return switch (EpicFightControlifyEntrypoint.getApi().currentInputMode()) {
                default -> throw new MatchException(null, null);
                case dev.isxander.controlify.InputMode.KEYBOARD_MOUSE -> InputMode.KEYBOARD_MOUSE;
                case dev.isxander.controlify.InputMode.CONTROLLER -> InputMode.CONTROLLER;
                case dev.isxander.controlify.InputMode.MIXED -> InputMode.MIXED;
            };
        }

        @Override
        @NotNull
        public ControllerBinding getBinding(EpicFightInputActions action) {
            return new ControllerBindingImpl(EpicFightControlifyEntrypoint.getControlifyBinding(action));
        }

        @Override
        @NotNull
        public PlayerInputState getInputState() {
            ControllerEntity controller = EpicFightControlifyEntrypoint.requireControllerEntity();
            InputBinding forwardBind = ControlifyBindings.WALK_FORWARD.on(controller);
            InputBinding backwardBind = ControlifyBindings.WALK_BACKWARD.on(controller);
            InputBinding leftBind = ControlifyBindings.WALK_LEFT.on(controller);
            InputBinding rightBind = ControlifyBindings.WALK_RIGHT.on(controller);
            InputBinding jumpBind = ControlifyBindings.JUMP.on(controller);
            InputBinding sneakBind = ControlifyBindings.SNEAK.on(controller);
            float forwardImpulse = forwardBind.analogueNow() - backwardBind.analogueNow();
            float leftImpulse = leftBind.analogueNow() - rightBind.analogueNow();
            return new PlayerInputState(leftImpulse, forwardImpulse, forwardBind.digitalNow(), backwardBind.digitalNow(), leftBind.digitalNow(), rightBind.digitalNow(), jumpBind.digitalNow(), sneakBind.digitalNow());
        }

        @Override
        public boolean isBoundToSameButton(@NotNull EpicFightInputActions action, @NotNull EpicFightInputActions action2) {
            Input input1 = EpicFightControlifyEntrypoint.getControlifyBinding(action).boundInput();
            Input input2 = EpicFightControlifyEntrypoint.getControlifyBinding(action2).boundInput();
            if (input1.type() == InputType.BUTTON && input2.type() == InputType.BUTTON) {
                return input1.getRelevantInputs().equals(input2.getRelevantInputs());
            }
            return false;
        }
    }

    private static class SkillEditScreenProcessor
    extends ScreenProcessor<SkillEditScreen> {
        public SkillEditScreenProcessor(SkillEditScreen screen) {
            super((Screen)screen);
        }

        private static class SlotButtonProcessor
        extends AbstractButtonComponentProcessor {
            public SlotButtonProcessor(AbstractButton button) {
                super(button);
            }
        }
    }

    private record ControllerBindingImpl(@NotNull InputBinding inputBinding) implements ControllerBinding
    {
        @Override
        public ResourceLocation id() {
            return this.inputBinding.id();
        }

        @Override
        @NotNull
        public ControllerBinding.InputType getInputType() {
            throw new NotImplementedException("The method ControllerBinding#getInputType should not be called, ");
        }

        @Override
        public boolean isDigitalActiveNow() {
            return this.inputBinding.digitalNow();
        }

        @Override
        public boolean wasDigitalActivePreviously() {
            return this.inputBinding.digitalPrev();
        }

        @Override
        public boolean isDigitalJustPressed() {
            return this.inputBinding.justPressed();
        }

        @Override
        public boolean isDigitalJustReleased() {
            return this.inputBinding.justReleased();
        }

        @Override
        public float getAnalogueNow() {
            return this.inputBinding.analogueNow();
        }

        @Override
        public void emulatePress() {
            this.inputBinding.fakePress();
        }
    }
}

