/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify;

import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@EventBusSubscriber(modid="epicfight_controlify", value={Dist.CLIENT})
public class UpdatedControlEngine {
    @ApiStatus.Internal
    public static boolean isHotbarCyclingDisabled() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        return minecraft.player != null && localPlayerPatch != null && !localPlayerPatch.getEntityState().canSwitchHoldingItem() && minecraft.screen == null;
    }

    @SubscribeEvent
    public static void mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        if (UpdatedControlEngine.isHotbarCyclingDisabled()) {
            event.setCanceled(true);
        }
    }

    @ApiStatus.Internal
    public static boolean shouldDisableSwapHandItems() {
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.getEntityState().inaction() || !playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand();
    }

    @ApiStatus.Internal
    public static boolean shouldDisableVanillaAttack() {
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.isEpicFightMode() && playerPatch.canPlayAttackAnimation();
    }
}

