/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify.api.action;

import dev.echoellet.epicfight_controlify.api.action.InputAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.ExtensibleEnum;
import yesman.epicfight.client.input.EpicFightKeyMappings;

@ApiStatus.Experimental
public enum EpicFightInputActions implements InputAction
{
    VANILLA_ATTACK_DESTROY(true),
    USE(true),
    SWAP_OFF_HAND(true),
    DROP(true),
    TOGGLE_PERSPECTIVE(true),
    ATTACK(false),
    JUMP(true),
    MOBILITY(false),
    GUARD(false),
    DODGE(false),
    LOCK_ON(false),
    SWITCH_MODE(false),
    WEAPON_INNATE_SKILL(false),
    WEAPON_INNATE_SKILL_TOOLTIP(false),
    MOVE_FORWARD(true),
    MOVE_BACKWARD(true),
    MOVE_LEFT(true),
    MOVE_RIGHT(true),
    SPRINT(true),
    SNEAK(true),
    OPEN_SKILL_SCREEN(false),
    OPEN_CONFIG_SCREEN(false),
    SWITCH_VANILLA_MODEL_DEBUGGING(false);

    private final int id = InputAction.ENUM_MANAGER.assign((ExtensibleEnum)this);
    private final boolean isVanilla;
    @NotNull
    private static final Map<KeyMapping, EpicFightInputActions> BY_KEY_MAPPING;

    public boolean isVanilla() {
        return this.isVanilla;
    }

    private EpicFightInputActions(boolean isVanilla) {
        this.isVanilla = isVanilla;
    }

    public int universalOrdinal() {
        return this.id;
    }

    @Override
    @NotNull
    public KeyMapping keyMapping() {
        Options options = Minecraft.getInstance().options;
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> options.keyAttack;
            case 1 -> options.keyUse;
            case 2 -> options.keySwapOffhand;
            case 3 -> options.keyDrop;
            case 4 -> options.keyTogglePerspective;
            case 5 -> EpicFightKeyMappings.ATTACK;
            case 6 -> options.keyJump;
            case 7 -> EpicFightKeyMappings.MOVER_SKILL;
            case 8 -> EpicFightKeyMappings.GUARD;
            case 9 -> EpicFightKeyMappings.DODGE;
            case 10 -> EpicFightKeyMappings.LOCK_ON;
            case 11 -> EpicFightKeyMappings.SWITCH_MODE;
            case 12 -> EpicFightKeyMappings.WEAPON_INNATE_SKILL;
            case 13 -> EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP;
            case 14 -> options.keyUp;
            case 15 -> options.keyDown;
            case 16 -> options.keyLeft;
            case 17 -> options.keyRight;
            case 18 -> options.keySprint;
            case 19 -> options.keyShift;
            case 20 -> EpicFightKeyMappings.SKILL_EDIT;
            case 21 -> EpicFightKeyMappings.OPEN_CONFIG_SCREEN;
            case 22 -> EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING;
        };
    }

    @Nullable
    public static EpicFightInputActions fromKeyMapping(@NotNull KeyMapping keyMapping) {
        return BY_KEY_MAPPING.get(keyMapping);
    }

    static {
        HashMap<KeyMapping, EpicFightInputActions> map = new HashMap<KeyMapping, EpicFightInputActions>();
        for (EpicFightInputActions action : EpicFightInputActions.values()) {
            map.put(action.keyMapping(), action);
        }
        BY_KEY_MAPPING = Collections.unmodifiableMap(map);
    }
}

