/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify.mixin.epicfight;

import dev.echoellet.epicfight_controlify.api.action.EpicFightInputActions;
import dev.echoellet.epicfight_controlify.api.handlers.InputManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mixin(value={ControlEngine.class})
public class ControlEngineMixin {
    @Shadow
    private LocalPlayerPatch playerpatch;
    @Shadow
    private boolean moverPressToggle;
    @Shadow
    private LocalPlayer player;
    @Shadow
    public Options options;

    @Inject(method={"isKeyDown(Lnet/minecraft/client/KeyMapping;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onIsKeyDown(KeyMapping key, CallbackInfoReturnable<Boolean> cir) {
        EpicFightInputActions action;
        if (InputManager.supportsControllerInput() && (action = EpicFightInputActions.fromKeyMapping(key)) != null) {
            cir.setReturnValue((Object)InputManager.isActionActive(action));
            cir.cancel();
        }
    }

    @Inject(method={"handleEpicFightKeyMappings"}, at={@At(value="HEAD")})
    private void redirectMoverSkillKeyValue(CallbackInfo ci) {
        if (InputManager.supportsControllerInput()) {
            InputManager.triggerOnPress(EpicFightInputActions.MOBILITY, true, () -> {
                if (this.playerpatch.isEpicFightMode() && !this.playerpatch.isHoldingAny()) {
                    if (EpicFightKeyMappings.MOVER_SKILL.getKey().getValue() == this.options.keyJump.getKey().getValue()) {
                        SkillCastEvent event;
                        SkillContainer skillContainer = this.playerpatch.getSkill((SkillSlot)SkillSlots.MOVER);
                        if (skillContainer.canUse((PlayerPatch)this.playerpatch, event = new SkillCastEvent((PlayerPatch)this.playerpatch, skillContainer, null)) && this.player.getVehicle() == null && !this.moverPressToggle) {
                            this.moverPressToggle = true;
                        }
                    } else {
                        SkillContainer skill = this.playerpatch.getSkill((SkillSlot)SkillSlots.MOVER);
                        skill.sendCastRequest(this.playerpatch, ControlEngine.getInstance());
                    }
                }
            });
        }
    }
}

