/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify;

import dev.echoellet.epicfight_controlify.EpicFightControlify;
import dev.echoellet.epicfight_controlify.compat.ICompatModule;
import dev.echoellet.epicfight_controlify.compat.epicfight.EpicFightCompat;
import dev.echoellet.epicfight_controlify.compat.epicskills.EpicSkillsCompat;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EpicFightControlifyEntrypoint
implements ControlifyEntrypoint {
    private static List<ICompatModule> modules = null;

    private static List<ICompatModule> getModules() {
        if (modules == null) {
            modules = new ArrayList<ICompatModule>();
            modules.add(new EpicFightCompat());
            EpicFightControlify.LOGGER.info("Registering compatibility module for 'Epic Fight' mod");
            if (ModList.get().isLoaded("epicskills")) {
                modules.add(new EpicSkillsCompat());
                EpicFightControlify.LOGGER.info("Registering compatibility module for 'Epic Fight: Skill Tree' addon");
            }
        }
        return modules;
    }

    public void onControllersDiscovered(ControlifyApi controlify) {
        for (ICompatModule module : EpicFightControlifyEntrypoint.getModules()) {
            module.onControllersDiscovered(controlify);
        }
    }

    public void onControlifyInit(InitContext context) {
        for (ICompatModule module : EpicFightControlifyEntrypoint.getModules()) {
            module.onControlifyInit(context);
        }
    }

    public void onControlifyPreInit(PreInitContext context) {
        for (ICompatModule module : EpicFightControlifyEntrypoint.getModules()) {
            module.onControlifyPreInit(context);
        }
    }
}

