/*
 * Decompiled with CFR 0.152.
 */
package dev.echoellet.epicfight_controlify.compat.epicfight;

import dev.echoellet.epicfight_controlify.EpicFightControlify;
import dev.echoellet.epicfight_controlify.compat.ICompatModule;
import dev.echoellet.epicfight_controlify.util.RadialUtils;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.bindings.input.InputType;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@ApiStatus.Internal
public class EpicFightCompat
implements ICompatModule {
    private static InputBindingSupplier attack;
    private static InputBindingSupplier mobility;
    private static InputBindingSupplier guard;
    private static InputBindingSupplier dodge;
    private static InputBindingSupplier lockOn;
    private static InputBindingSupplier switchMode;
    private static InputBindingSupplier weaponInnateSkill;
    private static InputBindingSupplier weaponInnateSkillTooltip;
    private static InputBindingSupplier openSkillEditorScreen;
    private static InputBindingSupplier openConfigScreen;
    private static InputBindingSupplier switchVanillaModeDebugging;
    private static final BindContext COMBAT_MODE_CONTEXT;
    private static final BindContext IN_GAME_CONTEXT;
    private static final BindContext ANY_SCREEN_CONTEXT;

    @Override
    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    @Override
    public void onControlifyInit(InitContext context) {
        EpicFightCompat.registerModIntegration();
    }

    @Override
    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        EpicFightCompat.registerCustomRadialIcons();
        registrar.registerBindContext(COMBAT_MODE_CONTEXT);
        EpicFightCompat.registerInputBindings(registrar);
        EpicFightCompat.registerTargetLockOnSupport();
        EpicFightCompat.registerGuides();
        EpicFightCompat.registerScreenProcessors();
    }

    private static void registerCustomRadialIcons() {
        for (EpicFightRadialIcons icon : EpicFightRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialUtils.register(location);
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        for (EpicFightInputActions action : EpicFightInputActions.nonVanillaActions()) {
            EpicFightCompat.registerInputBinding(registrar, action);
        }
    }

    @NotNull
    private static InputBindingSupplier registerInputBinding(@NotNull ControlifyBindApi registrar, @NotNull EpicFightInputActions action) {
        Component combatCategory = EpicFightInputCategories.COMBAT;
        Component guiCategory = EpicFightInputCategories.GUI;
        Component systemCategory = EpicFightInputCategories.SYSTEM;
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY, EpicFightInputActions.USE, EpicFightInputActions.SWAP_OFF_HAND, EpicFightInputActions.DROP, EpicFightInputActions.TOGGLE_PERSPECTIVE, EpicFightInputActions.JUMP, EpicFightInputActions.MOVE_FORWARD, EpicFightInputActions.MOVE_BACKWARD, EpicFightInputActions.MOVE_LEFT, EpicFightInputActions.MOVE_RIGHT, EpicFightInputActions.SPRINT, EpicFightInputActions.SNEAK -> throw new IllegalArgumentException("ControlifyCompat#registerInputBinding() must only be called for non-vanilla actions. This action is vanilla and already registered by Controlify: " + action.name());
            case EpicFightInputActions.ATTACK -> attack = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.MOBILITY -> mobility = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.GUARD -> guard = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.DODGE -> dodge = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.LOCK_ON -> lockOn = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.SWITCH_MODE -> switchMode = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).radialCandidate(EpicFightRadialIcons.UCHIGATANA.getId()));
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}));
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{ANY_SCREEN_CONTEXT}));
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).radialCandidate(EpicFightRadialIcons.SKILL_BOOK.getId()));
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).radialCandidate(RadialIcons.getItem((Item)Items.f_42451_)));
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging = registrar.registerBinding(builder -> EpicFightCompat.applyCommonBindingProperties(action, builder).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}));
        };
    }

    @NotNull
    private static InputBindingBuilder applyCommonBindingProperties(@NotNull EpicFightInputActions action, @NotNull InputBindingBuilder builder) {
        TranslationKeys translationKeys = TranslationKeys.fromAction(action);
        KeyMapping keyMappingToIgnore = action.keyMapping();
        return builder.id(EpicFightCompat.getBindingId(action)).name(translationKeys.getNameComponent()).description(translationKeys.getDescriptionComponent()).addKeyCorrelation(keyMappingToIgnore);
    }

    @NotNull
    private static ResourceLocation getBindingId(@NotNull EpicFightInputActions action) {
        String path = switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputActions.ATTACK -> "attack";
            case EpicFightInputActions.MOBILITY -> "mobility";
            case EpicFightInputActions.GUARD -> "guard";
            case EpicFightInputActions.DODGE -> "dodge";
            case EpicFightInputActions.LOCK_ON -> "lock_on";
            case EpicFightInputActions.SWITCH_MODE -> "switch_mode";
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> "weapon_innate_skill";
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> "weapon_innate_skill_tooltip";
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> "open_skill_editor_screen";
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> "open_config_screen";
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> "switch_vanilla_mode_debugging";
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY, EpicFightInputActions.USE, EpicFightInputActions.SWAP_OFF_HAND, EpicFightInputActions.DROP, EpicFightInputActions.TOGGLE_PERSPECTIVE, EpicFightInputActions.JUMP, EpicFightInputActions.MOVE_FORWARD, EpicFightInputActions.MOVE_BACKWARD, EpicFightInputActions.MOVE_LEFT, EpicFightInputActions.MOVE_RIGHT, EpicFightInputActions.SPRINT, EpicFightInputActions.SNEAK -> throw new IllegalArgumentException("ControlifyCompat#getInputBindingId() must only be called for non-vanilla actions. This action is vanilla and already registered by Controlify: " + action.name());
        };
        return EpicFightControlify.epicFightRl(path);
    }

    private static void registerModIntegration() {
        EpicFightControllerModProvider.set((String)"epicfight_controlify", (IEpicFightControllerMod)new ControlifyIntegration());
    }

    private static void registerTargetLockOnSupport() {
        ControlifyEvents.LOOK_INPUT_MODIFIER.register(event -> {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch != null && localPlayerPatch.isTargetLockedOn()) {
                event.lookInput().zero();
            }
        });
    }

    private static void registerGuides() {
    }

    @NotNull
    private static InputBinding getControlifyBinding(@NotNull EpicFightInputActions action) {
        InputBindingSupplier bindingSupplier = switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY -> ControlifyBindings.ATTACK;
            case EpicFightInputActions.MOVE_FORWARD -> ControlifyBindings.WALK_FORWARD;
            case EpicFightInputActions.MOVE_BACKWARD -> ControlifyBindings.WALK_BACKWARD;
            case EpicFightInputActions.MOVE_LEFT -> ControlifyBindings.WALK_LEFT;
            case EpicFightInputActions.MOVE_RIGHT -> ControlifyBindings.WALK_RIGHT;
            case EpicFightInputActions.SPRINT -> ControlifyBindings.SPRINT;
            case EpicFightInputActions.SNEAK -> ControlifyBindings.SNEAK;
            case EpicFightInputActions.USE -> ControlifyBindings.USE;
            case EpicFightInputActions.SWAP_OFF_HAND -> ControlifyBindings.SWAP_HANDS;
            case EpicFightInputActions.DROP -> ControlifyBindings.DROP_INGAME;
            case EpicFightInputActions.TOGGLE_PERSPECTIVE -> ControlifyBindings.CHANGE_PERSPECTIVE;
            case EpicFightInputActions.JUMP -> ControlifyBindings.JUMP;
            case EpicFightInputActions.ATTACK -> attack;
            case EpicFightInputActions.MOBILITY -> mobility;
            case EpicFightInputActions.GUARD -> guard;
            case EpicFightInputActions.DODGE -> dodge;
            case EpicFightInputActions.LOCK_ON -> lockOn;
            case EpicFightInputActions.SWITCH_MODE -> switchMode;
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill;
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip;
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen;
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen;
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging;
        };
        @Nullable InputBinding binding = bindingSupplier.onOrNull(EpicFightCompat.requireControllerEntity());
        return Objects.requireNonNull(binding, "The binding for the action " + action.name() + " is not yet registered.");
    }

    @NotNull
    private static ControlifyApi getApi() {
        return ControlifyApi.get();
    }

    @NotNull
    private static ControllerEntity requireControllerEntity() {
        Optional optionalControllerEntity = EpicFightCompat.getApi().getCurrentController();
        if (optionalControllerEntity.isEmpty()) {
            String message = String.format("The method IEpicFightControllerMod#getInputState must not be called when the input mode is not %s", yesman.epicfight.api.client.input.InputMode.CONTROLLER.name());
            EpicFightControlify.LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        return (ControllerEntity)optionalControllerEntity.get();
    }

    private static void registerScreenProcessors() {
        ScreenProcessorProvider.registerProvider(SkillEditScreen.class, SkillEditScreenProcessor::new);
        ScreenProcessorProvider.registerProvider(SkillBookScreen.class, SkillBookScreenProcessor::new);
    }

    static {
        COMBAT_MODE_CONTEXT = new BindContext(EpicFightControlify.epicFightRl("epicfight_combat"), mc -> {
            boolean isInGame = mc.f_91080_ == null && mc.f_91073_ != null && mc.f_91074_ != null;
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch == null) {
                return false;
            }
            return isInGame && localPlayerPatch.isEpicFightMode();
        });
        IN_GAME_CONTEXT = BindContext.IN_GAME;
        ANY_SCREEN_CONTEXT = BindContext.ANY_SCREEN;
    }

    private static enum EpicFightRadialIcons {
        UCHIGATANA(EpicFightControlify.epicFightRl("textures/item/uchigatana_gui.png")),
        SKILL_BOOK(EpicFightControlify.epicFightRl("textures/item/skillbook.png"));

        @NotNull
        private final ResourceLocation id;

        private EpicFightRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class EpicFightInputCategories {
        private static final Component COMBAT = Component.m_237115_((String)"key.epicfight.combat");
        private static final Component GUI = Component.m_237115_((String)"key.epicfight.gui");
        private static final Component SYSTEM = Component.m_237115_((String)"key.epicfight.system");

        private EpicFightInputCategories() {
        }
    }

    private record TranslationKeys(@NotNull String name, @NotNull String description) {
        @NotNull
        private Component getNameComponent() {
            return Component.m_237115_((String)this.name());
        }

        @NotNull
        private Component getDescriptionComponent() {
            return Component.m_237115_((String)this.description());
        }

        @NotNull
        private static TranslationKeys fromAction(@NotNull EpicFightInputActions action) {
            return switch (action) {
                default -> throw new IncompatibleClassChangeError();
                case EpicFightInputActions.ATTACK -> new TranslationKeys("key.epicfight.attack", "key.epicfight.attack.description");
                case EpicFightInputActions.DODGE -> new TranslationKeys("key.epicfight.dodge", "key.epicfight.dodge.description");
                case EpicFightInputActions.GUARD -> new TranslationKeys("key.epicfight.guard", "key.epicfight.guard.description");
                case EpicFightInputActions.LOCK_ON -> new TranslationKeys("key.epicfight.lock_on", "key.epicfight.lock_on.description");
                case EpicFightInputActions.SWITCH_MODE -> new TranslationKeys("key.epicfight.switch_mode", "key.epicfight.switch_mode.description");
                case EpicFightInputActions.WEAPON_INNATE_SKILL -> new TranslationKeys("key.epicfight.weapon_innate_skill", "key.epicfight.weapon_innate_skill.description");
                case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> new TranslationKeys("key.epicfight.show_tooltip", "key.epicfight.show_tooltip.description");
                case EpicFightInputActions.OPEN_SKILL_SCREEN -> new TranslationKeys("key.epicfight.skill_gui", "key.epicfight.skill_gui.description");
                case EpicFightInputActions.OPEN_CONFIG_SCREEN -> new TranslationKeys("key.epicfight.config", "key.epicfight.config.description");
                case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> new TranslationKeys("key.epicfight.switch_vanilla_model_debug", "key.epicfight.switch_vanilla_model_debug.description");
                case EpicFightInputActions.MOBILITY -> new TranslationKeys("key.epicfight.mover_skill", "key.epicfight.mover_skill.description");
                case EpicFightInputActions.VANILLA_ATTACK_DESTROY, EpicFightInputActions.USE, EpicFightInputActions.SWAP_OFF_HAND, EpicFightInputActions.DROP, EpicFightInputActions.TOGGLE_PERSPECTIVE, EpicFightInputActions.JUMP, EpicFightInputActions.MOVE_FORWARD, EpicFightInputActions.MOVE_BACKWARD, EpicFightInputActions.MOVE_LEFT, EpicFightInputActions.MOVE_RIGHT, EpicFightInputActions.SPRINT, EpicFightInputActions.SNEAK -> throw new IllegalArgumentException("TranslationKeys#fromAction() must only be called for non-vanilla actions. This action is vanilla and already registered by Controlify: " + action.name());
            };
        }

        @NotNull
        private static Component getNameOf(@NotNull EpicFightInputActions action) {
            return TranslationKeys.fromAction(action).getNameComponent();
        }
    }

    private static class ControlifyIntegration
    implements IEpicFightControllerMod {
        private ControlifyIntegration() {
        }

        public String getModName() {
            return "Controlify";
        }

        @NotNull
        public yesman.epicfight.api.client.input.InputMode getInputMode() {
            return switch (EpicFightCompat.getApi().currentInputMode()) {
                default -> throw new IncompatibleClassChangeError();
                case InputMode.KEYBOARD_MOUSE -> yesman.epicfight.api.client.input.InputMode.KEYBOARD_MOUSE;
                case InputMode.CONTROLLER -> yesman.epicfight.api.client.input.InputMode.CONTROLLER;
                case InputMode.MIXED -> yesman.epicfight.api.client.input.InputMode.MIXED;
            };
        }

        @NotNull
        public ControllerBinding getBinding(EpicFightInputActions action) {
            return new ControllerBindingImpl(EpicFightCompat.getControlifyBinding(action));
        }

        @NotNull
        public PlayerInputState getInputState() {
            ControllerEntity controller = EpicFightCompat.requireControllerEntity();
            InputBinding forwardBind = ControlifyBindings.WALK_FORWARD.on(controller);
            InputBinding backwardBind = ControlifyBindings.WALK_BACKWARD.on(controller);
            InputBinding leftBind = ControlifyBindings.WALK_LEFT.on(controller);
            InputBinding rightBind = ControlifyBindings.WALK_RIGHT.on(controller);
            InputBinding jumpBind = ControlifyBindings.JUMP.on(controller);
            InputBinding sneakBind = ControlifyBindings.SNEAK.on(controller);
            float forwardImpulse = forwardBind.analogueNow() - backwardBind.analogueNow();
            float leftImpulse = leftBind.analogueNow() - rightBind.analogueNow();
            return new PlayerInputState(leftImpulse, forwardImpulse, forwardBind.digitalNow(), backwardBind.digitalNow(), leftBind.digitalNow(), rightBind.digitalNow(), jumpBind.digitalNow(), sneakBind.digitalNow());
        }

        public boolean isBoundToSameButton(@NotNull EpicFightInputActions action, @NotNull EpicFightInputActions action2) {
            Input input1 = EpicFightCompat.getControlifyBinding(action).boundInput();
            Input input2 = EpicFightCompat.getControlifyBinding(action2).boundInput();
            return input1.getRelevantInputs().equals(input2.getRelevantInputs());
        }
    }

    private static class SkillBookScreenProcessor
    extends ScreenProcessor<SkillBookScreen> {
        private static final InputBindingSupplier LEARN_SKILL = ControlifyBindings.GUI_PRESS;

        public SkillBookScreenProcessor(SkillBookScreen screen) {
            super((Screen)screen);
        }

        protected void handleButtons(ControllerEntity controller) {
            if (LEARN_SKILL.on(controller).guiPressed().get()) {
                ((SkillBookScreen)this.screen).getLearnButton().m_5691_();
                SkillBookScreenProcessor.playClackSound();
            }
            super.handleButtons(controller);
        }

        protected void setInitialFocus() {
        }

        protected void handleComponentNavigation(ControllerEntity controller) {
        }

        public void onWidgetRebuild() {
            super.onWidgetRebuild();
            ButtonGuideApi.addGuideToButton((Object)((SkillBookScreen)this.screen).getLearnButton(), (InputBindingSupplier)LEARN_SKILL, (ButtonGuidePredicate)ButtonGuidePredicate.always());
        }
    }

    private static class SkillEditScreenProcessor
    extends ScreenProcessor<SkillEditScreen> {
        public SkillEditScreenProcessor(SkillEditScreen screen) {
            super((Screen)screen);
        }

        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.ENABLED;
        }
    }

    private record ControllerBindingImpl(@NotNull InputBinding inputBinding) implements ControllerBinding
    {
        public ResourceLocation id() {
            return this.inputBinding.id();
        }

        @NotNull
        public ControllerBinding.InputType getInputType() {
            if (this.inputBinding.boundInput().type() == InputType.AXIS) {
                return ControllerBinding.InputType.ANALOGUE;
            }
            EpicFightControlify.LOGGER.error("The method ControllerBinding#getInputType is misleading and should not be called as it will be removed in future updates.");
            return ControllerBinding.InputType.DIGITAL;
        }

        public boolean isDigitalActiveNow() {
            return this.inputBinding.digitalNow();
        }

        public boolean wasDigitalActivePreviously() {
            return this.inputBinding.digitalPrev();
        }

        public boolean isDigitalJustPressed() {
            return this.inputBinding.justPressed();
        }

        public boolean isDigitalJustReleased() {
            return this.inputBinding.justReleased();
        }

        public float getAnalogueNow() {
            return this.inputBinding.analogueNow();
        }

        public void emulatePress() {
            this.inputBinding.fakePress();
        }
    }
}

