/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.datagen;

import com.google.common.hash.HashCode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polydecorations.ModInit;
import eu.pb4.polydecorations.block.furniture.TableBlock;
import eu.pb4.polydecorations.datagen.BlockbenchGroup;
import eu.pb4.polydecorations.item.DecorationsItems;
import eu.pb4.polydecorations.model.DecorationsModels;
import eu.pb4.polydecorations.ui.UiResourceCreator;
import eu.pb4.polydecorations.util.ResourceUtils;
import eu.pb4.polydecorations.util.WoodUtil;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.ConstantTintSource;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.CustomModelDataTintSource;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2350;
import net.minecraft.class_2405;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

class CustomAssetProvider
implements class_2405 {
    private static final String BASE_WOOD_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"planks\": \"|PLANKS|\",\n    \"logs\": \"|LOG|\"\n  }\n}\n";
    private static final String MAILBOX_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"front\": \"|FRONT|\",\n    \"stripped_log\": \"|STRIPPED_LOG|\",\n    \"stripped_log_top\": \"|STRIPPED_LOG|_top\",\n    \"log\": \"|LOG|\",\n    \"log_top\": \"|LOG|_top\"\n  }\n}\n";
    private static final String MAILBOX_BAMBOO_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"front\": \"|FRONT|\",\n    \"stripped_log\": \"|STRIPPED_LOG|\",\n    \"stripped_log_top\": \"|STRIPPED_LOG|\",\n    \"log\": \"|LOG|\",\n    \"log_top\": \"|LOG|_top\"\n  }\n}\n";
    private static final String STATUE_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/statue/stone/|TYPE|\",\n  \"textures\": {\n    \"0\": \"|TXT|\"\n  }\n}\n";
    private static final String STATUE_ITEM_JSON = "{\n  \"parent\": \"polydecorations:item/stone_statue\",\n  \"textures\": {\n    \"0\": \"|TXT|\"\n  }\n}\n";
    private static final String BASE_STUMP_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"top\": \"|TOP|\",\n    \"side\": \"|SIDE|\"\n  }\n}\n";
    private static final String BASE_SLEEPING_BAG_JSON = "{\n  \"parent\": \"polydecorations:block/|TYPE|\",\n  \"textures\": {\n    \"texture\": \"|TXT|\",\n    \"particle\": \"|PARTICLE|\"\n  }\n}\n";
    private static final List<Map.Entry<String, String>> COPPER_PREFIXES = List.of(Map.entry("", "unaffected"), Map.entry("exposed_", "exposed"), Map.entry("weathered_", "weathered"), Map.entry("oxidized_", "oxidized"));
    private final class_7784 output;

    public CustomAssetProvider(FabricDataOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        BiConsumer<String, byte[]> assetWriter = (path, data) -> {
            try {
                writer.method_43346(this.output.method_45971().resolve((String)path), data, HashCode.fromBytes((byte[])data));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        return CompletableFuture.runAsync(() -> {
            try {
                this.createWoodTextures(assetWriter);
                this.createBedPalette(assetWriter);
                this.createCopperBarPalette(assetWriter);
                UiResourceCreator.generateAssets(assetWriter);
                this.writeBlocksAndItems(assetWriter);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, (Executor)class_156.method_18349());
    }

    private void writeBlocksAndItems(BiConsumer<String, byte[]> writer) {
        StringBuilder t = new StringBuilder();
        DecorationsItems.SHELF.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf_top.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf_top").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf_double.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf_double").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_shelf")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_shelf")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.STUMP.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_stump.json", BASE_STUMP_MODEL_JSON.replace("|TYPE|", "stump").replace("|TOP|", "polydecorations:block/" + WoodUtil.getLogName(type) + "_stump_top").replace("|SIDE|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_stump")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_stump")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.STRIPPED_STUMP.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/stripped_" + type.comp_1299() + "_stump.json", BASE_STUMP_MODEL_JSON.replace("|TYPE|", "stump").replace("|TOP|", "polydecorations:block/stripped_" + WoodUtil.getLogName(type) + "_stump_top").replace("|SIDE|", "minecraft:block/stripped_" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("stripped_" + type.comp_1299() + "_stump")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/stripped_" + type.comp_1299() + "_stump")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.BENCH.forEach((type, item) -> {
            this.writeBench((class_4719)type, writer);
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_bench")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_bench")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.TABLE.forEach((type, block) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_table.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "table").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            for (int i = 1; i < TableBlock.TableModel.COUNT; ++i) {
                writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_table_" + i + ".json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "table_" + i).replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            }
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_table")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_table")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.WOODEN_STATUE.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_sign_post.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "sign_post").replace("|PLANKS|", "polydecorations:block/sign_post_" + type.comp_1299()).replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_sign_post")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_sign_post")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
            this.writeStatue(type.comp_1299(), "block/" + type.comp_1299() + "_planks", writer);
        });
        DecorationsItems.WOODEN_MAILBOX.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_mailbox.json", (type != class_4719.field_40350 ? MAILBOX_MODEL_JSON : MAILBOX_BAMBOO_MODEL_JSON).replace("|TYPE|", "mailbox").replace("|FRONT|", "polydecorations:block/mailbox_front_" + type.comp_1299()).replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).replace("|STRIPPED_LOG|", "minecraft:block/stripped_" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_mailbox")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_mailbox")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.TOOL_RACK.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_tool_rack.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "tool_rack").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.comp_1299() + "_tool_rack")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.comp_1299() + "_tool_rack")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.SLEEPING_BAG.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.method_15434() + "_sleeping_bag.json", BASE_SLEEPING_BAG_JSON.replace("|TYPE|", "base_sleeping_bag").replace("|TXT|", "polydecorations:block/sleeping_bag_" + type.method_15434()).replace("|PARTICLE|", "minecraft:block/" + type.method_15434() + "_wool").getBytes(StandardCharsets.UTF_8));
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type.method_15434() + "_sleeping_bag")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/" + type.method_15434() + "_sleeping_bag")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        });
        try {
            this.writeBaseTable(writer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("stone_statue")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("item/stone_statue")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        this.writeStatue("deepslate", "block/deepslate_top", writer);
        this.writeStatue("blackstone", "block/blackstone", writer);
        this.writeStatue("prismarine", "block/prismarine", writer);
        this.writeStatue("sandstone", "block/sandstone_top", writer);
        this.writeStatue("red_sandstone", "block/red_sandstone_top", writer);
        this.writeStatue("quartz", "block/quartz_block_bottom", writer);
        this.writeStatue("tuff", "block/tuff", writer);
        this.writeStatue("stone_bricks", "block/stone_bricks", writer);
        this.writeStatue("tuff_bricks", "block/tuff_bricks", writer);
        this.writeStatue("packed_mud", "block/packed_mud", writer);
        this.writeStatue("granite", "block/granite", writer);
        this.writeStatue("andesite", "block/andesite", writer);
        this.writeStatue("diorite", "block/diorite", writer);
        this.writeStatue("terracotta", "block/terracotta", writer);
        for (class_1767 color : class_1767.values()) {
            this.writeStatue(color.method_15434() + "_terracotta", "block/" + color.method_15434() + "_terracotta", writer);
            this.writeStatue(color.method_15434() + "_wool", "block/" + color.method_15434() + "_wool", writer);
        }
        DecorationsModels.ROPE.generateModels(writer);
        this.generateWindChimeModels(writer);
        for (class_1792 item2 : List.of(DecorationsItems.CANVAS, DecorationsItems.ROPE, DecorationsItems.GLOBE, DecorationsItems.GHOST_LIGHT, DecorationsItems.TRASHCAN, DecorationsItems.HAMMER, DecorationsItems.TROWEL, DecorationsItems.COPPER_CAMPFIRE)) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item2);
            writer.accept(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        }
        for (class_1792 item3 : List.of(DecorationsItems.DISPLAY_CASE, DecorationsItems.BRAZIER, DecorationsItems.SOUL_BRAZIER, DecorationsItems.COPPER_BRAZIER, DecorationsItems.LARGE_FLOWER_POT, DecorationsItems.LONG_FLOWER_POT)) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item3);
            writer.accept(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("block/")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        }
        writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("basket")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/basket_open")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
    }

    private void createWoodTextures(BiConsumer<String, byte[]> assetWriter) throws Exception {
        Path jar = PolymerCommonUtils.getClientJarRoot();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        BufferedImage oakPlanks = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/oak_planks.png"), new OpenOption[0]));
        ArrayList<int[]> positions = new ArrayList<int[]>();
        IntOpenHashSet existingColors = new IntOpenHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                int rgb = oakPlanks.getRGB(x, y);
                if (!existingColors.add(rgb)) continue;
                positions.add(new int[]{x, y});
            }
        }
        BufferedImage palette = new BufferedImage(positions.size(), 1, 1);
        for (class_4719 wood : WoodUtil.VANILLA) {
            BufferedImage input = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/" + wood.comp_1299() + "_planks.png"), new OpenOption[0]));
            for (int i = 0; i < positions.size(); ++i) {
                int[] pos = (int[])positions.get(i);
                palette.setRGB(i, 0, input.getRGB(pos[0], pos[1]));
            }
            ImageIO.write((RenderedImage)palette, "png", b);
            assetWriter.accept("assets/polydecorations/textures/palette/wood/" + wood.comp_1299() + ".png", b.toByteArray());
            b.reset();
        }
        for (String prefix : List.of("", "stripped_")) {
            for (class_4719 wood : WoodUtil.VANILLA) {
                BufferedImage source = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/" + prefix + WoodUtil.getLogName(wood) + "_top.png"), new OpenOption[0]));
                BufferedImage texture = new BufferedImage(source.getWidth(), source.getHeight(), 1);
                int frames = source.getHeight() / source.getWidth();
                for (int i = 0; i < frames; ++i) {
                    int offset = i * source.getWidth();
                    for (int x = 0; x < 5; ++x) {
                        for (int y = 0; y < 5; ++y) {
                            texture.setRGB(x + 3, y + 3 + offset, source.getRGB(x, y + offset));
                            texture.setRGB(x + 3 + 5, y + 3 + offset, source.getRGB(11 + x, y + offset));
                            texture.setRGB(x + 3, y + 3 + 5 + offset, source.getRGB(x, 11 + y + offset));
                            texture.setRGB(x + 3 + 5, y + 3 + 5 + offset, source.getRGB(11 + x, 11 + y + offset));
                        }
                    }
                }
                ImageIO.write((RenderedImage)texture, "png", b);
                assetWriter.accept("assets/polydecorations/textures/block/" + prefix + WoodUtil.getLogName(wood) + "_stump_top.png", b.toByteArray());
                Path mcMeta = jar.resolve("assets/minecraft/textures/block/" + prefix + WoodUtil.getLogName(wood) + "_top.png.mcmeta");
                if (Files.exists(mcMeta, new LinkOption[0])) {
                    assetWriter.accept("assets/polydecorations/textures/block/" + prefix + WoodUtil.getLogName(wood) + "_stump_top.png.mcmeta", Files.readAllBytes(mcMeta));
                }
                b.reset();
            }
        }
    }

    private void createCopperBarPalette(BiConsumer<String, byte[]> assetWriter) throws Exception {
        Path jar = PolymerCommonUtils.getClientJarRoot();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ArrayList<int[]> positions = new ArrayList<int[]>();
        BufferedImage ironBars = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/iron_bars.png"), new OpenOption[0]));
        IntOpenHashSet existingColors = new IntOpenHashSet();
        for (int x = 0; x < ironBars.getWidth(); ++x) {
            for (int y = 0; y < ironBars.getHeight(); ++y) {
                int rgb = ironBars.getRGB(x, y);
                if (!existingColors.add(rgb)) continue;
                positions.add(new int[]{x, y});
            }
        }
        BufferedImage palette = new BufferedImage(positions.size(), 1, 1);
        for (Map.Entry<String, String> type : COPPER_PREFIXES) {
            BufferedImage input = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/" + type.getKey() + "copper_bars.png"), new OpenOption[0]));
            for (int i = 0; i < positions.size(); ++i) {
                int[] pos = (int[])positions.get(i);
                palette.setRGB(i, 0, input.getRGB(pos[0], pos[1]));
            }
            ImageIO.write((RenderedImage)palette, "png", b);
            assetWriter.accept("assets/polydecorations/textures/palette/copper_bars/" + type.getValue() + ".png", b.toByteArray());
            b.reset();
        }
    }

    private void createBedPalette(BiConsumer<String, byte[]> assetWriter) throws Exception {
        int y;
        int x;
        Path jar = PolymerCommonUtils.getClientJarRoot();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ArrayList<int[]> positions = new ArrayList<int[]>();
        BufferedImage base = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/entity/bed/red.png"), new OpenOption[0]));
        IntOpenHashSet existingColors = new IntOpenHashSet();
        BufferedImage oakPlanks = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/oak_planks.png"), new OpenOption[0]));
        for (x = 0; x < oakPlanks.getWidth(); ++x) {
            for (y = 0; y < oakPlanks.getHeight(); ++y) {
                existingColors.add(oakPlanks.getRGB(x, y));
            }
        }
        for (x = 0; x < base.getWidth(); ++x) {
            for (y = 0; y < base.getHeight(); ++y) {
                int rgb = base.getRGB(x, y);
                if (!existingColors.add(rgb)) continue;
                positions.add(new int[]{x, y});
            }
        }
        BufferedImage palette = new BufferedImage(positions.size(), 1, 1);
        for (class_1767 color : class_1767.values()) {
            BufferedImage input = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/entity/bed/" + color.method_15434() + ".png"), new OpenOption[0]));
            for (int i = 0; i < positions.size(); ++i) {
                int[] pos = (int[])positions.get(i);
                palette.setRGB(i, 0, input.getRGB(pos[0], pos[1]));
            }
            ImageIO.write((RenderedImage)palette, "png", b);
            assetWriter.accept("assets/polydecorations/textures/palette/bed_color/" + color.method_15434() + ".png", b.toByteArray());
            b.reset();
        }
    }

    private void generateWindChimeModels(BiConsumer<String, byte[]> writer) {
        writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("wind_chime")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/wind_chime"), List.of(new ConstantTintSource(0xFFFFFF), new CustomModelDataTintSource(0, 0xFFFFFF), new CustomModelDataTintSource(1, 0xFFFFFF), new CustomModelDataTintSource(2, 0xFFFFFF), new CustomModelDataTintSource(3, 0xFFFFFF), new CustomModelDataTintSource(4, 0xFFFFFF))), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        JsonObject model = ResourceUtils.getModel(ModInit.id("block/wind_chime"));
        ModelAsset decoded = (ModelAsset)((Pair)ModelAsset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)model).getOrThrow()).getFirst();
        List groups = (List)((Pair)BlockbenchGroup.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)model).getOrThrow()).getFirst();
        ModelAsset.Builder base = ModelAsset.builder();
        ModelAsset.Builder[] chimes = new ModelAsset.Builder[5];
        List[] chimesElement = new List[5];
        for (int i = 0; i < 5; ++i) {
            chimes[i] = ModelAsset.builder();
            chimesElement[i] = new ArrayList();
            decoded.textures().forEach((arg_0, arg_1) -> ((ModelAsset.Builder)chimes[i]).texture(arg_0, arg_1));
        }
        decoded.textures().forEach((arg_0, arg_1) -> ((ModelAsset.Builder)base).texture(arg_0, arg_1));
        List el = (List)decoded.elements().orElseThrow();
        block1: for (int e = 0; e < el.size(); ++e) {
            for (BlockbenchGroup g : groups) {
                if (!g.children().contains(e)) continue;
                chimesElement[Integer.parseInt(g.name().substring("chime_".length()))].add((ModelElement)el.get(e));
                continue block1;
            }
            base.element((ModelElement)el.get(e));
        }
        ArrayList<class_243> chimeOffset = new ArrayList<class_243>();
        for (int i = 0; i < 5; ++i) {
            chimeOffset.add(((ModelElement.Rotation)((ModelElement)chimesElement[i].getFirst()).rotation().orElseThrow()).origin());
            for (ModelElement e : chimesElement[i]) {
                class_243 offset = ((ModelElement.Rotation)e.rotation().orElseThrow()).origin().method_22882().method_1031(8.0, 8.0, 8.0);
                EnumMap<class_2350, ModelElement.Face> map = new EnumMap<class_2350, ModelElement.Face>(class_2350.class);
                for (Map.Entry face : e.faces().entrySet()) {
                    map.put((class_2350)face.getKey(), ((ModelElement.Face)face.getValue()).tintIndex() > -1 ? new ModelElement.Face(((ModelElement.Face)face.getValue()).uv(), ((ModelElement.Face)face.getValue()).texture(), ((ModelElement.Face)face.getValue()).cullface(), ((ModelElement.Face)face.getValue()).rotation(), 0) : (ModelElement.Face)face.getValue());
                }
                chimes[i].element(new ModelElement(e.from().method_1019(offset), e.to().method_1019(offset), map));
            }
            writer.accept(AssetPaths.blockModel((class_2960)ModInit.id("wind_chime/chime_" + i)), chimes[i].build().toBytes());
            writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("-/block/wind_chime/chime_" + i)), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/wind_chime/chime_" + i), List.of(new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        }
        writer.accept("wind_chime_offsets.json", ((JsonElement)class_243.field_38277.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, chimeOffset).getOrThrow()).toString().getBytes(StandardCharsets.UTF_8));
        writer.accept(AssetPaths.blockModel((class_2960)ModInit.id("wind_chime/base")), base.build().toBytes());
        writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id("wind_chime")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/wind_chime"), List.of(new ConstantTintSource(0xFFFFFF), new CustomModelDataTintSource(0, 0xFFFFFF), new CustomModelDataTintSource(1, 0xFFFFFF), new CustomModelDataTintSource(2, 0xFFFFFF), new CustomModelDataTintSource(3, 0xFFFFFF), new CustomModelDataTintSource(4, 0xFFFFFF))), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
    }

    private void writeBaseTable(BiConsumer<String, byte[]> writer) throws IOException {
        JsonElement json = JsonParser.parseString((String)new String(Objects.requireNonNull(ResourceUtils.getJarData("assets/polydecorations/models/block/base_table.json"))));
        for (int i = 1; i < TableBlock.TableModel.COUNT; ++i) {
            List<String> corners = TableBlock.TableModel.toCornerNames(i);
            JsonObject obj = json.deepCopy().getAsJsonObject();
            JsonArray newElements = new JsonArray();
            JsonArray elements = obj.getAsJsonArray("elements");
            for (JsonElement el : elements) {
                if (el.getAsJsonObject().has("name") && !corners.contains(el.getAsJsonObject().get("name").getAsString())) continue;
                newElements.add(el);
            }
            obj.add("elements", (JsonElement)newElements);
            writer.accept("assets/polydecorations/models/block/base_table_" + i + ".json", obj.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeBench(class_4719 name, BiConsumer<String, byte[]> writer) {
        this.writeBenchSet(name, "", writer);
        this.writeBenchSet(name, "_norest", writer);
    }

    private void writeBenchSet(class_4719 type, String suffix, BiConsumer<String, byte[]> writer) {
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + ".json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix).replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_left.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_left").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_right.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_right").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_middle.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_middle").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
    }

    private void writeStatue(String type, String texture, BiConsumer<String, byte[]> writer) {
        for (String x : List.of("head", "body", "left_leg", "right_leg", "left_arm", "right_arm")) {
            writer.accept("assets/polydecorations/models/block/statue/" + type + "/" + x + ".json", STATUE_MODEL_JSON.replace("|TYPE|", x).replace("|TXT|", texture).getBytes(StandardCharsets.UTF_8));
        }
        writer.accept("assets/polydecorations/models/item/" + type + "_statue.json", STATUE_ITEM_JSON.replace("|TXT|", texture).getBytes(StandardCharsets.UTF_8));
        writer.accept(AssetPaths.itemAsset((class_2960)ModInit.id(type + "_statue")), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("item/" + type + "_statue")), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
    }

    public String method_10321() {
        return "polydecorations:assets";
    }
}

