/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.item;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polydecorations.block.extension.AttachedSignPostBlock;
import eu.pb4.polydecorations.block.extension.SignPostBlockEntity;
import eu.pb4.polydecorations.block.furniture.BenchBlock;
import eu.pb4.polydecorations.block.item.DisplayCaseBlock;
import eu.pb4.polydecorations.block.item.GlobeBlock;
import eu.pb4.polydecorations.block.item.MailboxBlock;
import eu.pb4.polydecorations.block.item.ToolRackBlock;
import eu.pb4.polydecorations.block.item.TrashCanBlock;
import eu.pb4.polymer.core.api.item.SimplePolymerItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_10225;
import net.minecraft.class_11586;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_7923;

public class HammerItem
extends SimplePolymerItem {
    public static List<Pair<Class<? extends class_2248>, Action>> ACTIONS_BY_CLASS = new ArrayList<Pair<Class<? extends class_2248>, Action>>();
    public static List<Pair<class_2248, Action>> ACTIONS_BY_TYPE = new ArrayList<Pair<class_2248, Action>>();

    public HammerItem(class_1792.class_1793 settings) {
        super(settings);
        AttackBlockCallback.EVENT.register(this::onBlockAttacked);
    }

    public class_1269 method_7884(class_1838 context) {
        return this.apply(context.method_8036(), context.method_8045(), context.method_8037(), context.method_17698(), false) ? class_1269.field_52422 : class_1269.field_5814;
    }

    private boolean apply(class_1657 player, class_1937 world, class_2338 blockPos, class_243 hitPos, boolean reverse) {
        if (!CommonProtection.canBreakBlock((class_1937)world, (class_2338)blockPos, (GameProfile)player.method_7334(), (class_1657)player) || !player.method_7294()) {
            return false;
        }
        class_2680 state = world.method_8320(blockPos);
        Action action = null;
        for (Pair<class_2248, Action> pair : ACTIONS_BY_TYPE) {
            if (!state.method_27852((class_2248)pair.getFirst())) continue;
            action = (Action)pair.getSecond();
            break;
        }
        if (action == null) {
            for (Pair pair : ACTIONS_BY_CLASS) {
                if (!((Class)pair.getFirst()).isAssignableFrom(state.method_26204().getClass())) continue;
                action = (Action)pair.getSecond();
                break;
            }
        }
        if (action == null) {
            return false;
        }
        class_2680 newState = action.apply(state, world, blockPos, hitPos, reverse);
        if (newState == state) {
            return false;
        }
        if (player instanceof class_3222) {
            class_3222 class_32222 = (class_3222)player;
            class_2498 group = Objects.requireNonNullElse(newState, state).method_26231();
            class_32222.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)group.method_10598()), class_3419.field_15245, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, (group.method_10597() + 1.0f) / 2.0f, group.method_10599() * 0.8f, player.method_59922().method_43055()));
        }
        if (newState != null) {
            world.method_8501(blockPos, newState);
        }
        return true;
    }

    private class_1269 onBlockAttacked(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player.method_5998(hand).method_31574((class_1792)this)) {
            class_239 cast = player.method_5745(player.method_55754(), 0.0f, false);
            return this.apply(player, world, pos, cast.method_17784(), false) ? class_1269.field_52422 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    static {
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2465.class, (Object)Action.cycleState(class_2465.field_11459)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2482.class, (Object)Action.cycleLimitedState(class_2482.field_11501, List.of(class_2771.field_12679, class_2771.field_12681))));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2533.class, (Object)Action.cycleState(class_2533.field_11177)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2349.class, (Object)Action.cycleState(class_2349.field_11177)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2211.class, (Object)Action.cycleState(class_2211.field_9917)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(MailboxBlock.class, (Object)Action.cycleState(MailboxBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(ToolRackBlock.class, (Object)Action.cycleState(ToolRackBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(BenchBlock.class, (Object)Action.cycleStateAndUpdate(BenchBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(DisplayCaseBlock.class, (Object)Action.cycleState(DisplayCaseBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(GlobeBlock.class, (Object)Action.cycleState(GlobeBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_11586.class, (Object)Action.cycleState(class_11586.field_61425)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(TrashCanBlock.class, (Object)Action.cycleState(TrashCanBlock.FACING)));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(AttachedSignPostBlock.class, (state, world, pos, hitResult, reverse) -> {
            class_2586 patt0$temp = world.method_8321(pos);
            if (patt0$temp instanceof SignPostBlockEntity) {
                boolean up;
                SignPostBlockEntity be = (SignPostBlockEntity)patt0$temp;
                boolean bl = up = hitResult.method_1020((class_243)class_243.method_24953((class_2382)pos)).field_1351 > 0.0;
                if (be.getText(up).isEmpty()) {
                    return state;
                }
                be.setText(up, be.getText(up).withYawAdded(reverse ? -15.0f : 15.0f));
                return null;
            }
            return state;
        }));
        ACTIONS_BY_CLASS.add((Pair<Class<? extends class_2248>, Action>)Pair.of(class_2510.class, (Object)new Action(){
            final Action rotate = Action.cycleState(class_2510.field_11571);
            final Action shape = Action.cycleState(class_2510.field_11565);
            final Action half = Action.cycleState(class_2510.field_11572);

            @Override
            public class_2680 apply(class_2680 state, class_1937 world, class_2338 pos, class_243 hitResult, boolean reverse) {
                class_2760 halfValue = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
                class_243 off = hitResult.method_1020(class_243.method_24953((class_2382)pos));
                if (halfValue == class_2760.field_12619 && off.field_1351 < 0.0 || halfValue == class_2760.field_12617 && off.field_1351 > 0.0) {
                    return this.shape.apply(state, world, pos, hitResult, reverse);
                }
                if (class_3532.method_20390((double)off.field_1351, (double)0.0)) {
                    return this.rotate.apply(state, world, pos, hitResult, reverse);
                }
                return this.half.apply(state, world, pos, hitResult, reverse);
            }
        }));
    }

    public static interface Action {
        public class_2680 apply(class_2680 var1, class_1937 var2, class_2338 var3, class_243 var4, boolean var5);

        public static <T extends Comparable<T>> Action cycleState(class_2769<T> property) {
            return (state, world, pos, hitResult, reverse) -> {
                Comparable curr = state.method_11654(property);
                List list = List.copyOf(property.method_11898());
                return (class_2680)state.method_11657(property, (Comparable)list.get((list.size() + list.indexOf(curr) + (reverse ? -1 : 1)) % list.size()));
            };
        }

        public static <T extends Comparable<T>> Action cycleLimitedState(class_2769<T> property, List<T> available) {
            return (state, world, pos, hitResult, reverse) -> {
                Comparable curr = state.method_11654(property);
                if (!available.contains(curr)) {
                    return state;
                }
                return (class_2680)state.method_11657(property, (Comparable)available.get((available.size() + available.indexOf(curr) + (reverse ? -1 : 1)) % available.size()));
            };
        }

        public static <T extends Comparable<T>> Action cycleStateAndUpdate(class_2769<T> property) {
            return Action.cycleState(property).then((state, world, pos, hitResult, reverse) -> {
                for (class_2350 dir : class_2350.values()) {
                    class_2338 offPos = pos.method_10093(dir);
                    state = state.method_26191((class_4538)world, (class_10225)world, pos, dir, offPos, world.method_8320(offPos), world.field_9229);
                }
                return state;
            });
        }

        default public Action then(Action action) {
            return (state, world, pos, hitResult, reverse) -> action.apply(this.apply(state, world, pos, hitResult, reverse), world, pos, hitResult, reverse);
        }
    }
}

