/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.ui;

import eu.pb4.polydecorations.polydex.PolydexTextures;
import eu.pb4.polydecorations.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_2561;

public class GuiTextures {
    public static final GuiElement EMPTY = UiResourceCreator.icon16("empty").get().build();
    public static final Function<class_2561, class_2561> SHELF = UiResourceCreator.background("shelf");
    public static final Function<class_2561, class_2561> TRASHCAN = UiResourceCreator.background("trashcan");
    public static final Function<class_2561, class_2561> SHELF_2 = UiResourceCreator.background("shelf_2");
    public static final Function<class_2561, class_2561> MAILBOX_SELECT = UiResourceCreator.background("mailbox_select");
    public static final Supplier<GuiElementBuilder> POLYDEX_BUTTON = UiResourceCreator.icon32("polydex");
    public static final Supplier<GuiElementBuilder> NEXT_PAGE_BUTTON = UiResourceCreator.icon16("next_page");
    public static final Supplier<GuiElementBuilder> PREVIOUS_PAGE_BUTTON = UiResourceCreator.icon16("previous_page");
    public static final Supplier<GuiElementBuilder> BACK_BUTTON = UiResourceCreator.icon16("back");

    public static void register() {
        PolydexTextures.register();
    }

    public record Progress(GuiElement[] elements) {
        public GuiElement get(float progress) {
            return this.elements[Math.min((int)(progress * (float)this.elements.length), this.elements.length - 1)];
        }

        public static Progress createVertical(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            GuiElement[] elements = new GuiElement[size + 1];
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress16(path, start, stop, reverse);
            elements[0] = EMPTY;
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).build();
            }
            return new Progress(elements);
        }

        public static Progress createHorizontal(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            GuiElement[] elements = new GuiElement[size + 1];
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress16(path, start, stop, reverse);
            elements[0] = EMPTY;
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).build();
            }
            return new Progress(elements);
        }

        public static Progress createHorizontal32(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            GuiElement[] elements = new GuiElement[size + 1];
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32(path, start, stop, reverse);
            elements[0] = EMPTY;
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).build();
            }
            return new Progress(elements);
        }

        public static Progress createHorizontal32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            GuiElement[] elements = new GuiElement[size + 1];
            IntFunction<GuiElementBuilder> function = UiResourceCreator.horizontalProgress32Right(path, start, stop, reverse);
            elements[0] = EMPTY;
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).build();
            }
            return new Progress(elements);
        }

        public static Progress createVertical32Right(String path, int start, int stop, boolean reverse) {
            int size = stop - start;
            GuiElement[] elements = new GuiElement[size + 1];
            IntFunction<GuiElementBuilder> function = UiResourceCreator.verticalProgress32Right(path, start, stop, reverse);
            elements[0] = EMPTY;
            for (int i = 1; i <= size; ++i) {
                elements[i] = function.apply(i - 1).build();
            }
            return new Progress(elements);
        }
    }
}

