/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.block.item;

import com.mojang.authlib.GameProfile;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.OwnedBlockEntity;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.factorytools.api.util.LegacyNbtHelper;
import eu.pb4.polydecorations.block.DecorationsBlockEntities;
import eu.pb4.polydecorations.block.item.MailboxBlock;
import eu.pb4.polydecorations.ui.GuiTextures;
import eu.pb4.polydecorations.ui.GuiUtils;
import eu.pb4.polydecorations.util.DecorationsUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4844;
import net.minecraft.class_5244;

public class MailboxBlockEntity
extends LockableBlockEntity
implements OwnedBlockEntity,
BlockEntityExtraListener {
    private MailboxBlock.Model model;
    private int lastDirty = 0;
    private GameProfile owner = null;
    protected final HashMap<UUID, class_1277> inventories = new HashMap();

    public MailboxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(DecorationsBlockEntities.MAILBOX, blockPos, blockState);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.owner != null) {
            view.method_71468("owner", class_2487.field_25128, (Object)LegacyNbtHelper.writeGameProfile((class_2487)new class_2487(), (GameProfile)this.owner));
        }
        class_11372.class_11374 inv = view.method_71476("inventory");
        for (Map.Entry<UUID, class_1277> x : this.inventories.entrySet()) {
            class_11372 cpd = inv.method_71480();
            class_1262.method_5426((class_11372)cpd, (class_2371)x.getValue().field_5828);
            cpd.method_71468("uuid", class_4844.field_40825, (Object)x.getKey());
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.owner = view.method_71426("owner", class_2487.field_25128).map(LegacyNbtHelper::toGameProfile).orElse(null);
        for (class_1277 x : this.inventories.values()) {
            x.method_5448();
        }
        this.inventories.clear();
        for (class_11368 cpd : view.method_71438("inventory")) {
            UUID uuid = cpd.method_71426("uuid", class_4844.field_40825).orElse(class_156.field_25140);
            class_1277 inv = this.createInventory();
            class_1262.method_5429((class_11368)cpd, (class_2371)inv.field_5828);
            this.inventories.put(uuid, inv);
        }
        if (this.model != null) {
            this.model.setHasMail(!this.inventories.isEmpty());
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            for (class_1277 value : this.inventories.values()) {
                class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)value);
            }
        }
    }

    protected class_2561 getContainerName() {
        return DecorationsUtil.someones(this.owner, (class_2561)this.method_11010().method_26204().method_9518());
    }

    private class_1277 createInventory() {
        return new class_1277(6){

            public void method_5431() {
                super.method_5431();
                MailboxBlockEntity.this.method_5431();
            }
        };
    }

    public class_1269 onUse(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if ((this.owner != null && player.method_5667().equals(this.owner.id()) || this.getContainerLock() != class_1273.field_5817 && this.checkUnlocked(player, false)) && (!player.method_7338() || !player.method_5998(class_1268.field_5808).method_31574(class_1802.field_8688))) {
                new SelectorGui(serverPlayer);
            } else {
                new InventoryGui(serverPlayer, serverPlayer.method_5667(), true);
            }
        }
        return class_1269.field_52422;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile profile) {
        this.owner = profile;
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        ++this.lastDirty;
    }

    public void onListenerUpdate(class_2818 chunk) {
        this.model = (MailboxBlock.Model)BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867).holder();
        this.model.setHasMail(!this.inventories.isEmpty());
    }

    private class SelectorGui
    extends SimpleGui {
        private static final int ENTRIES_PER_PAGE = 27;
        private final List<GuiElement> elements;
        private int page;
        private int pageCount;
        private int lastDirty;

        public SelectorGui(class_3222 player) {
            super(class_3917.field_18666, player, false);
            this.elements = new ArrayList<GuiElement>();
            this.pageCount = 1;
            this.lastDirty = 0;
            this.setTitle(GuiTextures.MAILBOX_SELECT.apply(MailboxBlockEntity.this.getName()));
            this.update();
            this.lastDirty = MailboxBlockEntity.this.lastDirty;
            this.open();
        }

        private void update() {
            this.updateElements();
            this.drawUi();
        }

        private void drawUi() {
            int i;
            int start = this.page * 27;
            int end = Math.min((this.page + 1) * 27, this.elements.size());
            for (i = start; i < end; ++i) {
                this.setSlot(i, (GuiElementInterface)this.elements.get(i));
            }
            while (i < 27) {
                this.clearSlot(i);
                ++i;
            }
            if (this.page > 0) {
                this.setSlot(48, (GuiElementBuilderInterface)GuiTextures.PREVIOUS_PAGE_BUTTON.get().setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_27692(class_124.field_1068)).setCallback((a, b, c) -> {
                    --this.page;
                    this.drawUi();
                    this.clickSound();
                }));
            } else if (this.page + 1 < this.pageCount) {
                this.setSlot(48, (GuiElementBuilderInterface)GuiTextures.NEXT_PAGE_BUTTON.get().setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_27692(class_124.field_1068)).setCallback((a, b, c) -> {
                    ++this.page;
                    this.drawUi();
                    this.clickSound();
                }));
            }
        }

        private void clickSound() {
            GuiUtils.playClickSound(this.player);
        }

        private void updateElements() {
            this.elements.clear();
            for (Map.Entry<UUID, class_1277> entry : MailboxBlockEntity.this.inventories.entrySet()) {
                GuiElementBuilder b = new GuiElementBuilder();
                Optional profile = this.player.method_51469().method_8503().method_73550().comp_4407().method_14512(entry.getKey());
                if (profile.isPresent()) {
                    b.setItem(class_1802.field_8575);
                    b.setProfile(((class_11560)profile.get()).comp_4422());
                    b.setName((class_2561)class_2561.method_43470((String)((class_11560)profile.get()).comp_4423()));
                } else {
                    b.setItem(class_1802.field_8398);
                    b.setName((class_2561)class_2561.method_43470((String)entry.getKey().toString()).method_27692(class_124.field_1079));
                }
                for (class_1799 stack : entry.getValue().field_5828) {
                    if (stack.method_7960()) continue;
                    b.addLoreLine((class_2561)class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{stack.method_7964(), String.valueOf(stack.method_7947())}).method_27692(class_124.field_1080));
                }
                b.setCallback((a, g, c) -> {
                    this.clickSound();
                    if (MailboxBlockEntity.this.inventories.get(entry.getKey()) != null) {
                        new InventoryGui(this.player, (UUID)entry.getKey(), false);
                    } else {
                        this.update();
                    }
                });
                this.elements.add(b.hideDefaultTooltip().build());
            }
            this.pageCount = this.elements.size() / 27 + (this.elements.size() % 27 == 0 ? 0 : 1);
        }

        public void onTick() {
            if (MailboxBlockEntity.this.method_11015() || this.player.method_73189().method_1025(class_243.method_24953((class_2382)MailboxBlockEntity.this.field_11867)) > 324.0) {
                this.close();
                return;
            }
            if (this.lastDirty != MailboxBlockEntity.this.lastDirty) {
                this.lastDirty = MailboxBlockEntity.this.lastDirty;
                this.update();
            }
            super.onTick();
        }
    }

    private class InventoryGui
    extends SimpleGui {
        private final class_1277 inventory;
        private final UUID target;

        public InventoryGui(class_3222 player, UUID target, boolean canPutItems) {
            super(class_3917.field_18665, player, false);
            this.setTitle(GuiTextures.SHELF_2.apply(DecorationsUtil.someones(MailboxBlockEntity.this.owner, (class_2561)MailboxBlockEntity.this.method_11010().method_26204().method_9518())));
            this.target = target;
            this.inventory = MailboxBlockEntity.this.inventories.computeIfAbsent(target, x -> MailboxBlockEntity.this.createInventory());
            this.setSlotRedirect(3, this.createSlot(this.inventory, 0, canPutItems));
            this.setSlotRedirect(4, this.createSlot(this.inventory, 1, canPutItems));
            this.setSlotRedirect(5, this.createSlot(this.inventory, 2, canPutItems));
            this.setSlotRedirect(12, this.createSlot(this.inventory, 3, canPutItems));
            this.setSlotRedirect(13, this.createSlot(this.inventory, 4, canPutItems));
            this.setSlotRedirect(14, this.createSlot(this.inventory, 5, canPutItems));
            GuiInterface curr = GuiHelpers.getCurrentGui((class_3222)player);
            if (curr instanceof SelectorGui) {
                SelectorGui selectorGui = (SelectorGui)curr;
                this.setSlot(17, (GuiElementBuilderInterface)GuiTextures.BACK_BUTTON.get().setName(class_5244.field_24339).setCallback((a, b, c) -> {
                    selectorGui.clickSound();
                    this.close(true);
                    selectorGui.open();
                }));
            }
            this.open();
        }

        private class_1735 createSlot(class_1277 inventory, int i, final boolean canPutItems) {
            return new class_1735(this, (class_1263)inventory, i, i, 0){

                public boolean method_7680(class_1799 stack) {
                    return super.method_7680(stack) && canPutItems;
                }
            };
        }

        public void onClose() {
            if (this.inventory.method_5442()) {
                MailboxBlockEntity.this.inventories.remove(this.target, this.inventory);
            } else if (MailboxBlockEntity.this.inventories.get(this.target) == null) {
                MailboxBlockEntity.this.inventories.put(this.target, this.inventory);
            } else if (MailboxBlockEntity.this.inventories.get(this.target) != this.inventory) {
                class_1264.method_5451((class_1937)MailboxBlockEntity.this.method_10997(), (class_2338)MailboxBlockEntity.this.method_11016(), (class_1263)this.inventory);
            }
            if (MailboxBlockEntity.this.model != null) {
                MailboxBlockEntity.this.model.setHasMail(!MailboxBlockEntity.this.inventories.isEmpty());
            }
            super.onClose();
        }

        public void onTick() {
            if (MailboxBlockEntity.this.method_11015() || this.player.method_73189().method_1025(class_243.method_24953((class_2382)MailboxBlockEntity.this.field_11867)) > 324.0) {
                this.close();
                return;
            }
            super.onTick();
        }
    }
}

