/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.block.other;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import eu.pb4.factorytools.api.block.CustomBreakingParticleBlock;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polydecorations.block.DecorationsBlocks;
import eu.pb4.polydecorations.model.DecorationsModels;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3749;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5431;
import net.minecraft.class_5819;
import net.minecraft.class_7713;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class RopeBlock
extends class_2248
implements FactoryBlock,
PolymerTexturedBlock,
CustomBreakingParticleBlock {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final class_2758 DISTANCE = class_2741.field_16503;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), directions -> {
        directions.put(class_2350.field_11043, class_2741.field_12489);
        directions.put(class_2350.field_11034, class_2741.field_12487);
        directions.put(class_2350.field_11035, class_2741.field_12540);
        directions.put(class_2350.field_11039, class_2741.field_12527);
        directions.put(class_2350.field_11036, class_2741.field_12519);
        directions.put(class_2350.field_11033, class_2741.field_12546);
    })));
    private static final class_2680 STATE = PolymerBlockResourceUtils.requestEmpty((BlockModelType)BlockModelType.VINES_BLOCK);
    private static final class_2394 BREAKING_PARTICLE = new class_2392(class_2398.field_11218, DecorationsModels.ROPE.get(0));

    public RopeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, DISTANCE});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        int distance = this.getDistanceAt((class_4538)ctx.method_8045(), ctx.method_8037());
        if (distance > 7) {
            return null;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = ctx.method_8037().method_10093(direction);
            class_2680 neighbor = ctx.method_8045().method_8320(neighborPos);
            if (direction == class_2350.field_11033 || !this.canConnect((class_4538)ctx.method_8045(), neighborPos, neighbor, direction.method_10153()) && !RopeBlock.canSupport((class_4538)ctx.method_8045(), neighborPos, neighbor, direction.method_10153())) continue;
            state = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private boolean canConnect(class_4538 world, class_2338 neighborPos, class_2680 neighbor, class_2350 opposite) {
        block4: {
            block5: {
                if (neighbor.method_27852((class_2248)this)) {
                    return true;
                }
                if (opposite != class_2350.field_11036) break block4;
                if (neighbor.method_26204() instanceof class_3749 || neighbor.method_27852((class_2248)DecorationsBlocks.WIND_CHIME)) break block5;
                class_2248 class_22482 = neighbor.method_26204();
                if (!(class_22482 instanceof class_7713)) break block4;
                class_7713 class_77132 = (class_7713)class_22482;
            }
            return true;
        }
        return false;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.getDistanceAt(world, pos) <= 7;
    }

    public int getDistanceAt(class_4538 world, class_2338 pos) {
        int distance = 8;
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033) continue;
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighbor = world.method_8320(neighborPos);
            if (direction == class_2350.field_11036 && neighbor.method_27852((class_2248)this)) {
                distance = Math.min((Integer)neighbor.method_11654((class_2769)DISTANCE), distance);
                continue;
            }
            if (neighbor.method_27852((class_2248)this)) {
                distance = Math.min((Integer)neighbor.method_11654((class_2769)DISTANCE) + 1, distance);
                continue;
            }
            if (!RopeBlock.canSupport(world, neighborPos, neighbor, direction.method_10153())) continue;
            distance = 0;
        }
        return distance;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        tickView.method_64310(pos, state.method_26204(), 1);
        return (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(this.canConnect(world, neighborPos, neighborState, direction.method_10153()) || RopeBlock.canSupport(world, neighborPos, neighborState, direction.method_10153())));
    }

    private static boolean canSupport(class_4538 world, class_2338 neighborPos, class_2680 blockState, class_2350 opposite) {
        return !blockState.method_26215() && !class_2248.method_9581((class_2680)blockState) && blockState.method_30368((class_1922)world, neighborPos, opposite, class_5431.field_25823);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int d = this.getDistanceAt((class_4538)world, pos);
        if (d > 7) {
            world.method_22352(pos, true);
        } else if (d != (Integer)state.method_11654((class_2769)DISTANCE)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(d)));
        }
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return STATE;
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10620.method_9564();
    }

    public static boolean checkModelDirection(class_2680 state, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(direction));
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public class_2394 getBreakingParticle(class_2680 blockState) {
        return BREAKING_PARTICLE;
    }

    public static class Model
    extends BlockModel {
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple();
        private class_2680 state;

        public Model(class_2680 state) {
            this.main.setViewRange(0.8f);
            this.main.setYaw(180.0f);
            this.setState(state);
            this.addElement((VirtualElement)this.main);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        protected void setState(class_2680 blockState) {
            this.state = blockState;
            this.updateModel();
        }

        protected void updateModel() {
            this.main.setItem(DecorationsModels.ROPE.get(this.state, RopeBlock::checkModelDirection));
            if (this.main.getHolder() == this) {
                this.main.tick();
            }
        }
    }
}

