/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.api.utils.VirtualDisplay;
import eu.pb4.polydecorations.entity.DecorationsEntities;
import eu.pb4.polydecorations.item.CanvasItem;
import eu.pb4.polydecorations.item.DecorationsItemTags;
import eu.pb4.polydecorations.item.DecorationsItems;
import eu.pb4.polydecorations.mixin.TagValueInputAccessor;
import eu.pb4.polydecorations.util.DecorationSoundEvents;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_8828;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class CanvasEntity
extends class_1530
implements PolymerEntity {
    @Nullable
    private static Optional<class_9331<Integer>> POLYFACTORY_COLOR = null;
    private static final Codec<class_2350> LEGACY_DIRECTION_CODEC = Codec.withAlternative((Codec)class_2350.field_29502, (Codec)Codec.INT, class_2350::method_10139);
    private final PlayerCanvas canvas;
    private final Set<class_3222> players = new HashSet<class_3222>();
    private byte[] data = new byte[256];
    private VirtualDisplay display;
    private boolean glowing;
    private boolean waxed;
    private boolean cut;
    private Optional<CanvasColor> background = Optional.empty();
    private class_2470 rotation = class_2470.field_11467;
    @Nullable
    private class_2561 name;

    public CanvasEntity(class_1299<? extends class_1530> entityType, class_1937 world) {
        super(entityType, world);
        this.canvas = DrawableCanvas.create();
        CanvasUtils.clear((DrawableCanvas)this.canvas, (CanvasColor)CanvasColor.OFF_WHITE_NORMAL);
    }

    public static Optional<CanvasColor> getColor(class_1799 stack) {
        class_1792 class_17922;
        if (POLYFACTORY_COLOR == null) {
            POLYFACTORY_COLOR = Optional.ofNullable((class_9331)class_7923.field_49658.method_63535(class_2960.method_60654((String)"polyfactory:color")));
        }
        if ((class_17922 = stack.method_7909()) instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            return Optional.ofNullable(CanvasColor.from((class_3620)dyeItem.method_7802().method_7794(), (class_3620.class_6594)class_3620.class_6594.field_34760));
        }
        if (POLYFACTORY_COLOR.isPresent() && stack.method_57826(POLYFACTORY_COLOR.get())) {
            return Optional.ofNullable(CanvasUtils.findClosestColor((int)((Integer)stack.method_58694(POLYFACTORY_COLOR.get()))));
        }
        return Optional.empty();
    }

    public static CanvasEntity create(class_1937 world, class_2350 side, class_2338 pos, float yaw) {
        CanvasEntity entity = new CanvasEntity(DecorationsEntities.CANVAS, world);
        entity.field_51589 = pos;
        entity.method_6892(side);
        if (side == class_2350.field_11036) {
            entity.rotation = switch (class_2350.method_10150((double)yaw)) {
                case class_2350.field_11043 -> class_2470.field_11467;
                case class_2350.field_11035 -> class_2470.field_11464;
                case class_2350.field_11034 -> class_2470.field_11463;
                case class_2350.field_11039 -> class_2470.field_11465;
                default -> entity.rotation;
            };
        } else if (side == class_2350.field_11033) {
            entity.rotation = switch (class_2350.method_10150((double)yaw)) {
                case class_2350.field_11043 -> class_2470.field_11467;
                case class_2350.field_11035 -> class_2470.field_11464;
                case class_2350.field_11034 -> class_2470.field_11465;
                case class_2350.field_11039 -> class_2470.field_11463;
                default -> entity.rotation;
            };
        }
        return entity;
    }

    protected void method_6892(class_2350 facing) {
        Validate.notNull((Object)facing);
        super.method_71770(facing);
        if (facing.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(facing.method_10161() * 90);
        } else {
            this.method_36457(-90 * facing.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    protected class_238 method_59943(class_2338 pos, class_2350 side) {
        class_243 vec3d = class_243.method_24953((class_2382)pos).method_43206(side, -0.46875);
        class_2350.class_2351 axis = side.method_10166();
        double d = axis == class_2350.class_2351.field_11048 ? 0.0625 : 1.0;
        double e = axis == class_2350.class_2351.field_11052 ? 0.0625 : 1.0;
        double g = axis == class_2350.class_2351.field_11051 ? 0.0625 : 1.0;
        return class_238.method_30048((class_243)vec3d, (double)d, (double)e, (double)g);
    }

    public void method_5837(class_3222 player) {
        if (this.display == null) {
            this.setupDisplay();
        }
        this.players.add(player);
        this.canvas.addPlayer(player);
        this.display.addPlayer(player);
    }

    private void setupDisplay() {
        this.display = VirtualDisplay.builder((PlayerCanvas)this.canvas, (class_2338)this.field_51589, (class_2350)this.method_5735()).glowing(this.glowing).invisible(this.cut).rotation(this.rotation).interactionCallback(this::onUsed).build();
    }

    private void rebuildDisplay() {
        if (this.display != null) {
            this.display.destroy();
            this.setupDisplay();
            this.players.forEach(arg_0 -> ((VirtualDisplay)this.display).addPlayer(arg_0));
        }
    }

    private void fromByteArray(byte[] data) {
        data = data.length == 0 ? new byte[256] : Arrays.copyOf(data, data.length);
        this.data = data;
        if (data.length == 256) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    CanvasUtils.fill((DrawableCanvas)this.canvas, (int)(x * 8), (int)(y * 8), (int)((x + 1) * 8), (int)((y + 1) * 8), (CanvasColor)this.getColor(data[x + y * 16]));
                }
            }
        } else {
            DefaultFonts.VANILLA.drawText((DrawableCanvas)this.canvas, "Invalid data!\nBytes found: " + data.length + "\nRequired: 256", 16, 16, 8.0, CanvasColor.RED_HIGH);
        }
    }

    private CanvasColor getColor(byte color) {
        if (color == 0) {
            return this.background.orElse(CanvasColor.OFF_WHITE_NORMAL);
        }
        return CanvasColor.getFromRaw((byte)color);
    }

    private void onUsed(class_3222 serverPlayerEntity, VirtualDisplay.ClickType clickType, int x, int y) {
        if (clickType.isLeft()) {
            if (CommonProtection.canDamageEntity((class_1937)this.method_73183(), (class_1297)this, (GameProfile)serverPlayerEntity.method_7334(), (class_1657)serverPlayerEntity)) {
                serverPlayerEntity.method_7324((class_1297)this);
            }
            return;
        }
        if (this.waxed || !CommonProtection.canInteractEntity((class_1937)this.method_73183(), (class_1297)this, (GameProfile)serverPlayerEntity.method_7334(), (class_1657)serverPlayerEntity)) {
            return;
        }
        x /= 8;
        y /= 8;
        int radius = 0;
        CanvasColor color = null;
        class_1799 stack = serverPlayerEntity.method_6047();
        if (stack.method_31574(class_1802.field_42716)) {
            radius = 1;
            stack = serverPlayerEntity.method_6079();
        }
        CanvasColor raw = CanvasColor.getFromRaw((byte)this.data[x + y * 16]);
        if (this.cut && raw == CanvasColor.CLEAR_FORCE) {
            return;
        }
        if (stack.method_31573(ConventionalItemTags.DYES)) {
            Optional<CanvasColor> a = CanvasEntity.getColor(stack);
            if (a.isPresent()) {
                color = a.get();
            }
        } else if (stack.method_31573(DecorationsItemTags.CANVAS_CLEAR_PIXELS)) {
            color = CanvasColor.CLEAR;
        } else if (stack.method_31573(DecorationsItemTags.CANVAS_DARKEN_PIXELS) && raw.getColor() != class_3620.field_16008) {
            if (raw.getBrightness() != class_3620.class_6594.field_34762) {
                class_3620 class_36202 = raw.getColor();
                color = CanvasColor.from((class_3620)class_36202, (class_3620.class_6594)(switch (raw.getBrightness()) {
                    case class_3620.class_6594.field_34761 -> class_3620.class_6594.field_34760;
                    case class_3620.class_6594.field_34760 -> class_3620.class_6594.field_34759;
                    default -> class_3620.class_6594.field_34762;
                }));
            }
        } else if (stack.method_31573(DecorationsItemTags.CANVAS_LIGHTEN_PIXELS) && raw.getColor() != class_3620.field_16008 && raw.getBrightness() != class_3620.class_6594.field_34761) {
            class_3620 class_36203 = raw.getColor();
            color = CanvasColor.from((class_3620)class_36203, (class_3620.class_6594)(switch (raw.getBrightness()) {
                case class_3620.class_6594.field_34762 -> class_3620.class_6594.field_34759;
                case class_3620.class_6594.field_34759 -> class_3620.class_6594.field_34760;
                default -> class_3620.class_6594.field_34761;
            }));
        }
        if (color == null) {
            return;
        }
        CanvasColor tColor = this.getColor(color.getRenderColor());
        for (int xi = x - radius; xi <= x + radius; ++xi) {
            for (int yi = y - radius; yi <= y + radius; ++yi) {
                if (xi < 0 || xi >= 16 || yi < 0 || yi >= 16 || this.data[xi + yi * 16] == 1) continue;
                CanvasUtils.fill((DrawableCanvas)this.canvas, (int)(xi * 8), (int)(yi * 8), (int)((xi + 1) * 8), (int)((yi + 1) * 8), (CanvasColor)tColor);
                this.data[xi + yi * 16] = color.getRenderColor();
            }
        }
        serverPlayerEntity.method_23667(class_1268.field_5808, true);
        if (this.display != null) {
            this.canvas.sendUpdates();
        }
    }

    public void method_5742(class_3222 player) {
        this.canvas.removePlayer(player);
        if (this.display != null) {
            this.display.removePlayer(player);
        }
        this.players.remove(player);
    }

    public void method_36209() {
        if (this.display != null) {
            this.display.destroy();
            this.display = null;
        }
        super.method_36209();
    }

    public void loadFromStack(class_1799 stack) {
        if (!stack.method_57826(CanvasItem.DATA_TYPE)) {
            return;
        }
        CanvasItem.Data comp = (CanvasItem.Data)stack.method_58695(CanvasItem.DATA_TYPE, (Object)CanvasItem.Data.DEFAULT);
        this.background = comp.background();
        this.glowing = comp.glowing();
        this.waxed = comp.waxed();
        this.cut = comp.cut();
        if (comp.image().isPresent()) {
            this.fromByteArray(comp.image().get());
        } else {
            CanvasUtils.clear((DrawableCanvas)this.canvas, (CanvasColor)this.background.orElse(CanvasColor.OFF_WHITE_NORMAL));
        }
        this.name = (class_2561)stack.method_58694(class_9334.field_49631);
        this.rebuildDisplay();
    }

    public void method_5749(class_11368 view) {
        class_8828.class_2585 literal;
        class_7417 class_74172;
        TagValueInputAccessor nbtReadViewAccessor;
        class_2487 nbt;
        if (view instanceof TagValueInputAccessor && (nbt = (nbtReadViewAccessor = (TagValueInputAccessor)view).getInput()).method_10580("data") instanceof class_2479) {
            nbt.method_10566("image", nbt.method_10580("data"));
            nbt.method_10551("data");
        }
        super.method_5749(view);
        this.method_6892(view.method_71426("facing", LEGACY_DIRECTION_CODEC).orElse(this.method_5735()));
        this.glowing = view.method_71433("glowing", false);
        this.waxed = view.method_71433("waxed", false);
        this.cut = view.method_71433("cut", false);
        byte backgroundByte = view.method_71421("background", (byte)0);
        this.background = backgroundByte == 0 ? Optional.empty() : Optional.ofNullable(CanvasColor.getFromRaw((byte)backgroundByte));
        this.fromByteArray(view.method_71426("image", (Codec)Codec.BYTE_BUFFER).map(ByteBuffer::array).orElse(new byte[0]));
        this.name = view.method_71426("name", class_8824.field_46597).orElse(null);
        this.rotation = view.method_71426("block_rotation", class_2470.field_39313).orElse(class_2470.field_11467);
        if (this.name != null && this.name.method_10855().isEmpty() && (class_74172 = this.name.method_10851()) instanceof class_8828.class_2585 && (literal = (class_8828.class_2585)class_74172).comp_737().length() >= 2 && literal.comp_737().charAt(0) == '\"' && literal.comp_737().charAt(literal.comp_737().length() - 1) == '\"') {
            this.name = class_2561.method_43470((String)literal.comp_737().substring(1, literal.comp_737().length() - 1));
        }
        this.rebuildDisplay();
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("facing", LEGACY_DIRECTION_CODEC, (Object)this.method_5735());
        view.method_71468("image", (Codec)Codec.BYTE_BUFFER, (Object)ByteBuffer.wrap(Arrays.copyOf(this.data, this.data.length)));
        view.method_71472("glowing", this.glowing);
        view.method_71472("waxed", this.waxed);
        view.method_71472("cut", this.cut);
        view.method_71468("block_rotation", class_2470.field_39313, (Object)this.rotation);
        this.background.ifPresent(canvasColor -> view.method_71462("background", canvasColor.getRenderColor()));
        if (this.name != null) {
            view.method_71468("name", class_8824.field_46597, (Object)this.name);
        }
    }

    public void method_6894() {
        this.method_5783(DecorationSoundEvents.CANVAS_PLACE, 1.0f, 1.0f);
    }

    public void method_6889(class_3218 serverWorld, @Nullable class_1297 entity) {
        class_1657 player;
        this.method_5783(DecorationSoundEvents.CANVAS_BREAK, 1.0f, 1.0f);
        class_1799 stack = this.toStack();
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_68878() && ((CanvasItem.Data)stack.method_58695(CanvasItem.DATA_TYPE, (Object)CanvasItem.Data.DEFAULT)).image().isEmpty()) {
            return;
        }
        this.method_5775(serverWorld, stack);
    }

    @Nullable
    public class_1799 method_31480() {
        return this.toStack();
    }

    private class_1799 toStack() {
        class_1799 stack = new class_1799((class_1935)DecorationsItems.CANVAS);
        byte[] data = null;
        for (byte b : this.data) {
            if (b == 0) continue;
            data = Arrays.copyOf(this.data, this.data.length);
            break;
        }
        stack.method_57379(CanvasItem.DATA_TYPE, (Object)new CanvasItem.Data(Optional.ofNullable(data), this.background, this.glowing, this.waxed, this.cut));
        if (this.name != null) {
            stack.method_57379(class_9334.field_49631, (Object)this.name);
        }
        return stack;
    }

    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_33456;
    }
}

