/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.entity;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polydecorations.ModInit;
import eu.pb4.polydecorations.item.DecorationsItems;
import eu.pb4.polydecorations.item.StatueItem;
import eu.pb4.polydecorations.util.DecorationsUtil;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2752;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_5629;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class StatueEntity
extends class_1531
implements PolymerEntity {
    private static final class_2379 DEFAULT_HEAD_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_BODY_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_LEFT_ARM_ROTATION = new class_2379(-10.0f, 0.0f, -10.0f);
    private static final class_2379 DEFAULT_RIGHT_ARM_ROTATION = new class_2379(-15.0f, 0.0f, 10.0f);
    private static final class_2379 DEFAULT_LEFT_LEG_ROTATION = new class_2379(-1.0f, 0.0f, -1.0f);
    private static final class_2379 DEFAULT_RIGHT_LEG_ROTATION = new class_2379(1.0f, 0.0f, 1.0f);
    private final Model model = new Model(this);
    private class_1799 stack;
    private StatueItem item;

    public StatueEntity(class_1299<? extends class_1531> entityType, class_1937 world) {
        super(entityType, world);
        this.setStack(DecorationsItems.OTHER_STATUE.get(Type.STONE).method_7854());
        EntityAttachment.of((ElementHolder)this.model, (class_1297)this);
        this.method_6913(true);
        this.method_5875(true);
    }

    public void onEntityTrackerTick(Set<class_5629> listeners) {
        this.model.tick();
    }

    public class_1799 method_31480() {
        return this.stack.method_7972();
    }

    protected void method_6924(class_3218 world, class_1282 damageSource) {
        class_1799 itemStack = this.stack.method_7972();
        if (this.method_16914()) {
            itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        }
        class_2248.method_9577((class_1937)world, (class_2338)this.method_24515(), (class_1799)itemStack);
        this.method_6908(world, damageSource);
    }

    public void method_5773() {
        this.model.setScale(this.method_55693());
        super.method_5773();
    }

    protected void method_6898() {
        if (this.method_73183() instanceof class_3218) {
            ((class_3218)this.method_73183()).method_65096((class_2394)new class_2388(class_2398.field_11217, this.item.getType().block().method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.stack.method_7960()) {
            view.method_71468("stack", class_1799.field_49266, (Object)this.stack);
        }
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.setStack(view.method_71426("stack", class_1799.field_49266).orElse(class_1799.field_8037));
    }

    public void method_36456(float yaw) {
        super.method_36456(yaw);
        if (this.model != null) {
            this.model.setYaw(yaw);
        }
    }

    public void method_5834(boolean glowing) {
        super.method_5834(glowing);
        this.model.setGlowing(glowing);
    }

    protected void method_5729(int index, boolean value) {
        super.method_5729(index, value);
        if (index == 6) {
            this.model.setGlowing(value);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (!this.method_31481()) {
            if (source.method_48789(class_8103.field_42242)) {
                this.method_5768(world);
                return false;
            }
            if (!(this.method_5679(world, source) || this.method_5767() || this.method_6912())) {
                if (source.method_48789(class_8103.field_42249)) {
                    this.method_6908(world, source);
                    this.method_5768(world);
                    return false;
                }
                if (source.method_48789(class_8103.field_42258) && !this.item.getType().fireproof()) {
                    if (this.method_5809()) {
                        this.method_6905(world, source, 0.15f);
                    } else {
                        this.method_5639(5.0f);
                    }
                    return false;
                }
                if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f && !this.item.getType().fireproof()) {
                    this.method_6905(world, source, 4.0f);
                    return false;
                }
                boolean bl = source.method_48789(class_8103.field_46230);
                boolean bl2 = source.method_48789(class_8103.field_46211);
                if (!bl && !bl2) {
                    return false;
                }
                class_1297 var6 = source.method_5529();
                if (var6 instanceof class_1657) {
                    class_1657 playerEntity = (class_1657)var6;
                    if (!playerEntity.method_31549().field_7476) {
                        return false;
                    }
                }
                if (source.method_5530()) {
                    this.method_6920();
                    this.method_6898();
                    this.method_5768(world);
                    return true;
                }
                long l = this.method_73183().method_75260();
                if (l - this.field_7112 > 5L && !bl2) {
                    this.method_73183().method_8421((class_1297)this, (byte)32);
                    this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
                    this.field_7112 = l;
                } else {
                    this.method_6924(world, source);
                    this.method_6898();
                    this.method_5768(world);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected class_2561 method_23315() {
        return this.stack.method_7964();
    }

    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6131;
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        boolean sendFlags = initial;
        for (int i = 0; i < data.size(); ++i) {
            class_2945.class_7834<?> x = data.get(i);
            if (x.comp_1115() != EntityTrackedData.FLAGS.comp_2327()) continue;
            data.set(i, class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)((Byte)x.comp_1117() | 1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))));
            sendFlags = false;
        }
        if (initial && sendFlags) {
            data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(field_5990) | 1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))));
        }
    }

    protected void method_6920() {
        this.method_73183().method_43128((class_1297)((class_1657)null), this.method_23317(), this.method_23318(), this.method_23321(), this.item.getType().soundGroup().method_10595(), this.method_5634(), 1.0f, 1.0f);
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(this.item.getType().soundGroup().method_10594(), this.item.getType().soundGroup().method_10593());
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return this.item.getType().soundGroup().method_10596();
    }

    @Nullable
    protected class_3414 method_6002() {
        return this.item.getType().soundGroup().method_10595();
    }

    public void method_6919(class_2379 angle) {
        super.method_6919(angle);
        this.model.head.updateAngle(angle);
    }

    public void method_6910(class_2379 angle) {
        super.method_6910(angle);
        this.model.leftArm.updateAngle(angle);
    }

    public void method_6925(class_2379 angle) {
        super.method_6925(angle);
        this.model.rightArm.updateAngle(angle);
    }

    public void method_6909(class_2379 angle) {
        super.method_6909(angle);
        this.model.leftLeg.updateAngle(angle);
    }

    public void method_6926(class_2379 angle) {
        super.method_6926(angle);
        this.model.rightLeg.updateAngle(angle);
    }

    public void method_6927(class_2379 angle) {
        super.method_6927(angle);
        this.model.body.updateAngle(angle);
    }

    protected void method_6922(boolean small) {
        super.method_6922(small);
        this.model.setSmall(small);
    }

    public void setStack(class_1799 itemStack) {
        this.stack = itemStack;
        class_1792 class_17922 = this.stack.method_7909();
        if (class_17922 instanceof StatueItem) {
            StatueItem statueItem;
            this.item = statueItem = (StatueItem)class_17922;
            this.model.setType(statueItem.getType());
        }
    }

    public static final class Model
    extends ElementHolder {
        public final Bone head = Bone.from(new Vector3f(0.0f, 1.5f, 0.0f), field_7113);
        public final Bone body = Bone.from(new Vector3f(0.0f, 1.5f, 0.0f), field_7119);
        public final Bone leftArm = Bone.from(new Vector3f(0.3125f, 1.375f, 0.0f), field_7124);
        public final Bone rightArm = Bone.from(new Vector3f(-0.3125f, 1.375f, 0.0f), field_7115);
        public final Bone leftLeg = Bone.from(new Vector3f(0.125f, 0.75f, 0.0f), field_7121);
        public final Bone rightLeg = Bone.from(new Vector3f(-0.125f, 0.75f, 0.0f), field_7117);
        private final StatueEntity entity;
        private boolean small = false;
        private float baseScale = 1.0f;

        public Model(StatueEntity entity) {
            this.entity = entity;
            this.addElement((VirtualElement)this.head.display);
            this.addElement((VirtualElement)this.body.display);
            this.addElement((VirtualElement)this.leftLeg.display);
            this.addElement((VirtualElement)this.rightLeg.display);
            this.addElement((VirtualElement)this.leftArm.display);
            this.addElement((VirtualElement)this.rightArm.display);
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.head.display.getEntityId());
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.body.display.getEntityId());
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.leftLeg.display.getEntityId());
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.rightLeg.display.getEntityId());
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.leftArm.display.getEntityId());
            VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int)this.rightArm.display.getEntityId());
        }

        public void setYaw(float yaw) {
            this.head.setYaw(yaw);
            this.body.setYaw(yaw);
            this.leftArm.setYaw(yaw);
            this.rightArm.setYaw(yaw);
            this.leftLeg.setYaw(yaw);
            this.rightLeg.setYaw(yaw);
        }

        public void setSmall(boolean small) {
            if (this.small != small) {
                this.small = small;
                this.updateScale();
            }
        }

        public void setScale(float scale) {
            if (this.baseScale != scale) {
                this.baseScale = scale;
                this.updateScale();
            }
        }

        private void updateScale() {
            float scale = (this.small ? 0.5f : 1.0f) * this.baseScale;
            this.head.setScale(scale, (this.small ? 0.75f : 1.0f) * this.baseScale);
            this.body.setScale(scale, scale);
            this.leftArm.setScale(scale, scale);
            this.rightArm.setScale(scale, scale);
            this.leftLeg.setScale(scale, scale);
            this.rightLeg.setScale(scale, scale);
        }

        public void setType(Type type) {
            this.head.display.setItem(type.head);
            this.body.display.setItem(type.body);
            this.leftArm.display.setItem(type.leftArm);
            this.rightArm.display.setItem(type.rightArm);
            this.leftLeg.display.setItem(type.leftLeg);
            this.rightLeg.display.setItem(type.rightLeg);
        }

        protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> packetConsumer) {
            super.startWatchingExtraPackets(player, packetConsumer);
            packetConsumer.accept((class_2596<class_2602>)new class_2752((class_1297)this.entity));
        }

        protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
        }

        public void setGlowing(boolean glowing) {
            this.head.display.setGlowing(glowing);
            this.body.display.setGlowing(glowing);
            this.leftArm.display.setGlowing(glowing);
            this.rightArm.display.setGlowing(glowing);
            this.leftLeg.display.setGlowing(glowing);
            this.rightLeg.display.setGlowing(glowing);
        }

        public record Bone(ItemDisplayElement display, Vector3f offset, MutableObject<class_2379> angle) {
            public static Bone from(Vector3f offset, class_2379 angle) {
                ItemDisplayElement d = new ItemDisplayElement();
                d.setItemDisplayContext(class_811.field_4317);
                d.setOffset(new class_243(0.0, (double)class_1299.field_6131.method_17686(), 0.0));
                d.setInvisible(true);
                d.setSendPositionUpdates(false);
                d.setTeleportDuration(2);
                d.setTranslation((Vector3fc)offset.sub(0.0f, class_1299.field_6131.method_17686(), 0.0f));
                d.setLeftRotation((Quaternionfc)new Quaternionf().rotationZYX(-angle.comp_3778() * ((float)Math.PI / 180), -angle.comp_3777() * ((float)Math.PI / 180), angle.comp_3776() * ((float)Math.PI / 180)));
                return new Bone(d, offset, (MutableObject<class_2379>)new MutableObject((Object)angle));
            }

            public boolean updateAngle(class_2379 angle) {
                if (((class_2379)this.angle.getValue()).equals((Object)angle)) {
                    return false;
                }
                this.angle.setValue((Object)angle);
                this.display.setLeftRotation((Quaternionfc)new Quaternionf().rotationZYX(-angle.comp_3778() * ((float)Math.PI / 180), -angle.comp_3777() * ((float)Math.PI / 180), angle.comp_3776() * ((float)Math.PI / 180)));
                this.display.tick();
                return true;
            }

            public void setScale(float position, float element) {
                this.display.setScale((Vector3fc)new Vector3f(element));
                this.display.setTranslation((Vector3fc)new Vector3f((Vector3fc)this.offset).mul(position));
            }

            public void setYaw(float yaw) {
                this.display.setYaw(yaw);
            }
        }
    }

    public record Type(String type, class_1799 head, class_1799 body, class_1799 leftArm, class_1799 rightArm, class_1799 leftLeg, class_1799 rightLeg, class_2248 block, boolean fireproof) {
        public static final List<Type> NON_WOOD = new ArrayList<Type>();
        public static final Type STONE = Type.nonWood("stone", class_2246.field_10340);
        public static final Type DEEPSLATE = Type.nonWood("deepslate", class_2246.field_28888);
        public static final Type BLACKSTONE = Type.nonWood("blackstone", class_2246.field_23869);
        public static final Type PRISMARINE = Type.nonWood("prismarine", class_2246.field_10135);
        public static final Type SANDSTONE = Type.nonWood("sandstone", class_2246.field_9979);
        public static final Type RED_SANDSTONE = Type.nonWood("red_sandstone", class_2246.field_10344);
        public static final Type QUARTZ = Type.nonWood("quartz", class_2246.field_10153);
        public static final Type ANDESITE = Type.nonWood("andesite", class_2246.field_10115);
        public static final Type DIORITE = Type.nonWood("diorite", class_2246.field_10508);
        public static final Type GRANITE = Type.nonWood("granite", class_2246.field_10474);
        public static final Type TUFF = Type.nonWood("tuff", class_2246.field_27165);
        public static final Type PACKED_MUD = Type.nonWood("packed_mud", class_2246.field_37556);
        public static final Type STONE_BRICKS = Type.nonWood("stone_bricks", class_2246.field_10056);
        public static final Type TUFF_BRICKS = Type.nonWood("tuff_bricks", class_2246.field_47035);
        public static final Type TERRACOTTA = Type.nonWood("terracotta", class_2246.field_10415);
        public static final Map<class_1767, Type> COLORED_TERRACOTTA = (Map)class_156.method_654(new HashMap(), x -> {
            for (class_1767 color : DecorationsUtil.COLORS_CREATIVE) {
                x.put(color, Type.nonWood(color.method_15434() + "_terracotta", (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)(color.method_15434() + "_terracotta")))));
            }
        });
        public static final Map<class_1767, Type> COLORED_WOOL = (Map)class_156.method_654(new HashMap(), x -> {
            for (class_1767 color : DecorationsUtil.COLORS_CREATIVE) {
                x.put(color, Type.burnableNonWood(color.method_15434() + "_wool", (class_2248)class_7923.field_41175.method_63535(class_2960.method_60656((String)(color.method_15434() + "_wool")))));
            }
        });

        public static Type burnableNonWood(String name, class_2248 block) {
            Type x = Type.of(name, block, false);
            NON_WOOD.add(x);
            return x;
        }

        public static Type nonWood(String name, class_2248 block) {
            Type x = Type.of(name, block, true);
            NON_WOOD.add(x);
            return x;
        }

        public static Type of(String type, class_2248 block, boolean fireproof) {
            return new Type(type, Type.requestModel(type, "head"), Type.requestModel(type, "body"), Type.requestModel(type, "left_arm"), Type.requestModel(type, "right_arm"), Type.requestModel(type, "left_leg"), Type.requestModel(type, "right_leg"), block, fireproof);
        }

        private static class_1799 requestModel(String type, String head) {
            return ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/statue/" + type + "/" + head));
        }

        public class_2498 soundGroup() {
            return this.block.method_9564().method_26231();
        }
    }
}

