/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polydecorations.util.ResourceUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class DirectionConnectingModel {
    public static final int SIZE = (int)Math.pow(2.0, 6.0);
    private final class_2960 baseModel;
    private final class_1799[] models = new class_1799[SIZE];

    public DirectionConnectingModel(class_2960 baseModel) {
        this.baseModel = baseModel;
        for (int i = 0; i < SIZE; ++i) {
            this.models[i] = ItemDisplayElementUtil.getModel((class_2960)baseModel.method_48331("/" + i));
        }
    }

    public void generateModels(BiConsumer<String, byte[]> dataWriter) {
        JsonObject model = ResourceUtils.getElementResolvedModel(this.baseModel);
        for (int i = 0; i < SIZE; ++i) {
            int dirCount = 0;
            int axisCount = 0;
            for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
                boolean a = DirectionConnectingModel.hasDirection(i, class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056));
                boolean b = DirectionConnectingModel.hasDirection(i, class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060));
                if (a && b) {
                    ++axisCount;
                    dirCount += 2;
                    continue;
                }
                if (!a && !b) continue;
                ++dirCount;
            }
            JsonObject base = new JsonObject();
            base.asMap().putAll(model.asMap());
            JsonArray elements = new JsonArray();
            for (JsonElement element : model.getAsJsonArray("elements")) {
                class_2350 dir;
                JsonElement name = element.getAsJsonObject().get("name");
                if (name != null && name.getAsString().equals("center_linear")) {
                    if (dirCount == 2 && axisCount == 1) continue;
                    elements.add(element);
                    continue;
                }
                if (name != null && name.getAsString().equals("center_knot")) {
                    if (dirCount < 3 && dirCount != 0) continue;
                    elements.add(element);
                    continue;
                }
                if (name != null && name.getAsString().equals("center_no_knot")) {
                    if (dirCount >= 3 && dirCount == 0) continue;
                    elements.add(element);
                    continue;
                }
                if (name != null && name.getAsString().startsWith("rp_")) {
                    dir = class_2350.method_10168((String)name.getAsString().substring("rp_".length()));
                    if (dir == null || dirCount == 0) {
                        elements.add(element);
                        continue;
                    }
                    if (dirCount == 1 && DirectionConnectingModel.hasDirection(i, dir.method_10153())) {
                        elements.add(element);
                        continue;
                    }
                    if (!DirectionConnectingModel.hasDirection(i, dir)) continue;
                    elements.add(element);
                    continue;
                }
                if (name != null && name.getAsString().startsWith("tuft_")) {
                    dir = class_2350.method_10168((String)name.getAsString().substring("tuft_".length()));
                    if (dir == null || dirCount == 0) {
                        elements.add(element);
                        continue;
                    }
                    if (dirCount != 1 || !DirectionConnectingModel.hasDirection(i, dir.method_10153())) continue;
                    elements.add(element);
                    continue;
                }
                if (name != null && class_2350.method_10168((String)name.getAsString()) != null) {
                    if (!DirectionConnectingModel.hasDirection(i, class_2350.method_10168((String)name.getAsString()))) continue;
                    elements.add(element);
                    continue;
                }
                elements.add(element);
            }
            base.add("elements", (JsonElement)elements);
            dataWriter.accept(AssetPaths.model((class_2960)this.baseModel.method_48331("/" + i + ".json")), base.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public class_1799 get(class_2680 state, BiPredicate<class_2680, class_2350> directionPredicate) {
        return this.get(DirectionConnectingModel.getModelId(state, directionPredicate));
    }

    public class_1799 get(int i) {
        return this.models[i];
    }

    public static boolean hasDirection(int i, class_2350 direction) {
        if (direction == null) {
            return false;
        }
        return (i & 1 << direction.ordinal()) != 0;
    }

    public static int getModelId(class_2680 state, BiPredicate<class_2680, class_2350> directionPredicate) {
        int i = 0;
        for (int j = 0; j < class_2350.values().length; ++j) {
            class_2350 direction = class_2350.values()[j];
            if (!directionPredicate.test(state, direction)) continue;
            i |= 1 << j;
        }
        return i;
    }
}

