/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="pop_up_emotes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static final String CUSTOM_PACK_FOLDER_NAME = "pop_emote_pack";
    public static ForgeConfigSpec.BooleanValue brightEmotes;
    public static ForgeConfigSpec.DoubleValue emoteVerticalOffset;
    public static ForgeConfigSpec.DoubleValue emoteScale;
    public static ForgeConfigSpec.IntValue maxEmoteAmount;
    public static ForgeConfigSpec.IntValue maxPackSizeMB;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            EmoteRenderer.emoteVerticalOffset = ((Double)emoteVerticalOffset.get()).floatValue();
            EmoteRenderer.emoteScale = ((Double)emoteScale.get()).floatValue();
            ClientEmotePacksManager.MAX_PACK_SIZE_BYTES = (Integer)maxPackSizeMB.get() * 1024 * 1024;
            ClientEmotePacksManager.MAX_PACK_EMOTE_AMOUNT = (Integer)maxEmoteAmount.get();
        }
    }

    static {
        BUILDER.comment("Pop-up Emotes Client ClientConfig");
        BUILDER.comment("Render").push("visual");
        brightEmotes = BUILDER.define("brightEmotes", true);
        emoteScale = BUILDER.defineInRange("emoteScale", 1.0, 0.5, 1.5);
        emoteVerticalOffset = BUILDER.defineInRange("emoteVerticalOffset", 0.0, -1.0, 1.0);
        BUILDER.pop();
        BUILDER.comment("System").push("system_v2");
        BUILDER.comment("The maximum local pack emotes amount. For server side value see your world's 'serverconfig' folder");
        maxEmoteAmount = BUILDER.defineInRange("maxEmoteAmount", 40, 8, 128);
        BUILDER.comment("This only sets client side local pack limit. For server side value see your world's 'serverconfig' folder.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 16, 1, 64);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

