/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pop_up_emotes", value={Dist.CLIENT})
public class EmotePieOverlay {
    private static final int SLICE_COUNT = 8;
    private static final float RADIUS = 100.0f;
    private static final ResourceLocation SLICE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/pie_slice.png");
    private static final ResourceLocation ARROW_LEFT = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/arrow_left.png");
    private static final ResourceLocation ARROW_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/arrow_right.png");
    public static final int ARROW_WIDTH = 32;
    public static final int ARROW_HEIGHT = 32;
    private static final Map<Integer, DynamicTexture> dynamicEmoteTextures = new HashMap<Integer, DynamicTexture>();
    private static final Map<Integer, ResourceLocation> dynamicEmoteResourceLocations = new HashMap<Integer, ResourceLocation>();
    private static int selectedSlice = -1;
    private static boolean active = false;
    private static int currentPageIndex = 0;

    public static boolean isActive() {
        return active;
    }

    public static int selectedEmoteId() {
        if (selectedSlice < 0) {
            return -1;
        }
        int selectedEmoteId = selectedSlice + 8 * currentPageIndex;
        if (selectedEmoteId >= ClientEmotePacksManager.localEmotesAmount()) {
            return -1;
        }
        return selectedEmoteId;
    }

    public static void activate() {
        if (!active) {
            if (dynamicEmoteTextures.isEmpty()) {
                EmotePieOverlay.loadDynamicTextures();
            }
            active = true;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91067_.m_91602_();
    }

    public static void deactivate() {
        if (active) {
            selectedSlice = -1;
            active = false;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91067_.m_91601_();
    }

    public static void reloadDynamicTextures() {
        EmotePieOverlay.closeAndClearTextures();
        EmotePieOverlay.loadDynamicTextures();
    }

    private static void closeAndClearTextures() {
        dynamicEmoteTextures.values().forEach(DynamicTexture::close);
        dynamicEmoteTextures.clear();
        dynamicEmoteResourceLocations.clear();
    }

    private static void loadDynamicTextures() {
        Map<Integer, byte[]> localEmotes = ClientEmotePacksManager.getLocalEmotePack();
        if (localEmotes == null || localEmotes.isEmpty()) {
            return;
        }
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        int localPackAmount = localEmotes.size();
        for (int i = 0; i < (Integer)ClientConfig.maxEmoteAmount.get() && i < localPackAmount; ++i) {
            byte[] imageBytes = localEmotes.get(i);
            if (imageBytes == null) continue;
            try {
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));
                DynamicTexture texture = new DynamicTexture(nativeImage);
                dynamicEmoteTextures.put(i, texture);
                ResourceLocation location = textureManager.m_118490_("emote_dynamic_" + i, texture);
                dynamicEmoteResourceLocations.put(i, location);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        float scale;
        int i;
        if (!active) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        EmotePieOverlay.drawPageNavArrowButtons(height, guiGraphics, width);
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f;
        guiGraphics.m_280168_().m_85836_();
        float sliceAngle = 45.0f;
        for (i = 0; i < 8; ++i) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(centerX, centerY, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)i * sliceAngle));
            guiGraphics.m_280168_().m_252880_(50.0f, 0.0f, 0.0f);
            scale = i == selectedSlice ? 1.0f : 0.8f;
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(-i) * sliceAngle));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SLICE_TEXTURE);
            guiGraphics.m_280163_(SLICE_TEXTURE, -32, -32, 0.0f, 0.0f, 64, 64, 64, 64);
            guiGraphics.m_280168_().m_85849_();
        }
        for (i = 0; i < 8; ++i) {
            ResourceLocation emoteTexture;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(centerX, centerY, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)i * sliceAngle));
            guiGraphics.m_280168_().m_252880_(50.0f, 0.0f, 5.0f);
            scale = i == selectedSlice ? 1.2f : 1.0f;
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(-i) * sliceAngle));
            int textureIndex = i + currentPageIndex * 8;
            ResourceLocation textureLocation = dynamicEmoteResourceLocations.get(textureIndex);
            if (textureLocation != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
                guiGraphics.m_280163_(textureLocation, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            } else if (textureIndex < ClientEmotePacksManager.DEFAULT_EMOTE_PACK.length && (emoteTexture = ClientEmotePacksManager.DEFAULT_EMOTE_PACK[textureIndex]) != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)emoteTexture);
                guiGraphics.m_280163_(emoteTexture, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            }
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85849_();
        Minecraft mc = Minecraft.m_91087_();
        double mouseX = mc.f_91067_.m_91589_() * (double)width / (double)mc.m_91268_().m_85443_();
        double mouseY = mc.f_91067_.m_91594_() * (double)height / (double)mc.m_91268_().m_85444_();
        EmotePieOverlay.updateSelection((float)mouseX, (float)mouseY, width, height);
    }

    private static void drawPageNavArrowButtons(int height, GuiGraphics guiGraphics, int width) {
        if (EmotePieOverlay.maxPage() <= 1) {
            return;
        }
        int arrowY = height / 2 - 16;
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_LEFT);
        guiGraphics.m_280163_(ARROW_LEFT, 48, arrowY, 0.0f, 0.0f, 32, 32, 32, 32);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_RIGHT);
        guiGraphics.m_280163_(ARROW_RIGHT, width - 32 - 48, arrowY, 0.0f, 0.0f, 32, 32, 32, 32);
        guiGraphics.m_280168_().m_85849_();
    }

    @SubscribeEvent
    public static void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (EmotePieOverlay.isActive()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(InputEvent.MouseButton.Pre event) {
        if (!active) {
            return;
        }
        if (event.getAction() != 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        double mouseX = mc.f_91067_.m_91589_() * (double)width / (double)mc.m_91268_().m_85443_();
        if (mouseX < (double)width / 2.0) {
            if (--currentPageIndex < 0) {
                currentPageIndex = EmotePieOverlay.maxPage() - 1;
            }
            event.setCanceled(true);
        }
        if (mouseX > (double)width / 2.0) {
            int maxPage = EmotePieOverlay.maxPage();
            if (++currentPageIndex >= maxPage) {
                currentPageIndex = 0;
            }
            event.setCanceled(true);
        }
    }

    private static int maxPage() {
        int min = ClientEmotePacksManager.DEFAULT_EMOTE_PACK.length;
        return (Math.max(min, dynamicEmoteTextures.size()) + 8 - 1) / 8;
    }

    private static void updateSelection(float mouseX, float mouseY, int screenWidth, int screenHeight) {
        float centerX = (float)screenWidth / 2.0f;
        float dx = mouseX - centerX;
        float centerY = (float)screenHeight / 2.0f;
        float dy = mouseY - centerY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 100.0 || distance < 20.0) {
            selectedSlice = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(dy, dx)) + 22.5;
        if (angle < 0.0) {
            angle += 360.0;
        }
        double sliceAngle = 45.0;
        selectedSlice = (int)(angle / sliceAngle);
    }
}

