/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.gui.EmotePieOverlay;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ForgeSlider;

@OnlyIn(value=Dist.CLIENT)
public class PopUpEmotesConfigScreen
extends Screen {
    private ResourceLocation[] emoteTextures = new ResourceLocation[8];
    private float reloadTimeout = -1000.0f;
    private boolean packTooLargeWarn = false;
    private Button reloadButton = null;
    private ForgeSlider emoteScaleSlider;
    private ForgeSlider emoteVerticalOffsetSlider;
    private Checkbox brightEmotesCheckbox;

    public PopUpEmotesConfigScreen() {
        super((Component)Component.m_237115_((String)"pop_up_emotes.configuration.title"));
    }

    private void loadCustomEmoteTextures() {
        Map<Integer, byte[]> emotePack = ClientEmotePacksManager.getLocalEmotePack();
        if (emotePack == null) {
            emotePack = new HashMap<Integer, byte[]>();
        }
        Minecraft mc = Minecraft.m_91087_();
        for (int i = 0; i < this.emoteTextures.length; ++i) {
            byte[] bytes = emotePack.get(i);
            if (bytes != null) {
                try {
                    ResourceLocation location;
                    NativeImage img = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(bytes));
                    DynamicTexture texture = new DynamicTexture(img);
                    this.emoteTextures[i] = location = mc.m_91097_().m_118490_("emote_" + i, texture);
                }
                catch (Exception e) {
                    this.emoteTextures[i] = null;
                    e.printStackTrace();
                }
                continue;
            }
            this.emoteTextures[i] = null;
        }
    }

    private void onConfirm() {
        boolean brightEmotes = this.brightEmotesCheckbox.m_93840_();
        ClientConfig.brightEmotes.set((Object)brightEmotes);
        EmoteRenderer.brightEmotes = brightEmotes;
        double scale = this.emoteScaleSlider.getValue();
        ClientConfig.emoteScale.set((Object)scale);
        EmoteRenderer.emoteScale = (float)scale;
        double verticalOffset = this.emoteVerticalOffsetSlider.getValue();
        ClientConfig.emoteVerticalOffset.set((Object)verticalOffset);
        EmoteRenderer.emoteVerticalOffset = (float)verticalOffset;
        ClientConfig.SPEC.save();
    }

    private void onReset() {
        EmoteRenderer.brightEmotes = false;
        EmoteRenderer.emoteScale = 1.0f;
        EmoteRenderer.emoteVerticalOffset = 0.0f;
        ClientConfig.brightEmotes.set((Object)false);
        ClientConfig.emoteScale.set((Object)1.0);
        ClientConfig.emoteVerticalOffset.set((Object)0.0);
        ClientConfig.SPEC.save();
    }

    protected void m_7856_() {
        boolean inGame = this.f_96541_ != null && this.f_96541_.f_91073_ != null;
        this.brightEmotesCheckbox = new Checkbox(this.f_96543_ / 2 + 110, this.f_96544_ / 2 - 60, 100, 20, (Component)Component.m_237115_((String)"pop_up_emotes.config.bright_emotes"), ((Boolean)ClientConfig.brightEmotes.get()).booleanValue());
        this.m_142416_((GuiEventListener)this.brightEmotesCheckbox);
        this.reloadButton = Button.m_253074_((Component)Component.m_237115_((String)"pop_up_emotes.config.reload"), button -> {
            ClientEmotePacksManager.recreateCache();
            this.loadCustomEmoteTextures();
            EmotePieOverlay.reloadDynamicTextures();
            button.f_93623_ = false;
            this.reloadTimeout = 20.0f;
            this.packTooLargeWarn = ClientEmotePacksManager.lastLoadEncounterOversize;
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 2, 200, 20).m_253136_();
        this.reloadButton.f_93623_ = !inGame;
        this.m_142416_((GuiEventListener)this.reloadButton);
        Button openFolderButton = Button.m_253074_((Component)Component.m_237115_((String)"pop_up_emotes.config.open_emotes_folder"), button -> {
            try {
                File folder = ClientEmotePacksManager.getEmotePackFolder().toFile();
                folder.mkdirs();
                if (folder.exists()) {
                    if (Desktop.isDesktopSupported() && !GraphicsEnvironment.isHeadless()) {
                        Desktop.getDesktop().open(folder);
                    } else {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("explorer " + folder.getAbsolutePath());
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec(new String[]{"open", folder.getAbsolutePath()});
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec(new String[]{"xdg-open", folder.getAbsolutePath()});
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 24, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)openFolderButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"pop_up_emotes.config.save"), button -> {
            this.onConfirm();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 50, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 74, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"pop_up_emotes.config.reset"), button -> {
            this.onReset();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 + 110, this.f_96544_ / 2 + 74, 75, 20).m_253136_());
        if (!inGame) {
            this.loadCustomEmoteTextures();
            this.packTooLargeWarn = ClientEmotePacksManager.lastLoadEncounterOversize;
        }
        this.emoteScaleSlider = new ForgeSlider(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 60, 200, 20, (Component)Component.m_237115_((String)"pop_up_emotes.config.emote_scale_pref"), (Component)Component.m_237115_((String)"pop_up_emotes.config.emote_scale_suf"), 0.5, 1.5, ((Double)ClientConfig.emoteScale.get()).doubleValue(), 0.05, 2, true);
        this.m_142416_((GuiEventListener)this.emoteScaleSlider);
        this.emoteVerticalOffsetSlider = new ForgeSlider(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 30, 200, 20, (Component)Component.m_237115_((String)"pop_up_emotes.config.emote_vertical_pref"), (Component)Component.m_237115_((String)"pop_up_emotes.config.emote_vertical_suf"), -1.0, 1.0, ((Double)ClientConfig.emoteVerticalOffset.get()).doubleValue(), 0.05, 2, true);
        this.m_142416_((GuiEventListener)this.emoteVerticalOffsetSlider);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
        if (this.reloadTimeout > -1000.0f) {
            this.reloadTimeout -= partialTicks;
            if (this.reloadTimeout <= 0.0f) {
                this.reloadButton.f_93623_ = true;
                this.reloadTimeout = -1000.0f;
            }
        }
        int xStart = this.f_96543_ / 2 - 88;
        int yStart = 25;
        int size = 22;
        Minecraft mc = Minecraft.m_91087_();
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            String message = Component.m_237115_((String)"pop_up_emotes.config.reload_disabled").getString();
            int msgX = this.f_96543_ / 2 - this.f_96547_.m_92895_(message) / 2;
            int n = yStart + size / 2;
            Objects.requireNonNull(this.f_96547_);
            int msgY = n - 9 / 2;
            graphics.m_280056_(this.f_96547_, message, msgX, msgY, -43691, false);
        } else if (this.packTooLargeWarn) {
            String message = Component.m_237115_((String)"pop_up_emotes.config.reload_pack_too_large").getString() + ClientEmotePacksManager.MAX_PACK_SIZE_BYTES / 1024 / 1024 + "Mb.";
            int msgX = this.f_96543_ / 2 - this.f_96547_.m_92895_(message) / 2;
            int n = yStart + size / 2;
            Objects.requireNonNull(this.f_96547_);
            int msgY = n - 9 / 2;
            graphics.m_280056_(this.f_96547_, message, msgX, msgY, -43691, false);
        } else {
            boolean anyEmotes = false;
            for (int i = 0; i < this.emoteTextures.length; ++i) {
                ResourceLocation tex = this.emoteTextures[i];
                if (tex == null) continue;
                anyEmotes = true;
                mc.m_91097_().m_174784_(tex);
                graphics.m_280163_(tex, xStart + i * (size + 2), yStart, 0.0f, 0.0f, size, size, size, size);
            }
            if (!anyEmotes) {
                String noEmotesMsg = Component.m_237115_((String)"pop_up_emotes.config.no_emotes_found").getString();
                int msgX = this.f_96543_ / 2 - this.f_96547_.m_92895_(noEmotesMsg) / 2;
                int n = yStart + size / 2;
                Objects.requireNonNull(this.f_96547_);
                int msgY = n - 9 / 2;
                graphics.m_280056_(this.f_96547_, noEmotesMsg, msgX, msgY, 0xFFFFFF, false);
            }
        }
    }

    private void drawTitle(GuiGraphics graphics) {
        int x = (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int y = 10;
        graphics.m_280614_(this.f_96547_, this.f_96539_, x, y, 0xFFFFFF, false);
    }
}

