/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class EmoteToServerPacket {
    private final int emoteId;
    private final UUID senderUUID;

    public EmoteToServerPacket(int emoteId, UUID senderUUID) {
        this.emoteId = emoteId;
        this.senderUUID = senderUUID;
    }

    public EmoteToServerPacket(FriendlyByteBuf buf) {
        this.emoteId = buf.readInt();
        this.senderUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.emoteId);
        buf.m_130077_(this.senderUUID);
    }

    public static void handle(EmoteToServerPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isServer()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            EmoteToClientPacket broadcastPacket = new EmoteToClientPacket(msg.emoteId, msg.senderUUID);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)broadcastPacket);
        });
        context.setPacketHandled(true);
    }
}

