/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPacket;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPacket;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class PlayerJoinHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Map<UUID, Map<Integer, byte[]>> allEmotePacks = ServerEmotePacksManager.getAllPlayerEmotePacks();
        for (Map.Entry<UUID, Map<Integer, byte[]>> entry : allEmotePacks.entrySet()) {
            UUID playerUUID = entry.getKey();
            Map<Integer, byte[]> emotes = entry.getValue();
            PlayerJoinHandler.sendEmotePackChunksToPlayer(player2, playerUUID, emotes);
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new RequestEmotePackToClientPacket());
    }

    private static void sendEmotePackChunksToPlayer(ServerPlayer recipient, UUID emoteOwnerUUID, Map<Integer, byte[]> emotes) {
        int CHUNK_SIZE = 32000;
        for (Map.Entry<Integer, byte[]> emoteEntry : emotes.entrySet()) {
            int emoteId = emoteEntry.getKey();
            byte[] fullData = emoteEntry.getValue();
            int totalChunks = (fullData.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(fullData.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(fullData, start, end);
                EmotePackChunkToClientPacket packet = new EmotePackChunkToClientPacket(emoteOwnerUUID, emoteId, chunkIndex, totalChunks, chunk);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> recipient), (Object)packet);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerExit(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        ServerEmotePacksManager.removePlayerEmotePack(playerUUID);
        EmotePackChunkToServerPacket.playerBuffers.remove(playerUUID);
    }
}

