/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.NametagRenderHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="pop_up_emotes", value={Dist.CLIENT})
public class EmoteRenderer {
    private static final int TICKS_FADE_IN = 5;
    private static final int TICKS_STATIC = 40;
    private static final int TICKS_FADE_OUT = 5;
    private static final int TOTAL_TICKS = 50;
    private static final float BASE_SIZE = 0.65f;
    public static float emoteVerticalOffset = 0.0f;
    public static float emoteScale = 1.0f;
    public static boolean brightEmotes = false;
    private static final Map<UUID, EmoteData> activeEmotes = new HashMap<UUID, EmoteData>();
    private static final Map<UUID, ResourceLocation> emoteTextureLocations = new HashMap<UUID, ResourceLocation>();

    public static void showEmoteOnPlayer(UUID playerUUID, int emoteId) {
        NativeImage nativeImage;
        byte[] imageData;
        UUID localUUID = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_20148_() : null;
        Map<Integer, byte[]> emotes = localUUID != null && localUUID.equals(playerUUID) ? ClientEmotePacksManager.getLocalEmotePack() : ClientEmotePacksManager.getPlayerEmotePack(playerUUID);
        if (emotes == null) {
            emotes = new HashMap<Integer, byte[]>();
        }
        if ((imageData = emotes.get(emoteId)) == null || imageData.length == 0) {
            Map<Integer, byte[]> defaultEmotes = ClientEmotePacksManager.loadDefaultEmotesAsBytes();
            if (defaultEmotes.containsKey(emoteId)) {
                imageData = defaultEmotes.get(emoteId);
            } else {
                return;
            }
        }
        try {
            nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        EmoteData previous = activeEmotes.put(playerUUID, new EmoteData(emoteId, dynamicTexture));
        if (previous != null) {
            previous.close();
        }
        ResourceLocation textureLocation = Minecraft.m_91087_().m_91097_().m_118490_("emote_" + playerUUID, dynamicTexture);
        emoteTextureLocations.put(playerUUID, textureLocation);
        NametagRenderHandler.hideNametagForPlayer(playerUUID);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<UUID, EmoteData>> iterator = activeEmotes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, EmoteData> entry = iterator.next();
                EmoteData emoteData = entry.getValue();
                ++emoteData.ageTicks;
                if (emoteData.ageTicks < 50) continue;
                emoteData.close();
                UUID playerUUID = entry.getKey();
                iterator.remove();
                emoteTextureLocations.remove(playerUUID);
                NametagRenderHandler.showNametagForPlayer(entry.getKey());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = event.getPoseStack();
        Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
        for (UUID playerUUID : activeEmotes.keySet()) {
            float scale;
            float alpha;
            Player entity;
            EmoteData emoteData = activeEmotes.get(playerUUID);
            ResourceLocation emoteResource = emoteTextureLocations.get(playerUUID);
            if (emoteResource == null || !((entity = mc.f_91073_.m_46003_(playerUUID)) instanceof Player)) continue;
            Player player = entity;
            LocalPlayer localPlayer = mc.f_91074_;
            if (localPlayer != null && player.m_20148_().equals(localPlayer.m_20148_()) && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) continue;
            if (emoteData.ageTicks < 5) {
                alpha = progress = (float)emoteData.ageTicks / 5.0f;
                scale = emoteScale + (float)Math.sin((double)progress * Math.PI * 4.0) * 0.3f;
            } else if (emoteData.ageTicks < 45) {
                alpha = 1.0f;
                scale = emoteScale;
            } else {
                if (emoteData.ageTicks >= 50) continue;
                progress = (float)(emoteData.ageTicks - 5 - 40) / 5.0f;
                alpha = 1.0f - progress;
                scale = emoteScale - progress;
            }
            poseStack.m_85836_();
            float partialTicks = event.getPartialTick();
            double x = Mth.m_14139_((double)partialTicks, (double)player.f_19790_, (double)player.m_20185_()) - camPos.m_7096_();
            double y = Mth.m_14139_((double)partialTicks, (double)player.f_19791_, (double)player.m_20186_()) - camPos.m_7098_();
            double z = Mth.m_14139_((double)partialTicks, (double)player.f_19792_, (double)player.m_20189_()) - camPos.m_7094_();
            Vector3f camLookVecFloat = mc.f_91063_.m_109153_().m_253058_();
            Vec3 camLookVec = new Vec3((double)camLookVecFloat.x(), (double)camLookVecFloat.y(), (double)camLookVecFloat.z());
            double offsetTowardsCamera = 0.02;
            Vec3 offsetVec = camLookVec.m_82490_(offsetTowardsCamera);
            poseStack.m_85837_(x - offsetVec.f_82479_, y + (double)player.m_20206_() + 0.5 + (double)emoteVerticalOffset, z - offsetVec.f_82481_);
            Quaternionf cameraRotation = mc.m_91290_().f_114358_.m_253121_();
            poseStack.m_252781_(cameraRotation);
            poseStack.m_85841_(-scale, scale, scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            mc.m_91097_().m_174784_(emoteResource);
            VertexConsumer vertexBuilder = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)emoteResource));
            float halfSize = 0.325f;
            int packedLight = brightEmotes ? 0xF000F0 : LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)player.m_20183_());
            vertexBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, -halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            vertexBuilder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, halfSize, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            mc.m_91269_().m_110104_().m_109912_(RenderType.m_110473_((ResourceLocation)emoteResource));
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }

    private static class EmoteData
    implements AutoCloseable {
        final int emoteId;
        final DynamicTexture texture;
        int ageTicks = 0;

        EmoteData(int emoteId, DynamicTexture texture) {
            this.emoteId = emoteId;
            this.texture = texture;
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

