/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network;

import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.ModSounds;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPacket;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPacket;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPacket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static void handle(RequestEmotePackToClientPacket _packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            UUID playerUUID = player.m_20148_();
            Map<Integer, byte[]> emotes = ClientEmotePacksManager.getLocalEmotePack();
            if (emotes == null) {
                emotes = new HashMap<Integer, byte[]>();
            }
            int CHUNK_SIZE = 32000;
            for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
                int emoteId = entry.getKey();
                byte[] data = entry.getValue();
                int totalChunks = (data.length + 32000 - 1) / 32000;
                for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                    int start = chunkIndex * 32000;
                    int end = Math.min(data.length, start + 32000);
                    byte[] chunk = Arrays.copyOfRange(data, start, end);
                    EmotePackChunkToServerPacket packet = new EmotePackChunkToServerPacket(playerUUID, emoteId, chunkIndex, totalChunks, chunk);
                    NetworkHandler.INSTANCE.sendToServer((Object)packet);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static void handle(EmoteToClientPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Player player = mc.f_91073_.m_46003_(msg.senderUUID);
            if (player != null) {
                EmoteRenderer.showEmoteOnPlayer(player.m_20148_(), msg.emoteId);
                mc.f_91073_.m_7785_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), (SoundEvent)ModSounds.EMOTE_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        context.setPacketHandled(true);
    }
}

