/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class EmotePackChunkToServerPacket {
    private UUID senderUUID;
    private int emoteId;
    private int chunkIndex;
    private int totalChunks;
    private byte[] chunkData;
    public static final Map<UUID, Map<Integer, ChunkBuffer>> playerBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();

    public EmotePackChunkToServerPacket(UUID senderUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        this.senderUUID = senderUUID;
        this.emoteId = emoteId;
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.chunkData = chunkData;
    }

    public EmotePackChunkToServerPacket(FriendlyByteBuf buf) {
        this.senderUUID = buf.m_130259_();
        this.emoteId = buf.readInt();
        this.chunkIndex = buf.readInt();
        this.totalChunks = buf.readInt();
        this.chunkData = buf.m_130052_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.senderUUID);
        buf.writeInt(this.emoteId);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130087_(this.chunkData);
    }

    public static void handle(EmotePackChunkToServerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            UUID sender = packet.senderUUID;
            int emoteId = packet.emoteId;
            playerBuffers.putIfAbsent(sender, new ConcurrentHashMap());
            Map<Integer, ChunkBuffer> emoteMap = playerBuffers.get(sender);
            emoteMap.putIfAbsent(emoteId, new ChunkBuffer(packet.totalChunks));
            ChunkBuffer buffer = emoteMap.get(emoteId);
            boolean added = buffer.addChunk(packet.chunkIndex, packet.chunkData);
            if (!added) {
                DebugLogger.debug("[EmotePackChunkToServerPacket.handle] !added == true Duplicate or out of bound chunk");
                return;
            }
            if (buffer.isComplete()) {
                byte[] fullEmoteData = buffer.assemble();
                ServerEmotePacksManager.setPlayerEmote(sender, emoteId, fullEmoteData);
                DebugLogger.debug("Emote data " + emoteId + "from player " + sender + " received.");
                EmotePackChunkToServerPacket.sendEmotePackChunksToClients(sender, Map.of(emoteId, fullEmoteData));
                emoteMap.remove(emoteId);
                if (emoteMap.isEmpty()) {
                    playerBuffers.remove(sender);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static void sendEmotePackChunksToClients(UUID senderUUID, Map<Integer, byte[]> emotes) {
        int CHUNK_SIZE = 32000;
        for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
            int emoteId = entry.getKey();
            byte[] data = entry.getValue();
            int totalChunks = (data.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(data.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(data, start, end);
                EmotePackChunkToClientPacket packet = new EmotePackChunkToClientPacket(senderUUID, emoteId, chunkIndex, totalChunks, chunk);
                NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        }
    }

    private static class ChunkBuffer {
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        public ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
                return true;
            }
            return false;
        }

        public boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        public byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

