/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.stc;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class EmotePackChunkToClientPacket {
    private final UUID senderUUID;
    private final int emoteId;
    private final int chunkIndex;
    private final int totalChunks;
    private final byte[] chunkData;

    public EmotePackChunkToClientPacket(UUID senderUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        this.senderUUID = senderUUID;
        this.emoteId = emoteId;
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.chunkData = chunkData;
    }

    public EmotePackChunkToClientPacket(FriendlyByteBuf buf) {
        this.senderUUID = buf.m_130259_();
        this.emoteId = buf.readInt();
        this.chunkIndex = buf.readInt();
        this.totalChunks = buf.readInt();
        this.chunkData = buf.m_130052_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.senderUUID);
        buf.writeInt(this.emoteId);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130087_(this.chunkData);
    }

    public static void handle(EmotePackChunkToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            UUID senderUUID = packet.senderUUID;
            int emoteId = packet.emoteId;
            int chunkIndex = packet.chunkIndex;
            int totalChunks = packet.totalChunks;
            byte[] chunkData = packet.chunkData;
            ClientEmotePacksManager.addChunk(senderUUID, emoteId, chunkIndex, totalChunks, chunkData);
            if (ClientEmotePacksManager.isEmoteComplete(senderUUID, emoteId)) {
                byte[] fullEmote = ClientEmotePacksManager.assembleEmote(senderUUID, emoteId);
                ClientEmotePacksManager.cachePlayerEmote(senderUUID, emoteId, fullEmote);
                DebugLogger.debug("Emote data " + emoteId + "from player " + senderUUID + " received.");
            }
        });
        context.setPacketHandled(true);
    }
}

