/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ServerEmotePacksManager {
    private static final Map<UUID, Map<Integer, byte[]>> playerEmotePacks = new ConcurrentHashMap<UUID, Map<Integer, byte[]>>();

    public static void setPlayerEmotePack(UUID playerUUID, Map<Integer, byte[]> emotes) {
        playerEmotePacks.put(playerUUID, emotes);
    }

    public static void setPlayerEmote(UUID playerUUID, int emoteId, byte[] emoteData) {
        playerEmotePacks.compute(playerUUID, (uuid, emoteMap) -> {
            if (emoteMap == null) {
                emoteMap = new ConcurrentHashMap<Integer, byte[]>();
            }
            emoteMap.put(emoteId, emoteData);
            return emoteMap;
        });
    }

    public static Map<Integer, byte[]> getPlayerEmotePack(UUID playerUUID) {
        return playerEmotePacks.getOrDefault(playerUUID, Map.of());
    }

    public static void removePlayerEmotePack(UUID playerUUID) {
        playerEmotePacks.remove(playerUUID);
    }

    public static Map<UUID, Map<Integer, byte[]>> getAllPlayerEmotePacks() {
        return playerEmotePacks;
    }
}

