/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="pop_up_emotes")
public class ClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec SPEC;
    public static final String CUSTOM_PACK_FOLDER_NAME = "pop_emote_pack";
    public static ModConfigSpec.BooleanValue brightEmotes;
    public static ModConfigSpec.DoubleValue emoteVerticalOffset;
    public static ModConfigSpec.DoubleValue emoteScale;
    public static ModConfigSpec.IntValue maxPackSizeMB;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            EmoteRenderer.emoteVerticalOffset = ((Double)emoteVerticalOffset.get()).floatValue();
            EmoteRenderer.emoteScale = ((Double)emoteScale.get()).floatValue();
            ClientEmotePacksManager.MAX_PACK_SIZE_BYTES = (Integer)maxPackSizeMB.get() * 1024 * 1024;
        }
    }

    static {
        BUILDER.comment("Pop-up Emotes Client Config");
        BUILDER.comment("Render").push("visual");
        brightEmotes = BUILDER.define("brightEmotes", true);
        emoteScale = BUILDER.defineInRange("emoteScale", 1.0, 0.5, 1.5);
        emoteVerticalOffset = BUILDER.defineInRange("emoteVerticalOffset", 0.0, -1.0, 1.0);
        BUILDER.pop();
        BUILDER.comment("System").push("system");
        BUILDER.comment("This only sets client side local pack limit.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 10, 1, 64);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

