/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

@EventBusSubscriber(modid="pop_up_emotes", value={Dist.CLIENT})
public class EmotePieOverlay {
    private static final int SLICE_COUNT = 8;
    private static final float RADIUS = 100.0f;
    private static final ResourceLocation SLICE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/pie_slice.png");
    private static final Map<Integer, DynamicTexture> dynamicEmoteTextures = new HashMap<Integer, DynamicTexture>();
    private static final Map<Integer, ResourceLocation> dynamicEmoteResourceLocations = new HashMap<Integer, ResourceLocation>();
    public static int selectedSlice = -1;
    private static boolean active = false;

    public static boolean isActive() {
        return active;
    }

    public static void activate() {
        if (!active) {
            if (dynamicEmoteTextures.isEmpty()) {
                EmotePieOverlay.loadDynamicTextures();
            }
            active = true;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHandler.releaseMouse();
    }

    public static void deactivate() {
        if (active) {
            selectedSlice = -1;
            active = false;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHandler.grabMouse();
    }

    public static void reloadDynamicTextures() {
        EmotePieOverlay.closeAndClearTextures();
        EmotePieOverlay.loadDynamicTextures();
    }

    private static void closeAndClearTextures() {
        dynamicEmoteTextures.values().forEach(DynamicTexture::close);
        dynamicEmoteTextures.clear();
        dynamicEmoteResourceLocations.clear();
    }

    private static void loadDynamicTextures() {
        Map<Integer, byte[]> localEmotes = ClientEmotePacksManager.getLocalEmotePack();
        if (localEmotes == null || localEmotes.isEmpty()) {
            return;
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        for (int i = 0; i < 8; ++i) {
            byte[] imageBytes = localEmotes.get(i);
            if (imageBytes == null) continue;
            try {
                NativeImage nativeImage = NativeImage.read((InputStream)new ByteArrayInputStream(imageBytes));
                DynamicTexture texture = new DynamicTexture(nativeImage);
                dynamicEmoteTextures.put(i, texture);
                ResourceLocation location = textureManager.register("emote_dynamic_" + i, texture);
                dynamicEmoteResourceLocations.put(i, location);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        float scale;
        int i;
        if (!active) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int width = event.getGuiGraphics().guiWidth();
        int height = event.getGuiGraphics().guiHeight();
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f;
        guiGraphics.pose().pushPose();
        float sliceAngle = 45.0f;
        for (i = 0; i < 8; ++i) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(centerX, centerY, 0.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)i * sliceAngle));
            guiGraphics.pose().translate(50.0f, 0.0f, 0.0f);
            scale = i == selectedSlice ? 1.0f : 0.8f;
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-i) * sliceAngle));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SLICE_TEXTURE);
            guiGraphics.blit(SLICE_TEXTURE, -32, -32, 0.0f, 0.0f, 64, 64, 64, 64);
            guiGraphics.pose().popPose();
        }
        for (i = 0; i < 8; ++i) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(centerX, centerY, 0.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)i * sliceAngle));
            guiGraphics.pose().translate(50.0f, 0.0f, 5.0f);
            scale = i == selectedSlice ? 1.2f : 1.0f;
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-i) * sliceAngle));
            ResourceLocation textureLocation = dynamicEmoteResourceLocations.get(i);
            if (textureLocation != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
                guiGraphics.blit(textureLocation, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            } else if (i < ClientEmotePacksManager.EMOTE_TEXTURES.length) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientEmotePacksManager.EMOTE_TEXTURES[i]);
                guiGraphics.blit(ClientEmotePacksManager.EMOTE_TEXTURES[i], -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            }
            guiGraphics.pose().popPose();
        }
        guiGraphics.pose().popPose();
        Minecraft mc = Minecraft.getInstance();
        double mouseX = mc.mouseHandler.xpos() * (double)width / (double)mc.getWindow().getScreenWidth();
        double mouseY = mc.mouseHandler.ypos() * (double)height / (double)mc.getWindow().getScreenHeight();
        EmotePieOverlay.updateSelection((float)mouseX, (float)mouseY, width, height);
    }

    private static void updateSelection(float mouseX, float mouseY, int screenWidth, int screenHeight) {
        float centerX = (float)screenWidth / 2.0f;
        float dx = mouseX - centerX;
        float centerY = (float)screenHeight / 2.0f;
        float dy = mouseY - centerY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 100.0 || distance < 20.0) {
            selectedSlice = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(dy, dx)) + 22.5;
        if (angle < 0.0) {
            angle += 360.0;
        }
        double sliceAngle = 45.0;
        selectedSlice = (int)(angle / sliceAngle);
    }
}

