/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network;

import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.ModSounds;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPayload;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPayload;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPayload;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleOnNetwork(RequestEmotePackToClientPayload _payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            UUID playerUUID = player.getUUID();
            Map<Integer, byte[]> emotes = ClientEmotePacksManager.getLocalEmotePack();
            if (emotes == null) {
                emotes = new HashMap<Integer, byte[]>();
            }
            int CHUNK_SIZE = 32000;
            for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
                int emoteId = entry.getKey();
                byte[] data = entry.getValue();
                int totalChunks = (data.length + 32000 - 1) / 32000;
                for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                    int start = chunkIndex * 32000;
                    int end = Math.min(data.length, start + 32000);
                    byte[] chunk = Arrays.copyOfRange(data, start, end);
                    EmotePackChunkToServerPayload packet = new EmotePackChunkToServerPayload(playerUUID, emoteId, chunkIndex, totalChunks, chunk);
                    PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    public static void handleOnNetwork(EmoteToClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            Player player = mc.level.getPlayerByUUID(payload.senderUUID());
            if (player != null) {
                EmoteRenderer.showEmoteOnPlayer(player.getUUID(), payload.emoteId());
                mc.level.playLocalSound(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), (SoundEvent)ModSounds.EMOTE_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"pop_up_emotes.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

