/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network;

import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPayload;
import io.github.catomon.popupemotes.network.cts.EmoteToServerPayload;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPayload;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPayload;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION).executesOn(HandlerThread.NETWORK);
        registrar.playToClient(EmoteToClientPayload.TYPE, EmoteToClientPayload.STREAM_CODEC, EmoteToClientPayload::handleOnNetwork);
        registrar.playToClient(RequestEmotePackToClientPayload.TYPE, RequestEmotePackToClientPayload.STREAM_CODEC, RequestEmotePackToClientPayload::handleOnNetwork);
        registrar.playToClient(EmotePackChunkToClientPayload.TYPE, EmotePackChunkToClientPayload.STREAM_CODEC, EmotePackChunkToClientPayload::handleOnNetwork);
        registrar.playToServer(EmoteToServerPayload.TYPE, EmoteToServerPayload.STREAM_CODEC, EmoteToServerPayload::handleOnNetwork);
        registrar.playToServer(EmotePackChunkToServerPayload.TYPE, EmotePackChunkToServerPayload.STREAM_CODEC, EmotePackChunkToServerPayload::handleOnNetwork);
    }
}

