/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPayload;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EmotePackChunkToServerPayload(UUID senderUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EmotePackChunkToServerPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"popupemotes", (String)"emote_pack_chunk_to_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EmotePackChunkToServerPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EmotePackChunkToServerPayload::senderUUID, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::emoteId, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::chunkIndex, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::totalChunks, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, EmotePackChunkToServerPayload::chunkData, EmotePackChunkToServerPayload::new);
    public static final Map<UUID, Map<Integer, ChunkBuffer>> playerBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnNetwork(EmotePackChunkToServerPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            UUID sender = payload.senderUUID();
            int emoteId = payload.emoteId();
            playerBuffers.putIfAbsent(sender, new ConcurrentHashMap());
            Map<Integer, ChunkBuffer> emoteMap = playerBuffers.get(sender);
            emoteMap.putIfAbsent(emoteId, new ChunkBuffer(payload.totalChunks()));
            ChunkBuffer buffer = emoteMap.get(emoteId);
            boolean added = buffer.addChunk(payload.chunkIndex(), payload.chunkData());
            if (!added) {
                DebugLogger.debug("[EmotePackChunkToServerPayload.handleOnNetwork] Duplicate or out of bound chunk for emote " + emoteId);
                return;
            }
            if (buffer.isComplete()) {
                byte[] fullEmoteData = buffer.assemble();
                DebugLogger.debug("Emote data " + emoteId + " from player " + String.valueOf(sender) + " received.");
                try {
                    ServerEmotePacksManager.setPlayerEmote(sender, emoteId, fullEmoteData);
                }
                catch (ServerEmotePacksManager.OverflowException exception) {
                    DebugLogger.error("Cannot set emote " + emoteId + " from player " + String.valueOf(sender) + " as the pack will exceed the size limit.");
                    Player player = context.player();
                    player.sendSystemMessage((Component)Component.literal((String)(Component.translatable((String)"pop_up_emotes.sysmsg.player_pack_too_large").getString() + ServerEmotePacksManager.MAX_PACK_SIZE_BYTES / 1024 / 1024 + "Mb.")));
                }
                EmotePackChunkToServerPayload.sendEmotePackChunksToClients(sender, Map.of(emoteId, fullEmoteData));
                emoteMap.remove(emoteId);
                if (emoteMap.isEmpty()) {
                    playerBuffers.remove(sender);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"popupemotes.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendEmotePackChunksToClients(UUID senderUUID, Map<Integer, byte[]> emotes) {
        int CHUNK_SIZE = 32000;
        for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
            int emoteId = entry.getKey();
            byte[] data = entry.getValue();
            int totalChunks = (data.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(data.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(data, start, end);
                EmotePackChunkToClientPayload packet = new EmotePackChunkToClientPayload(senderUUID, emoteId, chunkIndex, totalChunks, chunk);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static class ChunkBuffer {
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        public ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
                return true;
            }
            return false;
        }

        public boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        public byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

