/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.stc;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EmotePackChunkToClientPayload(UUID senderUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EmotePackChunkToClientPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"popupemotes", (String)"emote_pack_chunk_to_client"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EmotePackChunkToClientPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EmotePackChunkToClientPayload::senderUUID, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToClientPayload::emoteId, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToClientPayload::chunkIndex, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToClientPayload::totalChunks, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, EmotePackChunkToClientPayload::chunkData, EmotePackChunkToClientPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnNetwork(EmotePackChunkToClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientEmotePacksManager.addChunk(payload.senderUUID(), payload.emoteId(), payload.chunkIndex(), payload.totalChunks(), payload.chunkData());
            if (ClientEmotePacksManager.isEmoteComplete(payload.senderUUID(), payload.emoteId())) {
                byte[] fullEmote = ClientEmotePacksManager.assembleEmote(payload.senderUUID(), payload.emoteId());
                ClientEmotePacksManager.cachePlayerEmote(payload.senderUUID(), payload.emoteId(), fullEmote);
                DebugLogger.debug("Emote data " + payload.emoteId() + " from player " + String.valueOf(payload.senderUUID()) + " received.");
            }
        });
    }
}

