/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientEmotePacksManager {
    public static final ResourceLocation[] EMOTE_TEXTURES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/emote8.png")};
    private static final Map<UUID, Map<Integer, byte[]>> cachedEmotePacks = new ConcurrentHashMap<UUID, Map<Integer, byte[]>>();
    private static Map<Integer, byte[]> cachedLocalEmotePack = null;
    private static Map<Integer, byte[]> cachedDefaultEmoteBytes = null;
    public static Map<UUID, Map<Integer, ChunkBuffer>> chunkBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();

    @Nullable
    public static Map<Integer, byte[]> getLocalEmotePack() {
        if (cachedLocalEmotePack != null && !cachedLocalEmotePack.isEmpty()) {
            return cachedLocalEmotePack;
        }
        Map<Integer, byte[]> fromDisk = ClientEmotePacksManager.loadLocalEmotePack();
        if (!fromDisk.isEmpty()) {
            cachedLocalEmotePack = fromDisk;
            return fromDisk;
        }
        return cachedLocalEmotePack;
    }

    public static void clearCache() {
        cachedEmotePacks.clear();
        cachedLocalEmotePack = null;
        cachedDefaultEmoteBytes = null;
    }

    public static void recreateCache() {
        ClientEmotePacksManager.clearCache();
        ClientEmotePacksManager.getLocalEmotePack();
        ClientEmotePacksManager.loadDefaultEmotesAsBytes();
    }

    private static Map<Integer, byte[]> loadLocalEmotePack() {
        HashMap<Integer, byte[]> emotesMap = new HashMap<Integer, byte[]>();
        try {
            Path baseFolder = ClientEmotePacksManager.getEmotePackFolder();
            DirectoryStream.Filter<Path> filter = entry -> {
                String name = entry.getFileName().toString().toLowerCase();
                return name.endsWith(".png");
            };
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(baseFolder, filter);){
                int index = 0;
                for (Path entry2 : stream) {
                    if (index >= 8) {
                        break;
                    }
                    try {
                        byte[] imageBytes = Files.readAllBytes(entry2);
                        NativeImage.read((InputStream)new ByteArrayInputStream(imageBytes));
                        emotesMap.put(index++, imageBytes);
                    }
                    catch (IOException e) {
                        System.err.println("Can't to load emote image " + String.valueOf(entry2) + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return emotesMap;
    }

    public static Map<Integer, byte[]> loadDefaultEmotesAsBytes() {
        if (cachedDefaultEmoteBytes != null) {
            return cachedDefaultEmoteBytes;
        }
        HashMap<Integer, byte[]> map = new HashMap<Integer, byte[]>();
        for (int i = 0; i < EMOTE_TEXTURES.length; ++i) {
            byte[] bytes = ClientEmotePacksManager.readResourceTextureToBytes(EMOTE_TEXTURES[i]);
            if (bytes == null) continue;
            map.put(i, bytes);
        }
        cachedDefaultEmoteBytes = map;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readResourceTextureToBytes(ResourceLocation resourceLocation) {
        try (InputStream inputStream = Minecraft.getInstance().getResourceManager().open(resourceLocation);){
            if (inputStream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearAllChunkBuffers() {
        chunkBuffers.clear();
        cachedEmotePacks.clear();
    }

    public static void cachePlayerEmotePack(UUID playerUUID, Map<Integer, byte[]> emotes) {
        cachedEmotePacks.put(playerUUID, emotes);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            cachedLocalEmotePack = emotes;
        }
    }

    public static Map<Integer, byte[]> getPlayerEmotePack(UUID playerUUID) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            return ClientEmotePacksManager.getLocalEmotePack();
        }
        return cachedEmotePacks.getOrDefault(playerUUID, Map.of());
    }

    public static void removePlayerEmotePack(UUID playerUUID) {
        cachedEmotePacks.remove(playerUUID);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            cachedLocalEmotePack = null;
        }
    }

    public static Path getEmotePackFolder() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("pop_emote_pack");
    }

    public static void addChunk(UUID playerUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        chunkBuffers.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).computeIfAbsent(emoteId, k -> new ChunkBuffer(totalChunks)).addChunk(chunkIndex, chunkData);
    }

    public static boolean isEmoteComplete(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return false;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        return buffer != null && buffer.isComplete();
    }

    public static byte[] assembleEmote(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return null;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        if (buffer == null || !buffer.isComplete()) {
            return null;
        }
        byte[] emote = buffer.assemble();
        emoteMap.remove(emoteId);
        if (emoteMap.isEmpty()) {
            chunkBuffers.remove(playerUUID);
        }
        return emote;
    }

    public static void cachePlayerEmote(UUID playerUUID, int emoteId, byte[] emoteData) {
        cachedEmotePacks.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(emoteId, emoteData);
    }

    private static class ChunkBuffer {
        int totalChunks;
        byte[][] chunks;
        int received = 0;

        ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.received;
                return true;
            }
            return false;
        }

        boolean isComplete() {
            return this.received == this.totalChunks;
        }

        byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

