/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.Config;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.gui.EmotePieOverlay;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

@OnlyIn(value=Dist.CLIENT)
public class PopUpEmotesConfigScreen
extends Screen {
    private ResourceLocation[] emoteTextures = new ResourceLocation[8];
    private float reloadTimeout = -1000.0f;
    private Button reloadButton = null;
    private ExtendedSlider emoteScaleSlider;
    private ExtendedSlider emoteVerticalOffsetSlider;
    private Checkbox brightEmotesCheckbox;

    public PopUpEmotesConfigScreen() {
        super((Component)Component.translatable((String)"pop_up_emotes.configuration.title"));
    }

    private void loadCustomEmoteTextures() {
        Map<Integer, byte[]> emotePack = ClientEmotePacksManager.getLocalEmotePack();
        if (emotePack == null) {
            emotePack = new HashMap<Integer, byte[]>();
        }
        Minecraft mc = Minecraft.getInstance();
        for (int i = 0; i < this.emoteTextures.length; ++i) {
            byte[] bytes = emotePack.get(i);
            if (bytes != null) {
                try {
                    ResourceLocation location;
                    NativeImage img = NativeImage.read((InputStream)new ByteArrayInputStream(bytes));
                    DynamicTexture texture = new DynamicTexture(img);
                    this.emoteTextures[i] = location = mc.getTextureManager().register("emote_" + i, texture);
                }
                catch (Exception e) {
                    this.emoteTextures[i] = null;
                    e.printStackTrace();
                }
                continue;
            }
            this.emoteTextures[i] = null;
        }
    }

    private void onConfirm() {
        boolean brightEmotes = this.brightEmotesCheckbox.selected();
        Config.brightEmotes.set((Object)brightEmotes);
        EmoteRenderer.brightEmotes = brightEmotes;
        double scale = this.emoteScaleSlider.getValue();
        Config.emoteScale.set((Object)scale);
        EmoteRenderer.emoteScale = (float)scale;
        double verticalOffset = this.emoteVerticalOffsetSlider.getValue();
        Config.emoteVerticalOffset.set((Object)verticalOffset);
        EmoteRenderer.emoteVerticalOffset = (float)verticalOffset;
        Config.SPEC.save();
    }

    private void onReset() {
        EmoteRenderer.brightEmotes = false;
        EmoteRenderer.emoteScale = 1.0f;
        EmoteRenderer.emoteVerticalOffset = 0.0f;
        Config.brightEmotes.set((Object)false);
        Config.emoteScale.set((Object)1.0);
        Config.emoteVerticalOffset.set((Object)0.0);
        Config.SPEC.save();
    }

    protected void init() {
        boolean inGame = this.minecraft != null && this.minecraft.level != null;
        this.brightEmotesCheckbox = Checkbox.builder((Component)Component.translatable((String)"pop_up_emotes.config.bright_emotes"), (Font)this.font).pos(this.width / 2 + 110, this.height / 2 - 60).selected(((Boolean)Config.brightEmotes.get()).booleanValue()).build();
        this.addRenderableWidget((GuiEventListener)this.brightEmotesCheckbox);
        this.reloadButton = Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.reload"), button -> {
            ClientEmotePacksManager.recreateCache();
            this.loadCustomEmoteTextures();
            EmotePieOverlay.reloadDynamicTextures();
            button.active = false;
            this.reloadTimeout = 20.0f;
        }).bounds(this.width / 2 - 100, this.height / 2, 200, 20).build();
        this.reloadButton.active = !inGame;
        this.addRenderableWidget((GuiEventListener)this.reloadButton);
        Button openFolderButton = Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.open_emotes_folder"), button -> {
            try {
                File folder = ClientEmotePacksManager.getEmotePackFolder().toFile();
                folder.mkdirs();
                if (folder.exists()) {
                    if (Desktop.isDesktopSupported() && !GraphicsEnvironment.isHeadless()) {
                        Desktop.getDesktop().open(folder);
                    } else {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("explorer " + folder.getAbsolutePath());
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec(new String[]{"open", folder.getAbsolutePath()});
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec(new String[]{"xdg-open", folder.getAbsolutePath()});
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).bounds(this.width / 2 - 100, this.height / 2 + 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)openFolderButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.save"), button -> {
            this.onConfirm();
            this.onClose();
        }).bounds(this.width / 2 - 100, this.height / 2 + 50, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 - 100, this.height / 2 + 74, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.reset"), button -> {
            this.onReset();
            this.onClose();
        }).bounds(this.width / 2 + 110, this.height / 2 + 74, 75, 20).build());
        if (!inGame) {
            this.loadCustomEmoteTextures();
        }
        this.emoteScaleSlider = new ExtendedSlider(this.width / 2 - 100, this.height / 2 - 60, 200, 20, (Component)Component.translatable((String)"pop_up_emotes.config.emote_scale_pref"), (Component)Component.translatable((String)"pop_up_emotes.config.emote_scale_suf"), 0.5, 1.5, ((Double)Config.emoteScale.get()).doubleValue(), 0.05, 2, true);
        this.addRenderableWidget((GuiEventListener)this.emoteScaleSlider);
        this.emoteVerticalOffsetSlider = new ExtendedSlider(this.width / 2 - 100, this.height / 2 - 30, 200, 20, (Component)Component.translatable((String)"pop_up_emotes.config.emote_vertical_pref"), (Component)Component.translatable((String)"pop_up_emotes.config.emote_vertical_suf"), -1.0, 1.0, ((Double)Config.emoteVerticalOffset.get()).doubleValue(), 0.05, 2, true);
        this.addRenderableWidget((GuiEventListener)this.emoteVerticalOffsetSlider);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
        if (this.reloadTimeout > -1000.0f) {
            this.reloadTimeout -= partialTicks;
            if (this.reloadTimeout <= 0.0f) {
                this.reloadButton.active = true;
                this.reloadTimeout = -1000.0f;
            }
        }
        int xStart = this.width / 2 - 88;
        int yStart = 25;
        int size = 22;
        Minecraft mc = Minecraft.getInstance();
        if (this.minecraft != null && this.minecraft.level != null) {
            String message = Component.translatable((String)"pop_up_emotes.config.reload_disabled").getString();
            int msgX = this.width / 2 - this.font.width(message) / 2;
            int n = yStart + size / 2;
            Objects.requireNonNull(this.font);
            int msgY = n - 9 / 2;
            graphics.drawString(this.font, message, msgX, msgY, -43691, false);
        } else {
            boolean anyEmotes = false;
            for (int i = 0; i < this.emoteTextures.length; ++i) {
                ResourceLocation tex = this.emoteTextures[i];
                if (tex == null) continue;
                anyEmotes = true;
                mc.getTextureManager().bindForSetup(tex);
                graphics.blit(tex, xStart + i * (size + 2), yStart, 0.0f, 0.0f, size, size, size, size);
            }
            if (!anyEmotes) {
                String noEmotesMsg = Component.translatable((String)"pop_up_emotes.config.no_emotes_found").getString();
                int msgX = this.width / 2 - this.font.width(noEmotesMsg) / 2;
                int n = yStart + size / 2;
                Objects.requireNonNull(this.font);
                int msgY = n - 9 / 2;
                graphics.drawString(this.font, noEmotesMsg, msgX, msgY, 0xFFFFFF, false);
            }
        }
    }

    private void drawTitle(GuiGraphics graphics) {
        int x = (this.width - this.font.width((FormattedText)this.title)) / 2;
        int y = 10;
        graphics.drawString(this.font, this.title, x, y, 0xFFFFFF, false);
    }
}

