/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.network.stc.EmoteToClientPayload;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EmoteToServerPayload(int emoteId, UUID senderUUID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EmoteToServerPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"emote_to_server"));
    public static final StreamCodec<FriendlyByteBuf, EmoteToServerPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EmoteToServerPayload::emoteId, (StreamCodec)UUIDUtil.STREAM_CODEC, EmoteToServerPayload::senderUUID, EmoteToServerPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnNetwork(EmoteToServerPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)context.player();
            if (sender == null) {
                return;
            }
            EmoteToClientPayload broadcastPayload = new EmoteToClientPayload(payload.emoteId(), payload.senderUUID());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)sender, (CustomPacketPayload)broadcastPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"pop_up_emotes.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

