/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPayload;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPayload;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPayload;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class PlayerJoinHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Map<UUID, Map<Integer, byte[]>> allEmotePacks = ServerEmotePacksManager.getAllPlayerEmotePacks();
        for (Map.Entry<UUID, Map<Integer, byte[]>> entry : allEmotePacks.entrySet()) {
            UUID playerUUID = entry.getKey();
            Map<Integer, byte[]> emotes = entry.getValue();
            PlayerJoinHandler.sendEmotePackChunksToPlayer(player2, playerUUID, emotes);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new RequestEmotePackToClientPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendEmotePackChunksToPlayer(ServerPlayer recipient, UUID emoteOwnerUUID, Map<Integer, byte[]> emotes) {
        int CHUNK_SIZE = 32000;
        for (Map.Entry<Integer, byte[]> emoteEntry : emotes.entrySet()) {
            int emoteId = emoteEntry.getKey();
            byte[] fullData = emoteEntry.getValue();
            int totalChunks = (fullData.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(fullData.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(fullData, start, end);
                EmotePackChunkToClientPayload payload = new EmotePackChunkToClientPayload(emoteOwnerUUID, emoteId, chunkIndex, totalChunks, chunk);
                PacketDistributor.sendToPlayer((ServerPlayer)recipient, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerExit(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.getUUID();
        ServerEmotePacksManager.removePlayerEmotePack(playerUUID);
        EmotePackChunkToServerPayload.playerBuffers.remove(playerUUID);
    }
}

