/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmotePackChunkScheduler;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="pop_up_emotes")
public class ClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec SPEC;
    public static final String CUSTOM_PACK_FOLDER_NAME = "pop_emote_pack";
    public static ModConfigSpec.BooleanValue isEnabled;
    public static ModConfigSpec.BooleanValue brightEmotes;
    public static ModConfigSpec.BooleanValue glowingEmotes;
    public static ModConfigSpec.DoubleValue emoteVerticalOffset;
    public static ModConfigSpec.DoubleValue emoteScale;
    public static ModConfigSpec.IntValue maxEmoteAmount;
    public static ModConfigSpec.IntValue maxPackSizeMB;
    public static ModConfigSpec.BooleanValue lowNetworkUsage;
    public static ModConfigSpec.IntValue maxPacketsPerTick;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            EmoteRenderer.emoteVerticalOffset = ((Double)emoteVerticalOffset.get()).floatValue();
            EmoteRenderer.emoteScale = ((Double)emoteScale.get()).floatValue();
            EmoteRenderer.brightEmotes = (Boolean)brightEmotes.get();
            EmoteRenderer.glowingEmotes = (Boolean)glowingEmotes.get();
            ClientEmotePacksManager.MAX_PACK_SIZE_BYTES = (Integer)maxPackSizeMB.get() * 1024 * 1024;
            ClientEmotePacksManager.MAX_PACK_EMOTE_AMOUNT = (Integer)maxEmoteAmount.get();
            EmotePackChunkScheduler.maxPacketsPerTick = (Boolean)lowNetworkUsage.get() != false ? 1 : Math.max((Integer)maxPacketsPerTick.get(), 1);
        }
    }

    static {
        BUILDER.comment("Pop-up Emotes Client Config");
        BUILDER.push("mod");
        isEnabled = BUILDER.define("isEnabled", true);
        BUILDER.pop();
        BUILDER.push("visual");
        brightEmotes = BUILDER.define("brightEmotes", false);
        glowingEmotes = BUILDER.define("glowingEmotes", false);
        emoteScale = BUILDER.defineInRange("emoteScale", 1.0, 0.5, 1.5);
        emoteVerticalOffset = BUILDER.defineInRange("emoteVerticalOffset", 0.0, -1.0, 1.0);
        BUILDER.pop();
        BUILDER.push("data");
        BUILDER.comment("The maximum local pack emotes amount. For server side value see your world's 'serverconfig' folder");
        maxEmoteAmount = BUILDER.defineInRange("maxEmoteAmount", 40, 8, 128);
        BUILDER.comment("This only sets client side local pack limit. For server side value see your world's 'serverconfig' folder.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 12, 1, 64);
        BUILDER.comment("If you have low internet bandwidth and are unsure how to adjust maxPacketsPerTick, enable this option. It limits max bandwidth used when sending/receiving emotes to ~640 KB/sec.");
        lowNetworkUsage = BUILDER.define("lowNetworkUsage", false);
        BUILDER.comment("Tell the server your desired limit for custom emote pack chunk packets sent per tick. Reduce this if you have low bandwidth.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet per tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 8 packets per tick (~5MB/sec).");
        maxPacketsPerTick = BUILDER.defineInRange("maxPacketsPerTick", 8, 1, 48);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

