/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="pop_up_emotes")
public class ServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec SPEC;
    public static ModConfigSpec.BooleanValue allowCustomPacks;
    public static ModConfigSpec.IntValue maxEmoteAmount;
    public static ModConfigSpec.IntValue maxPackSizeMB;
    public static ModConfigSpec.BooleanValue lowNetworkUsage;
    public static ModConfigSpec.IntValue maxPacketsPerTick;
    public static ModConfigSpec.IntValue maxPacketsPerTickPerPlayer;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        BUILDER.comment("Pop-up Emotes Server Config");
        BUILDER.push("data");
        BUILDER.comment("Allow clients to upload their custom emote packs.");
        allowCustomPacks = BUILDER.define("allowCustomPacks", true);
        BUILDER.comment("The maximum received per-player emote amount.");
        maxEmoteAmount = BUILDER.defineInRange("maxEmoteAmount", 40, 8, 128);
        BUILDER.comment("The maximum received per-player emote pack size, measured in megabytes.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 12, 1, 64);
        BUILDER.comment("If you have low internet bandwidth and are unsure how to adjust maxPacketsPerTick, enable this option. It limits max bandwidth used when sending/receiving emotes to ~640 KB/sec.");
        lowNetworkUsage = BUILDER.define("lowNetworkUsage", false);
        BUILDER.comment("Custom limit for emote pack chunk packets sent per tick. These packets are sent to players when they join the server. Reduce this value if the server has low bandwidth to balance usage.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet/tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 10 packets per tick (~6.5MB/sec).");
        maxPacketsPerTick = BUILDER.defineInRange("maxPacketsPerTick", 10, 1, 48);
        BUILDER.comment("*Per Player* Custom limit for emote pack chunk packets sent per tick. These packets are sent to player when they join the server.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet/tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 8 packets per tick (~5MB/sec).");
        maxPacketsPerTickPerPlayer = BUILDER.defineInRange("maxPacketsPerTickPerPlayer", 8, 1, 48);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

