/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientEmotePacksManager {
    public static final ResourceLocation[] DEFAULT_EMOTE_PACK = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/a_emote8.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/b_emote8.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/c_emote8.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/d_emote8.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote1.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote2.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote3.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote4.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote5.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote6.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote7.png"), ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/emotes/e_emote8.png")};
    private static final Map<UUID, Map<Integer, byte[]>> cachedEmotePacks = new ConcurrentHashMap<UUID, Map<Integer, byte[]>>();
    @Nullable
    private static Map<Integer, byte[]> cachedLocalEmotePack = null;
    @Nullable
    private static Map<Integer, byte[]> cachedDefaultEmoteBytes = null;
    public static int MAX_PACK_SIZE_BYTES = (Integer)ClientConfig.maxPackSizeMB.get() * 1024 * 1024;
    public static int MAX_PACK_EMOTE_AMOUNT = (Integer)ClientConfig.maxEmoteAmount.get();
    public static boolean lastLoadEncounterOversize = false;
    public static Map<UUID, Map<Integer, ChunkBuffer>> chunkBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();

    @Nullable
    public static Map<Integer, byte[]> getLocalEmotePack() {
        if (cachedLocalEmotePack != null && !cachedLocalEmotePack.isEmpty()) {
            return cachedLocalEmotePack;
        }
        Map<Integer, byte[]> fromDisk = ClientEmotePacksManager.loadLocalEmotePack();
        if (!fromDisk.isEmpty()) {
            cachedLocalEmotePack = fromDisk;
            return fromDisk;
        }
        return cachedLocalEmotePack;
    }

    public static int localEmotesAmount() {
        int min = DEFAULT_EMOTE_PACK.length;
        int local = 0;
        if (cachedLocalEmotePack != null) {
            local = cachedLocalEmotePack.size();
        }
        return Math.max(min, local);
    }

    public static boolean isCustomEmotesCacheBuilt() {
        return cachedLocalEmotePack != null;
    }

    public static void clearCache() {
        cachedEmotePacks.clear();
        cachedLocalEmotePack = null;
        cachedDefaultEmoteBytes = null;
    }

    public static void recreateCache() {
        ClientEmotePacksManager.clearCache();
        ClientEmotePacksManager.getLocalEmotePack();
        ClientEmotePacksManager.loadDefaultEmotesAsBytes();
    }

    private static Map<Integer, byte[]> loadLocalEmotePack() {
        lastLoadEncounterOversize = false;
        LinkedHashMap<Integer, byte[]> emotesMap = new LinkedHashMap<Integer, byte[]>();
        try {
            Path baseFolder = ClientEmotePacksManager.getEmotePackFolder();
            DirectoryStream.Filter<Path> filter = entry -> {
                String name = entry.getFileName().toString().toLowerCase();
                return name.endsWith(".png");
            };
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(baseFolder, filter);){
                int index = 0;
                int totalSize = 0;
                for (Path entry2 : stream) {
                    if (index >= MAX_PACK_EMOTE_AMOUNT) break;
                    try {
                        byte[] imageBytes = Files.readAllBytes(entry2);
                        NativeImage.read((InputStream)new ByteArrayInputStream(imageBytes));
                        if (totalSize + imageBytes.length > MAX_PACK_SIZE_BYTES) {
                            lastLoadEncounterOversize = true;
                            System.err.println("[Pop-up Emotes error] Skipping " + String.valueOf(entry2) + " because pack would exceed the " + String.valueOf(ClientConfig.maxPackSizeMB.get()) + " MB limit.");
                            break;
                        }
                        emotesMap.put(index++, imageBytes);
                        totalSize += imageBytes.length;
                    }
                    catch (IOException e) {
                        System.err.println("[Pop-up Emotes error] Can't load emote image " + String.valueOf(entry2) + ": " + e.getMessage());
                    }
                }
                if (totalSize > MAX_PACK_SIZE_BYTES) {
                    System.err.println("[Pop-up Emotes error] Total emote pack size exceeds limit! Only part of it was loaded.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return emotesMap;
    }

    @NotNull
    public static Map<Integer, byte[]> loadDefaultEmotesAsBytes() {
        if (cachedDefaultEmoteBytes != null) {
            return cachedDefaultEmoteBytes;
        }
        LinkedHashMap<Integer, byte[]> map = new LinkedHashMap<Integer, byte[]>();
        for (int i = 0; i < DEFAULT_EMOTE_PACK.length; ++i) {
            byte[] bytes = ClientEmotePacksManager.readResourceTextureToBytes(DEFAULT_EMOTE_PACK[i]);
            if (bytes == null) continue;
            map.put(i, bytes);
        }
        cachedDefaultEmoteBytes = map;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readResourceTextureToBytes(ResourceLocation resourceLocation) {
        try (InputStream inputStream = Minecraft.getInstance().getResourceManager().open(resourceLocation);){
            if (inputStream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearAllChunkBuffers() {
        chunkBuffers.clear();
        cachedEmotePacks.clear();
    }

    public static void cachePlayerEmotePack(UUID playerUUID, Map<Integer, byte[]> emotes) {
        cachedEmotePacks.put(playerUUID, emotes);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            cachedLocalEmotePack = emotes;
        }
    }

    public static Map<Integer, byte[]> getPlayerEmotePack(UUID playerUUID) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            return ClientEmotePacksManager.getLocalEmotePack();
        }
        return cachedEmotePacks.getOrDefault(playerUUID, Map.of());
    }

    public static void removePlayerEmotePack(UUID playerUUID) {
        cachedEmotePacks.remove(playerUUID);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getUUID().equals(playerUUID)) {
            cachedLocalEmotePack = null;
        }
    }

    public static Path getEmotePackFolder() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("pop_emote_pack");
    }

    public static void addChunk(UUID playerUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        chunkBuffers.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).computeIfAbsent(emoteId, k -> new ChunkBuffer(totalChunks)).addChunk(chunkIndex, chunkData);
    }

    public static boolean isEmoteComplete(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return false;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        return buffer != null && buffer.isComplete();
    }

    public static byte[] assembleEmote(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return null;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        if (buffer == null || !buffer.isComplete()) {
            return null;
        }
        byte[] emote = buffer.assemble();
        emoteMap.remove(emoteId);
        if (emoteMap.isEmpty()) {
            chunkBuffers.remove(playerUUID);
        }
        return emote;
    }

    public static void cachePlayerEmote(UUID playerUUID, int emoteId, byte[] emoteData) {
        cachedEmotePacks.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(emoteId, emoteData);
    }

    private static class ChunkBuffer {
        int totalChunks;
        byte[][] chunks;
        int received = 0;

        ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.received;
                return true;
            }
            return false;
        }

        boolean isComplete() {
            return this.received == this.totalChunks;
        }

        byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

