/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPayload;
import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class EmotePackChunkScheduler {
    public static int maxPacketsPerTick = 10;
    public static final ArrayDeque<EmotePackChunkToServerPayload> queue = new ArrayDeque();

    public static void schedule(EmotePackChunkToServerPayload packet) {
        queue.add(packet);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (queue.isEmpty()) {
            return;
        }
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        for (int i = 0; i < maxPacketsPerTick && !queue.isEmpty(); ++i) {
            EmotePackChunkToServerPayload payload = queue.poll();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        queue.clear();
    }
}

