/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.NametagRenderHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class EmoteRenderer {
    private static final int TICKS_FADE_IN = 5;
    private static final int TICKS_STATIC = 40;
    private static final int TICKS_FADE_OUT = 5;
    private static final int TOTAL_TICKS = 50;
    private static final float BASE_SIZE = 0.65f;
    public static float emoteVerticalOffset = 0.0f;
    public static float emoteScale = 1.0f;
    public static boolean brightEmotes = false;
    public static boolean glowingEmotes = false;
    private static final Map<UUID, EmoteData> activeEmotes = new HashMap<UUID, EmoteData>();
    private static final Map<UUID, ResourceLocation> emoteTextureLocations = new HashMap<UUID, ResourceLocation>();

    public static void showEmoteOnPlayer(UUID playerUUID, int emoteId) {
        NativeImage nativeImage;
        byte[] imageData;
        UUID localUUID = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getUUID() : null;
        Map<Integer, byte[]> emotes = localUUID != null && localUUID.equals(playerUUID) ? ClientEmotePacksManager.getLocalEmotePack() : ClientEmotePacksManager.getPlayerEmotePack(playerUUID);
        if (emotes == null) {
            emotes = new LinkedHashMap<Integer, byte[]>();
        }
        if ((imageData = emotes.get(emoteId)) == null || imageData.length == 0) {
            Map<Integer, byte[]> defaultEmotes = ClientEmotePacksManager.loadDefaultEmotesAsBytes();
            if (defaultEmotes.containsKey(emoteId)) {
                imageData = defaultEmotes.get(emoteId);
            } else {
                DebugLogger.error("[Popupemotes] EmoteRenderer.showEmoteOnPlayer No emote texture found for id: " + emoteId);
                return;
            }
        }
        try {
            nativeImage = NativeImage.read((InputStream)new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        DynamicTexture dynamicTexture = new DynamicTexture(() -> "emote_" + String.valueOf(playerUUID), nativeImage);
        EmoteData existing = activeEmotes.put(playerUUID, new EmoteData(emoteId, dynamicTexture));
        if (existing != null) {
            existing.close();
        }
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)("emote_" + String.valueOf(playerUUID)));
        Minecraft.getInstance().getTextureManager().register(textureLocation, (AbstractTexture)dynamicTexture);
        emoteTextureLocations.put(playerUUID, textureLocation);
        NametagRenderHandler.hideNametagForPlayer(playerUUID);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Iterator<Map.Entry<UUID, EmoteData>> iterator = activeEmotes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, EmoteData> entry = iterator.next();
            EmoteData emoteData = entry.getValue();
            ++emoteData.ageTicks;
            if (emoteData.ageTicks < 50) continue;
            emoteData.close();
            UUID playerUUID = entry.getKey();
            iterator.remove();
            emoteTextureLocations.remove(playerUUID);
            NametagRenderHandler.showNametagForPlayer(entry.getKey());
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent.AfterEntities event) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = event.getPoseStack();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        for (UUID playerUUID : activeEmotes.keySet()) {
            float height;
            float width;
            float scale;
            float alpha;
            Player entity;
            EmoteData emoteData = activeEmotes.get(playerUUID);
            ResourceLocation emoteResource = emoteTextureLocations.get(playerUUID);
            if (emoteResource == null || !((entity = mc.level.getPlayerByUUID(playerUUID)) instanceof Player)) continue;
            Player player = entity;
            LocalPlayer localPlayer = mc.player;
            if (localPlayer != null && player.getUUID().equals(localPlayer.getUUID()) && mc.options.getCameraType() == CameraType.FIRST_PERSON) continue;
            if (emoteData.ageTicks < 5) {
                alpha = progress = (float)emoteData.ageTicks / 5.0f;
                scale = emoteScale + (float)Math.sin((double)progress * Math.PI * 4.0) * 0.3f;
            } else if (emoteData.ageTicks < 45) {
                alpha = 1.0f;
                scale = emoteScale;
            } else {
                if (emoteData.ageTicks >= 50) continue;
                progress = (float)(emoteData.ageTicks - 5 - 40) / 5.0f;
                alpha = 1.0f - progress;
                scale = emoteScale - progress;
            }
            poseStack.pushPose();
            float partialTicks = mc.getDeltaTracker().getGameTimeDeltaPartialTick(true);
            double x = Mth.lerp((double)partialTicks, (double)player.xOld, (double)player.getX()) - camPos.x();
            double y = Mth.lerp((double)partialTicks, (double)player.yOld, (double)player.getY()) - camPos.y();
            double z = Mth.lerp((double)partialTicks, (double)player.zOld, (double)player.getZ()) - camPos.z();
            Vector3f camLookVecFloat = mc.gameRenderer.getMainCamera().getLookVector();
            Vec3 camLookVec = new Vec3((double)camLookVecFloat.x(), (double)camLookVecFloat.y(), (double)camLookVecFloat.z());
            double offsetTowardsCamera = 0.02;
            Vec3 offsetVec = camLookVec.scale(offsetTowardsCamera);
            poseStack.translate(x - offsetVec.x, y + (double)player.getBbHeight() + 0.5 + (double)emoteVerticalOffset, z - offsetVec.z);
            Camera camera = mc.getEntityRenderDispatcher().camera;
            if (camera == null) {
                return;
            }
            Quaternionf cameraRotation = camera.rotation();
            poseStack.mulPose((Quaternionfc)cameraRotation);
            poseStack.scale(scale, scale, scale);
            VertexConsumer vertexBuilder = mc.renderBuffers().bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)emoteResource));
            int imgWidth = emoteData.width;
            int imgHeight = emoteData.height;
            float aspectRatio = (float)imgWidth / (float)imgHeight;
            float maxSize = 0.65f;
            if (aspectRatio >= 1.0f) {
                width = maxSize;
                height = maxSize / aspectRatio;
            } else {
                width = maxSize * aspectRatio;
                height = maxSize;
            }
            float halfWidth = width / 2.0f;
            float halfHeight = height / 2.0f;
            int packedLight = brightEmotes ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)mc.level, (BlockPos)player.blockPosition());
            vertexBuilder.addVertex(poseStack.last().pose(), -halfWidth, halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuilder.addVertex(poseStack.last().pose(), -halfWidth, -halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuilder.addVertex(poseStack.last().pose(), halfWidth, -halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            vertexBuilder.addVertex(poseStack.last().pose(), halfWidth, halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            if (glowingEmotes) {
                mc.renderBuffers().bufferSource().endBatch(RenderType.entityTranslucentEmissive((ResourceLocation)emoteResource));
            } else {
                mc.renderBuffers().bufferSource().endBatch(RenderType.entityTranslucent((ResourceLocation)emoteResource));
            }
            poseStack.popPose();
        }
    }

    private static class EmoteData {
        final int emoteId;
        final DynamicTexture texture;
        int ageTicks = 0;
        int width = 32;
        int height = 32;

        EmoteData(int emoteId, DynamicTexture texture) {
            this.emoteId = emoteId;
            this.texture = texture;
            NativeImage pixels = texture.getPixels();
            if (pixels == null) {
                return;
            }
            this.width = pixels.getWidth();
            this.height = pixels.getHeight();
        }

        void close() {
            this.texture.close();
        }
    }
}

