/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.client.Keybindings;
import io.github.catomon.popupemotes.client.gui.EmotePieOverlay;
import io.github.catomon.popupemotes.network.cts.EmoteToServerPayload;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
class KeyInputHandler {
    private static boolean menuOpen = false;

    KeyInputHandler() {
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (!((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        KeyMapping key = (KeyMapping)Keybindings.EMOTE_MENU_KEY.get();
        if (event.getKey() == key.getKey().getValue()) {
            if (event.getAction() == 1 && !menuOpen) {
                if (mc.player != null && mc.screen == null) {
                    EmotePieOverlay.activate();
                    menuOpen = true;
                }
            } else if (event.getAction() == 0 && menuOpen) {
                int selectedEmoteId = EmotePieOverlay.selectedEmoteId();
                EmotePieOverlay.deactivate();
                if (selectedEmoteId > -1) {
                    UUID playerUUID = mc.player != null ? mc.player.getUUID() : null;
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new EmoteToServerPayload(selectedEmoteId, playerUUID), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                menuOpen = false;
            }
        }
    }
}

