/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="pop_up_emotes", value={Dist.CLIENT})
public class NametagRenderHandler {
    private static final HashSet<String> hiddenPlayers = new HashSet();

    public static void hideNametagForPlayer(UUID playerUuid) {
        String playerName = NametagRenderHandler.getPlayerName(playerUuid);
        if (playerName == null) {
            return;
        }
        hiddenPlayers.add(playerName);
    }

    public static void showNametagForPlayer(UUID playerUuid) {
        String playerName = NametagRenderHandler.getPlayerName(playerUuid);
        if (playerName == null) {
            return;
        }
        hiddenPlayers.remove(playerName);
    }

    @SubscribeEvent
    public static void onRenderNameplate(RenderNameTagEvent.DoRender event) {
        Component content = event.getContent();
        String playerName = content.getString();
        if (hiddenPlayers.contains(playerName)) {
            event.setCanceled(true);
        }
    }

    @Nullable
    private static String getPlayerName(UUID playerUuid) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        Player player = level.getPlayerByUUID(playerUuid);
        if (player == null) {
            return null;
        }
        Component component = player.getDisplayName();
        if (component == null) {
            return null;
        }
        return component.getString();
    }
}

