/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@EventBusSubscriber(modid="pop_up_emotes", value={Dist.CLIENT})
public class EmotePieOverlay {
    private static final int SLICE_COUNT = 8;
    private static final float RADIUS = 100.0f;
    private static final ResourceLocation SLICE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/pie_slice.png");
    private static final ResourceLocation ARROW_LEFT = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/arrow_left.png");
    private static final ResourceLocation ARROW_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/arrow_right.png");
    public static final int ARROW_WIDTH = 32;
    public static final int ARROW_HEIGHT = 32;
    private static final Map<Integer, DynamicTexture> dynamicEmoteTextures = new HashMap<Integer, DynamicTexture>();
    private static final Map<Integer, ResourceLocation> dynamicEmoteResourceLocations = new HashMap<Integer, ResourceLocation>();
    private static int selectedSlice = -1;
    private static boolean active = false;
    private static int currentPageIndex = 0;

    public static boolean isActive() {
        return active;
    }

    public static int selectedEmoteId() {
        if (selectedSlice < 0) {
            return -1;
        }
        int selectedEmoteId = selectedSlice + 8 * currentPageIndex;
        if (selectedEmoteId >= ClientEmotePacksManager.localEmotesAmount()) {
            return -1;
        }
        return selectedEmoteId;
    }

    public static void activate() {
        if (!active) {
            if (dynamicEmoteTextures.isEmpty()) {
                EmotePieOverlay.loadDynamicTextures();
            }
            active = true;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHandler.releaseMouse();
    }

    public static void deactivate() {
        if (active) {
            selectedSlice = -1;
            active = false;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHandler.grabMouse();
    }

    public static void reloadDynamicTextures() {
        EmotePieOverlay.closeAndClearTextures();
        EmotePieOverlay.loadDynamicTextures();
    }

    private static void closeAndClearTextures() {
        dynamicEmoteTextures.values().forEach(DynamicTexture::close);
        dynamicEmoteTextures.clear();
        dynamicEmoteResourceLocations.clear();
    }

    private static void loadDynamicTextures() {
        Map<Integer, byte[]> localEmotes = ClientEmotePacksManager.getLocalEmotePack();
        if (localEmotes == null || localEmotes.isEmpty()) {
            return;
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        int localPackAmount = localEmotes.size();
        for (int i = 0; i < (Integer)ClientConfig.maxEmoteAmount.get() && i < localPackAmount; ++i) {
            byte[] imageBytes = localEmotes.get(i);
            if (imageBytes == null) continue;
            try {
                int i2 = i;
                NativeImage nativeImage = NativeImage.read((InputStream)new ByteArrayInputStream(imageBytes));
                DynamicTexture texture = new DynamicTexture(() -> "emote_dynamic_" + i2, nativeImage);
                dynamicEmoteTextures.put(i, texture);
                ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)("emote_dynamic_" + i));
                Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
                dynamicEmoteResourceLocations.put(i, location);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        Matrix3x2f rotation2;
        float scale;
        Matrix3x2f rotation;
        float angleRad;
        int i;
        if (!active) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        EmotePieOverlay.drawPageNavArrowButtons(height, guiGraphics, width);
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f;
        guiGraphics.pose().pushMatrix();
        float sliceAngle = 45.0f;
        for (i = 0; i < 8; ++i) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate(centerX, centerY);
            angleRad = (float)Math.toRadians((float)i * sliceAngle);
            rotation = new Matrix3x2f();
            rotation.rotate(angleRad);
            guiGraphics.pose().mul((Matrix3x2fc)rotation);
            guiGraphics.pose().translate(50.0f, 0.0f);
            scale = i == selectedSlice ? 1.2f : 1.0f;
            guiGraphics.pose().scale(scale, scale);
            rotation2 = new Matrix3x2f();
            rotation2.rotate(-angleRad);
            guiGraphics.pose().mul((Matrix3x2fc)rotation2);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SLICE_TEXTURE, -23, -23, 0.0f, 0.0f, 46, 46, 46, 46);
            guiGraphics.pose().popMatrix();
        }
        for (i = 0; i < 8; ++i) {
            ResourceLocation emoteTexture;
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate(centerX, centerY);
            angleRad = (float)Math.toRadians((float)i * sliceAngle);
            rotation = new Matrix3x2f();
            rotation.rotate(angleRad);
            guiGraphics.pose().mul((Matrix3x2fc)rotation);
            guiGraphics.pose().translate(50.0f, 0.0f);
            scale = i == selectedSlice ? 1.2f : 1.0f;
            guiGraphics.pose().scale(scale, scale);
            rotation2 = new Matrix3x2f();
            rotation2.rotate(-angleRad);
            guiGraphics.pose().mul((Matrix3x2fc)rotation2);
            int textureIndex = i + currentPageIndex * 8;
            ResourceLocation textureLocation = dynamicEmoteResourceLocations.get(textureIndex);
            if (textureLocation != null) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureLocation, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            } else if (textureIndex < ClientEmotePacksManager.DEFAULT_EMOTE_PACK.length && (emoteTexture = ClientEmotePacksManager.DEFAULT_EMOTE_PACK[textureIndex]) != null) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, emoteTexture, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            }
            guiGraphics.pose().popMatrix();
        }
        guiGraphics.pose().popMatrix();
        Minecraft mc = Minecraft.getInstance();
        double mouseX = mc.mouseHandler.xpos() * (double)width / (double)mc.getWindow().getScreenWidth();
        double mouseY = mc.mouseHandler.ypos() * (double)height / (double)mc.getWindow().getScreenHeight();
        EmotePieOverlay.updateSelection((float)mouseX, (float)mouseY, width, height);
    }

    private static void drawPageNavArrowButtons(int height, GuiGraphics guiGraphics, int width) {
        if (EmotePieOverlay.maxPage() <= 1) {
            return;
        }
        int arrowY = height / 2 - 16;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ARROW_LEFT, 48, arrowY, 0.0f, 0.0f, 32, 32, 32, 32);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ARROW_RIGHT, width - 32 - 48, arrowY, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    @SubscribeEvent
    public static void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (EmotePieOverlay.isActive()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(InputEvent.MouseButton.Pre event) {
        if (!active) {
            return;
        }
        if (event.getAction() != 0) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int width = mc.getWindow().getGuiScaledWidth();
        double mouseX = mc.mouseHandler.xpos() * (double)width / (double)mc.getWindow().getScreenWidth();
        if (mouseX < (double)width / 2.0) {
            if (--currentPageIndex < 0) {
                currentPageIndex = EmotePieOverlay.maxPage() - 1;
            }
            event.setCanceled(true);
        }
        if (mouseX > (double)width / 2.0) {
            int maxPage = EmotePieOverlay.maxPage();
            if (++currentPageIndex >= maxPage) {
                currentPageIndex = 0;
            }
            event.setCanceled(true);
        }
    }

    private static int maxPage() {
        int min = ClientEmotePacksManager.DEFAULT_EMOTE_PACK.length;
        return (Math.max(min, dynamicEmoteTextures.size()) + 8 - 1) / 8;
    }

    private static void updateSelection(float mouseX, float mouseY, int screenWidth, int screenHeight) {
        float centerX = (float)screenWidth / 2.0f;
        float dx = mouseX - centerX;
        float centerY = (float)screenHeight / 2.0f;
        float dy = mouseY - centerY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 100.0 || distance < 20.0) {
            selectedSlice = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(dy, dx)) + 22.5;
        if (angle < 0.0) {
            angle += 360.0;
        }
        double sliceAngle = 45.0;
        selectedSlice = (int)(angle / sliceAngle);
    }
}

