/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.gui.EmotePieOverlay;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

public class PopUpEmotesConfigScreen
extends Screen {
    private ResourceLocation[] emoteTextures = new ResourceLocation[8];
    private float reloadTimeout = -1000.0f;
    private boolean packTooLargeWarn = false;
    private Button reloadButton;
    private ExtendedSlider emoteScaleSlider;
    private ExtendedSlider emoteVerticalOffsetSlider;
    private Checkbox brightEmotesCheckbox;
    private Checkbox glowingEmotesCheckbox;
    private Checkbox lowNetworkUsageCheckbox;
    private Checkbox modEnabled;

    public PopUpEmotesConfigScreen() {
        super((Component)Component.translatable((String)"pop_up_emotes.configuration.title"));
    }

    private void loadCustomEmoteTextures() {
        Map<Integer, byte[]> emotePack = ClientEmotePacksManager.getLocalEmotePack();
        if (emotePack == null) {
            emotePack = new HashMap<Integer, byte[]>();
        }
        Minecraft mc = Minecraft.getInstance();
        for (int i = 0; i < this.emoteTextures.length; ++i) {
            byte[] bytes = emotePack.get(i);
            if (bytes != null) {
                try {
                    NativeImage img = NativeImage.read((InputStream)new ByteArrayInputStream(bytes));
                    int i2 = i;
                    DynamicTexture texture = new DynamicTexture(() -> "emote_" + i2, img);
                    ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)("emote_" + i2));
                    mc.getTextureManager().register(location, (AbstractTexture)texture);
                    this.emoteTextures[i] = location;
                }
                catch (Exception e) {
                    this.emoteTextures[i] = null;
                    e.printStackTrace();
                }
                continue;
            }
            this.emoteTextures[i] = null;
        }
    }

    private void onConfirm() {
        boolean brightEmotes = this.brightEmotesCheckbox.selected();
        ClientConfig.brightEmotes.set((Object)brightEmotes);
        EmoteRenderer.brightEmotes = brightEmotes;
        boolean glowingEmotes = this.glowingEmotesCheckbox.selected();
        ClientConfig.glowingEmotes.set((Object)glowingEmotes);
        ClientConfig.lowNetworkUsage.set((Object)this.lowNetworkUsageCheckbox.selected());
        ClientConfig.isEnabled.set((Object)this.modEnabled.selected());
        double scale = this.emoteScaleSlider.getValue();
        ClientConfig.emoteScale.set((Object)scale);
        EmoteRenderer.emoteScale = (float)scale;
        double verticalOffset = this.emoteVerticalOffsetSlider.getValue();
        ClientConfig.emoteVerticalOffset.set((Object)verticalOffset);
        EmoteRenderer.emoteVerticalOffset = (float)verticalOffset;
        ClientConfig.SPEC.save();
    }

    private void onReset() {
        EmoteRenderer.brightEmotes = false;
        EmoteRenderer.emoteScale = 1.0f;
        EmoteRenderer.emoteVerticalOffset = 0.0f;
        ClientConfig.brightEmotes.set((Object)true);
        ClientConfig.glowingEmotes.set((Object)false);
        ClientConfig.emoteScale.set((Object)1.0);
        ClientConfig.emoteVerticalOffset.set((Object)0.0);
        ClientConfig.lowNetworkUsage.set((Object)false);
        ClientConfig.isEnabled.set((Object)true);
        ClientConfig.SPEC.save();
    }

    protected void init() {
        boolean inGame = this.minecraft != null && this.minecraft.level != null;
        this.brightEmotesCheckbox = Checkbox.builder((Component)Component.translatable((String)"pop_up_emotes.config.bright_emotes"), (Font)this.font).pos(this.width / 2 + 110, this.height / 2 - 60).selected(((Boolean)ClientConfig.brightEmotes.get()).booleanValue()).build();
        this.addRenderableWidget((GuiEventListener)this.brightEmotesCheckbox);
        this.glowingEmotesCheckbox = Checkbox.builder((Component)Component.translatable((String)"pop_up_emotes.config.glowing_emotes"), (Font)this.font).pos(this.width / 2 + 110, this.height / 2 - 35).selected(((Boolean)ClientConfig.glowingEmotes.get()).booleanValue()).build();
        this.glowingEmotesCheckbox.active = false;
        this.addRenderableWidget((GuiEventListener)this.glowingEmotesCheckbox);
        this.lowNetworkUsageCheckbox = Checkbox.builder((Component)Component.translatable((String)"pop_up_emotes.config.low_network_usage"), (Font)this.font).pos(this.width / 2 + 110, this.height / 2 - 10).selected(((Boolean)ClientConfig.lowNetworkUsage.get()).booleanValue()).build();
        this.addRenderableWidget((GuiEventListener)this.lowNetworkUsageCheckbox);
        this.modEnabled = Checkbox.builder((Component)Component.translatable((String)"pop_up_emotes.config.mod_enabled"), (Font)this.font).pos(this.width / 2 + 110, this.height / 2 + 15).selected(((Boolean)ClientConfig.isEnabled.get()).booleanValue()).build();
        this.addRenderableWidget((GuiEventListener)this.modEnabled);
        this.reloadButton = Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.reload"), button -> {
            ClientEmotePacksManager.recreateCache();
            this.loadCustomEmoteTextures();
            EmotePieOverlay.reloadDynamicTextures();
            button.active = false;
            this.reloadTimeout = 20.0f;
            this.packTooLargeWarn = ClientEmotePacksManager.lastLoadEncounterOversize;
        }).bounds(this.width / 2 - 100, this.height / 2, 200, 20).build();
        this.reloadButton.active = !inGame;
        this.addRenderableWidget((GuiEventListener)this.reloadButton);
        Button openFolderButton = Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.open_emotes_folder"), button -> {
            try {
                File folder = ClientEmotePacksManager.getEmotePackFolder().toFile();
                folder.mkdirs();
                if (folder.exists()) {
                    if (Desktop.isDesktopSupported() && !GraphicsEnvironment.isHeadless()) {
                        Desktop.getDesktop().open(folder);
                    } else {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("explorer " + folder.getAbsolutePath());
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec(new String[]{"open", folder.getAbsolutePath()});
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec(new String[]{"xdg-open", folder.getAbsolutePath()});
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).bounds(this.width / 2 - 100, this.height / 2 + 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)openFolderButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.save"), button -> {
            this.onConfirm();
            this.onClose();
        }).bounds(this.width / 2 - 100, this.height / 2 + 50, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 - 100, this.height / 2 + 74, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"pop_up_emotes.config.reset"), button -> {
            this.onReset();
            this.onClose();
        }).bounds(this.width / 2 + 110, this.height / 2 + 74, 75, 20).build());
        if (!inGame) {
            this.loadCustomEmoteTextures();
            this.packTooLargeWarn = ClientEmotePacksManager.lastLoadEncounterOversize;
        }
        this.emoteScaleSlider = new ExtendedSlider(this.width / 2 - 100, this.height / 2 - 60, 200, 20, (Component)Component.translatable((String)"pop_up_emotes.config.emote_scale_pref"), (Component)Component.translatable((String)"pop_up_emotes.config.emote_scale_suf"), 0.5, 1.5, ((Double)ClientConfig.emoteScale.get()).doubleValue(), 0.05, 2, true);
        this.addRenderableWidget((GuiEventListener)this.emoteScaleSlider);
        this.emoteVerticalOffsetSlider = new ExtendedSlider(this.width / 2 - 100, this.height / 2 - 30, 200, 20, (Component)Component.translatable((String)"pop_up_emotes.config.emote_vertical_pref"), (Component)Component.translatable((String)"pop_up_emotes.config.emote_vertical_suf"), -1.0, 1.0, ((Double)ClientConfig.emoteVerticalOffset.get()).doubleValue(), 0.05, 2, true);
        this.addRenderableWidget((GuiEventListener)this.emoteVerticalOffsetSlider);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
        if (this.reloadTimeout > -1000.0f) {
            this.reloadTimeout -= partialTicks;
            if (this.reloadTimeout <= 0.0f) {
                this.reloadButton.active = true;
                this.reloadTimeout = -1000.0f;
            }
        }
        int xStart = this.width / 2 - 88;
        int yStart = 25;
        int size = 22;
        Minecraft mc = Minecraft.getInstance();
        if (this.minecraft != null && this.minecraft.level != null) {
            String message = Component.translatable((String)"pop_up_emotes.config.reload_disabled").getString();
            int msgX = this.width / 2 - this.font.width(message) / 2;
            int n = yStart + size / 2;
            Objects.requireNonNull(this.font);
            int msgY = n - 9 / 2;
            graphics.drawString(this.font, message, msgX, msgY, -43691, false);
        } else if (this.packTooLargeWarn) {
            String message = Component.translatable((String)"pop_up_emotes.config.reload_pack_too_large").getString() + ClientEmotePacksManager.MAX_PACK_SIZE_BYTES / 1024 / 1024 + "Mb.";
            int msgX = this.width / 2 - this.font.width(message) / 2;
            int n = yStart + size / 2;
            Objects.requireNonNull(this.font);
            int msgY = n - 9 / 2;
            graphics.drawString(this.font, message, msgX, msgY, -43691, false);
        } else {
            boolean anyEmotes = false;
            for (int i = 0; i < this.emoteTextures.length; ++i) {
                ResourceLocation tex = this.emoteTextures[i];
                if (tex == null) continue;
                anyEmotes = true;
                graphics.blit(tex, xStart + i * (size + 2), yStart, 0, 0, (float)size, (float)size, (float)size, (float)size);
            }
            if (!anyEmotes) {
                String noEmotesMsg = Component.translatable((String)"pop_up_emotes.config.no_emotes_found").getString();
                int msgX = this.width / 2 - this.font.width(noEmotesMsg) / 2;
                int n = yStart + size / 2;
                Objects.requireNonNull(this.font);
                int msgY = n - 9 / 2;
                graphics.drawString(this.font, noEmotesMsg, msgX, msgY, 0xFFFFFF, false);
            }
        }
    }

    private void drawTitle(GuiGraphics graphics) {
        int x = (this.width - this.font.width((FormattedText)this.title)) / 2;
        int y = 10;
        graphics.drawString(this.font, this.title, x, y, 0xFFFFFF, false);
    }
}

