/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network;

import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmotePackChunkScheduler;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.ModSounds;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPayload;
import io.github.catomon.popupemotes.network.cts.EnabledResponseToServerPayload;
import io.github.catomon.popupemotes.network.stc.CustomPacksDisabledToClientPayload;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPayload;
import io.github.catomon.popupemotes.network.stc.IsModEnabledRequestToClientPayload;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPayload;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleOnNetwork(RequestEmotePackToClientPayload _payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            UUID playerUUID = player.getUUID();
            Map<Integer, byte[]> emotes = ClientEmotePacksManager.getLocalEmotePack();
            if (emotes == null) {
                emotes = new HashMap<Integer, byte[]>();
            }
            int CHUNK_SIZE = 32000;
            for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
                int emoteId = entry.getKey();
                byte[] data = entry.getValue();
                int totalChunks = (data.length + 32000 - 1) / 32000;
                for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                    int start = chunkIndex * 32000;
                    int end = Math.min(data.length, start + 32000);
                    byte[] chunk = Arrays.copyOfRange(data, start, end);
                    EmotePackChunkToServerPayload packet = new EmotePackChunkToServerPayload(playerUUID, emoteId, chunkIndex, totalChunks, chunk);
                    EmotePackChunkScheduler.schedule(packet);
                }
            }
        }).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    public static void handleOnNetwork(EmoteToClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            Player player = mc.level.getPlayerByUUID(payload.senderUUID());
            if (player != null) {
                EmoteRenderer.showEmoteOnPlayer(player.getUUID(), payload.emoteId());
                mc.level.playLocalSound(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), (SoundEvent)ModSounds.EMOTE_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }).exceptionally(e -> {
            DebugLogger.error("Failed to process emote chunk", e);
            return null;
        });
    }

    public static void handle(IsModEnabledRequestToClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                DebugLogger.debug("Sending EnabledResponseToServerPacket");
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new EnabledResponseToServerPayload((Integer)ClientConfig.maxPacketsPerTick.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public static void handle(CustomPacksDisabledToClientPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                if (Minecraft.getInstance().player == null) {
                    return;
                }
                Map<Integer, byte[]> localEmotePack = ClientEmotePacksManager.getLocalEmotePack();
                if (localEmotePack == null) {
                    return;
                }
                if (localEmotePack.isEmpty()) {
                    return;
                }
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"\u00a7c[Pop-up Emotes] Custom packs are disallowed on this server!."), false);
            }
        });
    }
}

