/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.server.EmotePackPacketScheduler;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public record EmotePackChunkToServerPayload(UUID senderUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) implements CustomPacketPayload
{
    private static final int CHUNK_SIZE = 32000;
    public static final CustomPacketPayload.Type<EmotePackChunkToServerPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"emote_pack_chunk_to_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EmotePackChunkToServerPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EmotePackChunkToServerPayload::senderUUID, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::emoteId, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::chunkIndex, (StreamCodec)ByteBufCodecs.INT, EmotePackChunkToServerPayload::totalChunks, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, EmotePackChunkToServerPayload::chunkData, EmotePackChunkToServerPayload::new);
    public static final Map<UUID, Map<Integer, ChunkBuffer>> playerBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();
    private static String playerWarnedId;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnNetwork(EmotePackChunkToServerPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!((Boolean)ServerConfig.allowCustomPacks.get()).booleanValue()) {
                return;
            }
            UUID sender = payload.senderUUID;
            Player player = context.player();
            int emoteId = payload.emoteId();
            playerBuffers.putIfAbsent(sender, new ConcurrentHashMap());
            Map<Integer, ChunkBuffer> emoteMap = playerBuffers.get(sender);
            emoteMap.putIfAbsent(emoteId, new ChunkBuffer(payload.totalChunks()));
            ChunkBuffer buffer = emoteMap.get(emoteId);
            boolean added = buffer.addChunk(payload.chunkIndex(), payload.chunkData());
            if (!added) {
                DebugLogger.debug("[EmotePackChunkToServerPayload.handleOnNetwork] Duplicate or out of bound chunk for emote " + emoteId);
                return;
            }
            if (buffer.isComplete()) {
                byte[] fullEmoteData;
                block7: {
                    fullEmoteData = buffer.assemble();
                    DebugLogger.debug("Emote data " + emoteId + " from player " + String.valueOf(sender) + " received.");
                    try {
                        ServerEmotePacksManager.setPlayerEmote(sender, emoteId, fullEmoteData);
                    }
                    catch (ServerEmotePacksManager.OverflowException exception) {
                        DebugLogger.error("Cannot set emote " + emoteId + " from player " + String.valueOf(sender) + " as the pack will exceed the size limit.");
                        if (Objects.equals(playerWarnedId, player.getStringUUID())) break block7;
                        player.displayClientMessage((Component)Component.literal((String)("\u00a7c" + Component.translatable((String)"pop_up_emotes.sysmsg.player_pack_too_large").getString() + ServerEmotePacksManager.MAX_PACK_SIZE_BYTES / 1024 / 1024 + "Mb. " + Component.translatable((String)"pop_up_emotes.sysmsg.server_emote_amount_limit").getString() + ServerEmotePacksManager.MAX_PACK_EMOTE_AMOUNT + ".")), false);
                        playerWarnedId = player.getStringUUID();
                    }
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EmotePackChunkToServerPayload.scheduleSendEmoteToPlayers(serverPlayer, Map.of(emoteId, fullEmoteData));
                }
                emoteMap.remove(emoteId);
                if (emoteMap.isEmpty()) {
                    playerBuffers.remove(sender);
                }
            }
        }).exceptionally(e -> {
            DebugLogger.error("Failed to process emote chunk", e);
            return null;
        });
    }

    public static void scheduleSendEmoteToPlayers(ServerPlayer emotesOwnerPlayer, Map<Integer, byte[]> emotes) {
        UUID ownerUUID = emotesOwnerPlayer.getUUID();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer targetPlayer : players) {
            if (targetPlayer.getUUID().equals(ownerUUID)) continue;
            EmotePackPacketScheduler.enqueueEmoteChunkPacket(targetPlayer, ownerUUID, emotes);
        }
    }

    public static class ChunkBuffer {
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        public ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
                return true;
            }
            return false;
        }

        public boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        public byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

