/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPayload;
import io.github.catomon.popupemotes.server.EmotePackPacketScheduler;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EnabledResponseToServerPayload(int maxPacketsPerTick) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnabledResponseToServerPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"enabled_response"));
    public static final StreamCodec<FriendlyByteBuf, EnabledResponseToServerPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EnabledResponseToServerPayload::maxPacketsPerTick, EnabledResponseToServerPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleOnNetwork(EnabledResponseToServerPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            if (!((Boolean)ServerConfig.allowCustomPacks.get()).booleanValue()) {
                return;
            }
            Map<UUID, Map<Integer, byte[]>> allEmotePacks = ServerEmotePacksManager.getAllPlayerEmotePacks();
            DebugLogger.debug("Sending Emote Packs To Player");
            EmotePackPacketScheduler.sendEmotePacksToPlayer(player, allEmotePacks, payload.maxPacketsPerTick());
            DebugLogger.debug("Sending RequestEmotePackToClientPacket");
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RequestEmotePackToClientPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }
}

