/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import io.github.catomon.popupemotes.client.ClientEmoteChunkScheduler;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.server.ServerEmoteChunkScheduler;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="pop_up_emotes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static final String CUSTOM_PACK_FOLDER_NAME = "pop_emote_pack";
    public static ForgeConfigSpec.BooleanValue isEnabled;
    public static ForgeConfigSpec.BooleanValue brightEmotes;
    public static ForgeConfigSpec.BooleanValue glowingEmotes;
    public static ForgeConfigSpec.DoubleValue emoteVerticalOffset;
    public static ForgeConfigSpec.DoubleValue emoteScale;
    public static ForgeConfigSpec.IntValue resourcePackEmoteAmount;
    public static ForgeConfigSpec.IntValue maxEmoteAmount;
    public static ForgeConfigSpec.IntValue maxPackSizeMB;
    public static ForgeConfigSpec.BooleanValue lowNetworkUsage;
    public static ForgeConfigSpec.IntValue maxPacketsPerTick;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> emotePackUrls;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            EmoteRenderer.emoteVerticalOffset = ((Double)emoteVerticalOffset.get()).floatValue();
            EmoteRenderer.emoteScale = ((Double)emoteScale.get()).floatValue();
            EmoteRenderer.brightEmotes = (Boolean)brightEmotes.get();
            EmoteRenderer.glowingEmotes = (Boolean)glowingEmotes.get();
            ClientEmotePacksManager.MAX_PACK_SIZE_BYTES = (Integer)maxPackSizeMB.get() * 1024 * 1024;
            ClientEmotePacksManager.MAX_PACK_EMOTE_AMOUNT = (Integer)maxEmoteAmount.get();
            if (((Boolean)lowNetworkUsage.get()).booleanValue()) {
                ClientEmoteChunkScheduler.maxPacketsPerTick = 1;
                ServerEmoteChunkScheduler.maxPacketsPerTick = 1;
            } else {
                ClientEmoteChunkScheduler.maxPacketsPerTick = 2;
                ServerEmoteChunkScheduler.maxPacketsPerTick = Math.max((Integer)maxPacketsPerTick.get(), 1);
            }
        }
    }

    static {
        BUILDER.comment("Pop-up Emotes Client Config");
        BUILDER.push("mod");
        isEnabled = BUILDER.define("isEnabled", true);
        BUILDER.pop();
        BUILDER.push("visual");
        brightEmotes = BUILDER.define("brightEmotes", false);
        glowingEmotes = BUILDER.define("glowingEmotes", false);
        emoteScale = BUILDER.defineInRange("emoteScale", 1.0, 0.5, 1.5);
        emoteVerticalOffset = BUILDER.defineInRange("emoteVerticalOffset", 0.0, -1.0, 1.0);
        BUILDER.pop();
        BUILDER.push("data_1_3_6");
        BUILDER.comment("If you are using resource pack to change emotes, set this value to the amount of emotes changed by it to hide mod's default emotes.");
        resourcePackEmoteAmount = BUILDER.defineInRange("resourcePackEmoteAmount", 40, 8, 40);
        BUILDER.comment("The maximum local pack emotes amount. For server side value see your world's 'serverconfig' folder");
        maxEmoteAmount = BUILDER.defineInRange("maxEmoteAmount", 24, 8, 40);
        BUILDER.comment("This only sets client side local pack limit. For server side value see your world's 'serverconfig' folder.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 8, 1, 12);
        BUILDER.comment("If you have low internet bandwidth and are unsure how to adjust maxPacketsPerTick, enable this option. It limits max bandwidth used when sending/receiving emotes to ~640 KB/sec.");
        lowNetworkUsage = BUILDER.define("lowNetworkUsage", false);
        BUILDER.comment("Tell the server your desired limit for custom emote pack chunk packets sent per tick. Reduce this if you have low bandwidth.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet per tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 2 packets per tick (~1.2MB/sec).");
        maxPacketsPerTick = BUILDER.defineInRange("maxPacketsPerTick", 2, 1, 16);
        BUILDER.pop();
        BUILDER.push("emote_pack_urls");
        emotePackUrls = BUILDER.comment("List of emote image URLs").defineList("emotePackUrls", List.of(), url -> {
            if (!(url instanceof String)) {
                return false;
            }
            String s = (String)url;
            return !s.isEmpty() && s.length() <= 256;
        });
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

